/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntCreateTargetFix
implements LocalQuickFix {
    @NonNls
    private static final String TAG_NAME = "target";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NlsSafe
    private final String myCanonicalText;

    public AntCreateTargetFix(@NlsSafe String canonicalText) {
        this.myCanonicalText = canonicalText;
    }

    @NotNull
    public String getName() {
        String string = AntBundle.message("ant.create.target.intention.description", this.myCanonicalText);
        if (string == null) {
            AntCreateTargetFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AntBundle.message("ant.intention.create.target.family.name", new Object[0]);
        if (string == null) {
            AntCreateTargetFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlFile xmlFile;
        XmlTag rootTag;
        if (project == null) {
            AntCreateTargetFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AntCreateTargetFix.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        Navigatable result = null;
        if (containingFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)containingFile).getRootTag()) != null) {
            Object generated;
            XmlTag propTag = rootTag.createChildTag(TAG_NAME, rootTag.getNamespace(), "", false);
            propTag.setAttribute(NAME_ATTR, this.myCanonicalText);
            DomElement contextElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement());
            if (contextElement == null) {
                generated = rootTag.addSubTag(propTag, true);
            } else {
                AntDomTarget containingTarget = (AntDomTarget)contextElement.getParentOfType(AntDomTarget.class, false);
                AntDomTarget anchor = containingTarget != null ? containingTarget : contextElement;
                XmlTag tag = anchor.getXmlTag();
                generated = !rootTag.equals(tag) ? tag.getParent().addBefore((PsiElement)propTag, (PsiElement)tag) : rootTag.addSubTag(propTag, true);
            }
            if (generated instanceof XmlTag) {
                result = PsiNavigationSupport.getInstance().createNavigatable(project, containingFile.getVirtualFile(), generated.getValue().getTextRange().getEndOffset());
            }
            if (result == null && generated instanceof Navigatable) {
                result = (Navigatable)generated;
            }
        }
        if (result != null) {
            result.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/quickfix/AntCreateTargetFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/quickfix/AntCreateTargetFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

