/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import git4idea.actions.GitCheckoutAction;
import git4idea.actions.GitSingleCommitActionGroup;
import git4idea.i18n.GitBundle;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J;\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0013J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lgit4idea/actions/GitCheckoutActionGroup;", "Lgit4idea/actions/GitSingleCommitActionGroup;", "()V", "getCheckoutRevisionAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "commit", "Lcom/intellij/vcs/log/CommitId;", "useShortText", "", "getChildren", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "log", "Lcom/intellij/vcs/log/VcsLog;", "repository", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/VcsLog;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/CommitId;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getRefNames", "", "", "intellij.vcs.git"})
public final class GitCheckoutActionGroup
extends GitSingleCommitActionGroup {
    @Override
    @NotNull
    public AnAction[] getChildren(@NotNull AnActionEvent e, @NotNull Project project, @NotNull VcsLog log, @NotNull GitRepository repository, @NotNull CommitId commit) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        List<String> refNames = this.getRefNames(e, log, repository);
        ArrayList<GitCheckoutAction> actions2 = new ArrayList<GitCheckoutAction>();
        for (String refName : refNames) {
            actions2.add(new GitCheckoutAction(project, repository, refName, refName));
        }
        Collection collection = actions2;
        boolean bl = false;
        boolean hasMultipleActions = !collection.isEmpty();
        actions2.add((GitCheckoutAction)this.getCheckoutRevisionAction(commit, hasMultipleActions));
        DefaultActionGroup mainGroup = new DefaultActionGroup(GitBundle.message("git.log.action.checkout.group", new Object[0]), (List)actions2);
        mainGroup.setPopup(hasMultipleActions);
        return new AnAction[]{(AnAction)mainGroup};
    }

    private final AnAction getCheckoutRevisionAction(CommitId commit, boolean useShortText) {
        String string = commit.getHash().toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.hash.toShortString()");
        String hashString = string;
        String string2 = useShortText ? GitBundle.message("git.log.action.checkout.revision.short.text", hashString) : GitBundle.message("git.log.action.checkout.revision.full.text", hashString);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (useShortText) {\n    \u2026.text\", hashString)\n    }");
        String checkoutRevisionText = string2;
        AnAction checkoutRevision = ActionManager.getInstance().getAction("Git.CheckoutRevision");
        AnAction anAction = EmptyAction.wrap((AnAction)checkoutRevision);
        boolean bl = false;
        boolean bl2 = false;
        AnAction it = anAction;
        boolean bl3 = false;
        AnAction anAction2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"it");
        Presentation presentation = anAction2.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"it.templatePresentation");
        presentation.setText(checkoutRevisionText);
        AnAction anAction3 = anAction;
        Intrinsics.checkNotNullExpressionValue((Object)anAction3, (String)"EmptyAction.wrap(checkou\u2026 = checkoutRevisionText }");
        return anAction3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRefNames(AnActionEvent e, VcsLog log, GitRepository repository) {
        void $this$mapTo$iv$iv;
        void destination$iv;
        Object element$iv2;
        void $this$filterTo$iv;
        List list2 = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List refs = list2;
        Iterable iterable = refs;
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv2 : $this$filterTo$iv) {
            VcsRef it = (VcsRef)element$iv2;
            boolean bl2 = false;
            VcsRef vcsRef = it;
            Intrinsics.checkNotNullExpressionValue((Object)vcsRef, (String)"it");
            if (!Intrinsics.areEqual((Object)vcsRef.getType(), (Object)GitRefManager.LOCAL_BRANCH)) continue;
            destination$iv.add(element$iv2);
        }
        List localBranches = (List)destination$iv;
        VcsLogProvider provider = (VcsLogProvider)log.getLogProviders().get(repository.getRoot());
        if (provider != null) {
            VcsLogRefManager vcsLogRefManager = provider.getReferenceManager();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogRefManager, (String)"provider.referenceManager");
            ContainerUtil.sort((List)localBranches, (Comparator)vcsLogRefManager.getLabelsOrderComparator());
        }
        Iterable $this$map$iv = localBranches;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsRef vcsRef = (VcsRef)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            String string = v3.getName();
            collection2.add(string);
        }
        List refNames = (List)destination$iv$iv;
        String string = repository.getCurrentBranchName();
        if (string == null) {
            return refNames;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.currentBranchName ?: return refNames");
        String currentBranchName = string;
        return CollectionsKt.minus((Iterable)refNames, (Object)currentBranchName);
    }

    public GitCheckoutActionGroup() {
        String string = GitBundle.message("git.log.action.checkout.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.log.action.checkout.group\")");
        super(string, false);
    }
}

