/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitFileAnnotation;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"getAnnotationFromCache", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
public final class GitAnnotationProviderKt {
    @Nullable
    public static final FileAnnotation getAnnotationFromCache(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file);
        if (gitRepository == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"GitRepositoryManager.get\u2026uick(file) ?: return null");
        GitRepository repository = gitRepository;
        String string = repository.getCurrentRevision();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repository.currentRevision ?: return null");
        String currentRevision = string;
        VcsCacheManager vcsCacheManager = VcsCacheManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsCacheManager, (String)"VcsCacheManager.getInstance(project)");
        VcsHistoryCache cache2 = vcsCacheManager.getVcsHistoryCache();
        FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file));
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(projec\u2026csUtil.getFilePath(file))");
        FilePath filePath2 = filePath;
        VcsRevisionNumber vcsRevisionNumber = cache2.getLastRevision(filePath2, GitVcs.getKey(), (VcsRevisionNumber)new GitRevisionNumber(currentRevision));
        if (vcsRevisionNumber == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsRevisionNumber, (String)"cache.getLastRevision(fi\u2026Revision)) ?: return null");
        VcsRevisionNumber lastRevision = vcsRevisionNumber;
        Object object = cache2.getAnnotation(filePath2, GitVcs.getKey(), lastRevision);
        if (!(object instanceof GitAnnotationProvider.CachedData)) {
            object = null;
        }
        GitAnnotationProvider.CachedData cachedData = (GitAnnotationProvider.CachedData)object;
        if (cachedData == null) {
            return null;
        }
        GitAnnotationProvider.CachedData annotationData = cachedData;
        return new GitFileAnnotation(project, file, lastRevision, annotationData.lines);
    }
}

