/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import git4idea.branch.DeepComparator;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            DeepCompareAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        MainVcsLogUi ui = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || dataProvider == null || ui == null) {
            return false;
        }
        return DeepComparator.getInstance(project, dataProvider, (VcsLogUi)ui).hasHighlightingOrInProgress();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        if (e == null) {
            DeepCompareAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        MainVcsLogUi ui = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || dataProvider == null || ui == null) {
            return;
        }
        DeepComparator dc = DeepComparator.getInstance(project, dataProvider, (VcsLogUi)ui);
        if (selected) {
            VcsLogUsageTriggerCollector.triggerUsage((AnActionEvent)e, (Object)((Object)this));
            VisiblePack dataPack = ui.getDataPack();
            String singleBranchName = DeepComparator.getComparedBranchFromFilters(ui.getFilterUi().getFilters(), dataPack.getRefs());
            if (singleBranchName == null) {
                DeepCompareAction.selectBranchAndPerformAction((VcsLogUiEx)ui, e, (Consumer<? super String>)((Consumer)arg_0 -> DeepCompareAction.lambda$setSelected$0(ui, dc, (VcsLogDataPack)dataPack, arg_0)), DeepCompareAction.getGitRoots(project, (VcsLogUi)ui));
                return;
            }
            dc.startTask((VcsLogDataPack)dataPack, singleBranchName);
        } else {
            dc.stopTaskAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogUiEx ui, @NotNull AnActionEvent event, final @NotNull Consumer<? super String> consumer2, @NotNull Collection<? extends VirtualFile> visibleRoots) {
        if (ui == null) {
            DeepCompareAction.$$$reportNull$$$0(2);
        }
        if (event == null) {
            DeepCompareAction.$$$reportNull$$$0(3);
        }
        if (consumer2 == null) {
            DeepCompareAction.$$$reportNull$$$0(4);
        }
        if (visibleRoots == null) {
            DeepCompareAction.$$$reportNull$$$0(5);
        }
        VisiblePack dataPack = ui.getDataPack();
        ActionGroup actionGroup = new BranchPopupBuilder((VcsLogDataPack)dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull @NlsActions.ActionText String name, @NotNull Collection<? extends VcsRef> refs) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refs == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new DumbAwareAction(name){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        consumer2.consume((Object)name);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/branch/DeepCompareAction$1$1", "actionPerformed"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "refs";
                        break;
                    }
                }
                objectArray[1] = "git4idea/branch/DeepCompareAction$1";
                objectArray[2] = "createAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.build();
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(GitBundle.message("git.log.cherry.picked.highlighter.select.branch.popup", new Object[0]), actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup2.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup2.showInCenterOf((Component)ui.getTable());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeepCompareAction.$$$reportNull$$$0(6);
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            Set visibleRoots = VcsLogUtil.getVisibleRoots((VcsLogUi)ui);
            Set allRoots = visibleRoots;
            if (allRoots.isEmpty()) {
                allRoots = ContainerUtil.map2Set((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots(), VcsRoot::getPath);
            }
            e.getPresentation().setEnabled(DeepCompareAction.hasGitRoots(project, visibleRoots));
            e.getPresentation().setVisible(DeepCompareAction.hasGitRoots(project, allRoots));
        }
    }

    @NotNull
    private static Collection<VirtualFile> getGitRoots(@NotNull Project project, @NotNull VcsLogUi ui) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(7);
        }
        if (ui == null) {
            DeepCompareAction.$$$reportNull$$$0(8);
        }
        List list2 = ContainerUtil.filter((Collection)VcsLogUtil.getVisibleRoots((VcsLogUi)ui), root -> DeepCompareAction.isGitRoot(project, root));
        if (list2 == null) {
            DeepCompareAction.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(10);
        }
        if (roots == null) {
            DeepCompareAction.$$$reportNull$$$0(11);
        }
        return ContainerUtil.exists(roots, root -> DeepCompareAction.isGitRoot(project, root));
    }

    private static boolean isGitRoot(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            DeepCompareAction.$$$reportNull$$$0(12);
        }
        if (root == null) {
            DeepCompareAction.$$$reportNull$$$0(13);
        }
        return GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root) != null;
    }

    private static /* synthetic */ void lambda$setSelected$0(MainVcsLogUi ui, DeepComparator dc, VcsLogDataPack dataPack, String selectedBranch) {
        VcsLogFilterCollection collection = ui.getFilterUi().getFilters();
        collection = VcsLogFiltersKt.without((VcsLogFilterCollection)collection, VcsLogBranchLikeFilter.class);
        collection = VcsLogFiltersKt.with((VcsLogFilterCollection)collection, (VcsLogFilter)VcsLogFilterObject.fromBranch((String)selectedBranch));
        ui.getFilterUi().setFilters(collection);
        dc.startTask(dataPack, selectedBranch);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRoots";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/DeepCompareAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/DeepCompareAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectBranchAndPerformAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGitRoots";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasGitRoots";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGitRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

