/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.GitUtil;
import git4idea.conflicts.GitConflictsPanel;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MyChangesTree;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.status.GitStagingAreaHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002-.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020 J\b\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002J\u0006\u0010+\u001a\u00020\u001eJ\b\u0010,\u001a\u00020\u001eH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/conflicts/GitConflictsPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeHandler", "Lgit4idea/conflicts/GitMergeHandler;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/conflicts/GitMergeHandler;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "conflicts", "", "Lgit4idea/repo/GitConflict;", "conflictsTree", "Lgit4idea/conflicts/MyChangesTree;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/conflicts/GitConflictsPanel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "panel", "preferredFocusableComponent", "getPreferredFocusableComponent", "reversedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "acceptConflictSideForSelection", "", "takeTheirs", "", "addListener", "listener", "canAcceptConflictSideForSelection", "canShowMergeWindowForSelection", "dispose", "getConflictOperationLock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "conflict", "getSelectedConflicts", "", "showMergeWindowForSelection", "updateConflicts", "Listener", "MainPanel", "intellij.vcs.git"})
public final class GitConflictsPanel
implements Disposable {
    private final JComponent panel;
    private final MyChangesTree conflictsTree;
    private final List<GitConflict> conflicts;
    private final Set<VirtualFile> reversedRoots;
    private final MergingUpdateQueue updateQueue;
    private final EventDispatcher<Listener> eventDispatcher;
    private final Project project;
    private final GitMergeHandler mergeHandler;

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        return (JComponent)((Object)this.conflictsTree);
    }

    public void dispose() {
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    private final List<GitConflict> getSelectedConflicts() {
        List list2 = this.conflictsTree.getSelectedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"conflictsTree.selectedChanges");
        return list2;
    }

    private final void updateConflicts() {
        this.updateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", (Runnable)new Runnable(this){
            final /* synthetic */ GitConflictsPanel this$0;

            public final void run() {
                Application app$iv;
                String string = GitConflictsPanel.access$getMergeHandler$p(this.this$0).loadMergeDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mergeHandler.loadMergeDescription()");
                String description = string;
                ArrayList<E> newConflicts = new ArrayList<E>();
                ArrayList<VirtualFile> newReversedRoots = new ArrayList<VirtualFile>();
                Collection<GitRepository> collection = GitUtil.getRepositories(GitConflictsPanel.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue(collection, (String)"GitUtil.getRepositories(project)");
                Collection<GitRepository> repos = collection;
                for (GitRepository repo : repos) {
                    if (GitMergeUtil.isReverseRoot(repo)) {
                        GitRepository gitRepository = repo;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                        newReversedRoots.add(gitRepository.getRoot());
                    }
                    GitRepository gitRepository = repo;
                    Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                    GitStagingAreaHolder gitStagingAreaHolder = gitRepository.getStagingAreaHolder();
                    Intrinsics.checkNotNullExpressionValue((Object)gitStagingAreaHolder, (String)"repo.stagingAreaHolder");
                    newConflicts.addAll(gitStagingAreaHolder.getAllConflicts());
                }
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    boolean bl = false;
                    ((Listener)GitConflictsPanel.access$getEventDispatcher$p(this.this$0).getMulticaster()).onDescriptionChange(description);
                    GitConflictsPanel.access$getConflicts$p(this.this$0).clear();
                    GitConflictsPanel.access$getConflicts$p(this.this$0).addAll((Collection)newConflicts);
                    GitConflictsPanel.access$getReversedRoots$p(this.this$0).clear();
                    GitConflictsPanel.access$getReversedRoots$p(this.this$0).addAll((Collection)newReversedRoots);
                    GitConflictsPanel.access$getConflictsTree$p(this.this$0).setChangesToDisplay(GitConflictsPanel.access$getConflicts$p(this.this$0));
                    if (GitConflictsPanel.access$getConflictsTree$p(this.this$0).getSelectionCount() == 0) {
                        TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)GitConflictsPanel.access$getConflictsTree$p(this.this$0))));
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    Application application2 = ApplicationManager.getApplication();
                    Runnable runnable2 = new Runnable(this, description, newConflicts, newReversedRoots){
                        final /* synthetic */ updateConflicts.1 this$0;
                        final /* synthetic */ String $description$inlined;
                        final /* synthetic */ ArrayList $newConflicts$inlined;
                        final /* synthetic */ ArrayList $newReversedRoots$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$description$inlined = string;
                            this.$newConflicts$inlined = arrayList;
                            this.$newReversedRoots$inlined = arrayList2;
                        }

                        public final void run() {
                            boolean bl = false;
                            ((Listener)GitConflictsPanel.access$getEventDispatcher$p(this.this$0.this$0).getMulticaster()).onDescriptionChange(this.$description$inlined);
                            GitConflictsPanel.access$getConflicts$p(this.this$0.this$0).clear();
                            GitConflictsPanel.access$getConflicts$p(this.this$0.this$0).addAll(this.$newConflicts$inlined);
                            GitConflictsPanel.access$getReversedRoots$p(this.this$0.this$0).clear();
                            GitConflictsPanel.access$getReversedRoots$p(this.this$0.this$0).addAll(this.$newReversedRoots$inlined);
                            GitConflictsPanel.access$getConflictsTree$p(this.this$0.this$0).setChangesToDisplay(GitConflictsPanel.access$getConflicts$p(this.this$0.this$0));
                            if (GitConflictsPanel.access$getConflictsTree$p(this.this$0.this$0).getSelectionCount() == 0) {
                                TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)GitConflictsPanel.access$getConflictsTree$p(this.this$0.this$0))));
                            }
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application2.invokeLater(runnable2, modalityState);
                }
            }
            {
                this.this$0 = gitConflictsPanel;
            }
        }));
    }

    public final boolean canShowMergeWindowForSelection() {
        boolean bl;
        block3: {
            List<GitConflict> selectedConflicts = this.getSelectedConflicts();
            Iterable $this$any$iv = selectedConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitConflict it = (GitConflict)element$iv;
                    boolean bl2 = false;
                    if (!(this.mergeHandler.canResolveConflict(it) && !this.getConflictOperationLock(it).isLocked())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void showMergeWindowForSelection() {
        HashSet reversed = new HashSet(this.reversedRoots);
        GitConflictsUtil.INSTANCE.showMergeWindow$intellij_vcs_git(this.project, this.mergeHandler, this.getSelectedConflicts(), (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(reversed){

            public final boolean invoke(VirtualFile p1) {
                return ((HashSet)this.receiver).contains(p1);
            }
        }));
    }

    public final boolean canAcceptConflictSideForSelection() {
        boolean bl;
        block3: {
            List<GitConflict> selectedConflicts = this.getSelectedConflicts();
            Iterable $this$any$iv = selectedConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitConflict it = (GitConflict)element$iv;
                    boolean bl2 = false;
                    if (!(!this.getConflictOperationLock(it).isLocked())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void acceptConflictSideForSelection(boolean takeTheirs) {
        HashSet reversed = new HashSet(this.reversedRoots);
        GitConflictsUtil.INSTANCE.acceptConflictSide$intellij_vcs_git(this.project, this.mergeHandler, this.getSelectedConflicts(), takeTheirs, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(reversed){

            public final boolean invoke(VirtualFile p1) {
                return ((HashSet)this.receiver).contains(p1);
            }
        }));
    }

    private final BackgroundableActionLock getConflictOperationLock(GitConflict conflict2) {
        return GitConflictsUtil.INSTANCE.getConflictOperationLock$intellij_vcs_git(this.project, conflict2);
    }

    /*
     * WARNING - void declaration
     */
    public GitConflictsPanel(@NotNull Project project, @NotNull GitMergeHandler mergeHandler) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mergeHandler, (String)"mergeHandler");
        this.project = project;
        this.mergeHandler = mergeHandler;
        this.conflicts = new ArrayList();
        this.reversedRoots = new HashSet();
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(Listener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.conflictsTree = new MyChangesTree(this.project);
        this.conflictsTree.setKeepTreeState(true);
        this.updateQueue = new MergingUpdateQueue("GitConflictsView", 300, true, (JComponent)((Object)this.conflictsTree), (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        MainPanel mainPanel = new MainPanel();
        boolean bl = false;
        boolean bl2 = false;
        MainPanel mainPanel2 = mainPanel;
        GitConflictsPanel gitConflictsPanel = this;
        boolean bl3 = false;
        $this$apply.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.conflictsTree))), "Center");
        Unit unit = Unit.INSTANCE;
        gitConflictsPanel.panel = mainPanel;
        this.conflictsTree.setDoubleClickHandler(new Processor(){

            public final boolean process(MouseEvent e) {
                boolean bl;
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)conflictsTree)), (MouseEvent)e)) {
                    bl = false;
                } else {
                    this.showMergeWindowForSelection();
                    bl = true;
                }
                return bl;
            }
        });
        this.conflictsTree.setEnterKeyHandler(new Processor(){

            public final boolean process(KeyEvent it) {
                this.showMergeWindowForSelection();
                return true;
            }
        });
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(GitStagingAreaHolder.TOPIC, (Object)new GitStagingAreaHolder.StagingAreaListener(){

            @Override
            public final void stagingAreaChanged(@NotNull GitRepository it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.updateConflicts();
            }
        });
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public final void repositoryChanged(@NotNull GitRepository it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.updateConflicts();
            }
        });
        this.updateConflicts();
        this.updateQueue.sendFlush();
    }

    public static final /* synthetic */ GitMergeHandler access$getMergeHandler$p(GitConflictsPanel $this) {
        return $this.mergeHandler;
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(GitConflictsPanel $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ List access$getConflicts$p(GitConflictsPanel $this) {
        return $this.conflicts;
    }

    public static final /* synthetic */ Set access$getReversedRoots$p(GitConflictsPanel $this) {
        return $this.reversedRoots;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$MainPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lgit4idea/conflicts/GitConflictsPanel;)V", "getData", "", "dataId", "", "intellij.vcs.git"})
    private final class MainPanel
    extends JPanel
    implements DataProvider {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = GitConflictsPanel.this.getSelectedConflicts();
                Project project = GitConflictsPanel.this.project;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    GitConflict it = (GitConflict)element$iv$iv;
                    boolean bl2 = false;
                    FilePath filePath = it.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"it.filePath");
                    if (filePath.getVirtualFile() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    VirtualFile it$iv$iv = virtualFile;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                return ChangesUtil.getNavigatableArray((Project)project, list2.stream());
            }
            return null;
        }

        public MainPanel() {
            super(new BorderLayout());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$Listener;", "Ljava/util/EventListener;", "onDescriptionChange", "", "description", "", "Lorg/jetbrains/annotations/Nls;", "intellij.vcs.git"})
    public static interface Listener
    extends EventListener {
        public void onDescriptionChange(@NotNull String var1);

        @Metadata(mv={1, 5, 1}, k=3)
        public static final class DefaultImpls {
            public static void onDescriptionChange(@NotNull Listener $this, @NotNull String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            }
        }
    }
}

