/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordBuilder;
import git4idea.history.GitLogRecordCollector;
import git4idea.history.GitLogUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u00015B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ+\u0010\u0014\u001a\u00028\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0016\u0012\u0004\u0012\u00020 0\u001fH$J?\u0010!\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0)\"\u00020*\u00a2\u0006\u0002\u0010+J4\u0010,\u001a\u00020 2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010#JA\u0010.\u001a\u00020 2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010#2\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0)\"\u00020*H\u0002\u00a2\u0006\u0002\u00101J7\u00102\u001a\u00020 2\u0006\u0010/\u001a\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0)\"\u00020*H\u0002\u00a2\u0006\u0002\u00104R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lgit4idea/history/GitDetailsCollector;", "R", "Lgit4idea/history/GitLogRecord;", "C", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "recordBuilder", "Lgit4idea/history/GitLogRecordBuilder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lgit4idea/history/GitLogRecordBuilder;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "vcs", "Lgit4idea/GitVcs;", "Lorg/jetbrains/annotations/NotNull;", "createCommit", "records", "", "factory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "renameLimit", "Lgit4idea/history/GitCommitRequirements$DiffRenameLimit;", "(Ljava/util/List;Lcom/intellij/vcs/log/VcsLogObjectsFactory;Lgit4idea/history/GitCommitRequirements$DiffRenameLimit;)Lcom/intellij/vcs/log/VcsCommitMetadata;", "createRecordsCollector", "Lgit4idea/history/GitLogRecordCollector;", "consumer", "Lkotlin/Function1;", "", "readFullDetails", "commitConsumer", "Lcom/intellij/util/Consumer;", "requirements", "Lgit4idea/history/GitCommitRequirements;", "lowPriorityProcess", "", "parameters", "", "", "(Lcom/intellij/util/Consumer;Lgit4idea/history/GitCommitRequirements;Z[Ljava/lang/String;)V", "readFullDetailsForHashes", "hashes", "readFullDetailsFromHandler", "handler", "Lgit4idea/commands/GitLineHandler;", "(Lcom/intellij/util/Consumer;Lgit4idea/commands/GitLineHandler;Lgit4idea/history/GitCommitRequirements;[Ljava/lang/String;)V", "readRecordsFromHandler", "converter", "(Lgit4idea/commands/GitLineHandler;Lcom/intellij/util/Consumer;[Ljava/lang/String;)V", "Companion", "intellij.vcs.git"})
public abstract class GitDetailsCollector<R extends GitLogRecord, C extends VcsCommitMetadata> {
    private final GitVcs vcs;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    private final GitLogRecordBuilder<R> recordBuilder;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void readFullDetails(@NotNull Consumer<? super C> commitConsumer, @NotNull GitCommitRequirements requirements, boolean lowPriorityProcess, String ... parameters) throws VcsException {
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        List<String> configParameters = requirements.configParameters();
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, this.root, configParameters, lowPriorityProcess);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"GitLogUtil.createGitHand\u2026ters, lowPriorityProcess)");
        GitLineHandler handler = gitLineHandler;
        this.readFullDetailsFromHandler(commitConsumer, handler, requirements, Arrays.copyOf(parameters, parameters.length));
    }

    public final void readFullDetailsForHashes(@NotNull List<String> hashes2, @NotNull GitCommitRequirements requirements, boolean lowPriorityProcess, @NotNull Consumer<? super C> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter(hashes2, (String)"hashes");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        if (hashes2.isEmpty()) {
            return;
        }
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, this.root, requirements.configParameters(), lowPriorityProcess);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"GitLogUtil.createGitHand\u2026rs(), lowPriorityProcess)");
        GitLineHandler handler = gitLineHandler;
        GitLogUtil.sendHashesToStdin((Collection<String>)hashes2, handler);
        String[] stringArray = new String[2];
        String string = GitLogUtil.getNoWalkParameter(this.vcs);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitLogUtil.getNoWalkParameter(vcs)");
        stringArray[0] = string;
        stringArray[1] = "--stdin";
        this.readFullDetailsFromHandler(commitConsumer, handler, requirements, stringArray);
    }

    private final void readFullDetailsFromHandler(Consumer<? super C> commitConsumer, GitLineHandler handler, GitCommitRequirements requirements, String ... parameters) throws VcsException {
        VcsLogObjectsFactory vcsLogObjectsFactory = GitLogUtil.getObjectsFactoryWithDisposeCheck(this.project);
        if (vcsLogObjectsFactory == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogObjectsFactory, (String)"GitLogUtil.getObjectsFac\u2026eCheck(project) ?: return");
        VcsLogObjectsFactory factory = vcsLogObjectsFactory;
        String[] commandParameters = ArrayUtil.mergeArrays((String[])ArrayUtil.toStringArray((Collection)requirements.commandParameters()), (String[])Arrays.copyOf(parameters, parameters.length));
        if (requirements.getDiffInMergeCommits() == GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS) {
            Function1 consumer2 = new Function1<List<? extends R>, Unit>(this, commitConsumer, factory, requirements){
                final /* synthetic */ GitDetailsCollector this$0;
                final /* synthetic */ Consumer $commitConsumer;
                final /* synthetic */ VcsLogObjectsFactory $factory;
                final /* synthetic */ GitCommitRequirements $requirements;

                public final void invoke(@NotNull List<? extends R> records) {
                    Intrinsics.checkNotNullParameter(records, (String)"records");
                    GitLogRecord firstRecord = (GitLogRecord)CollectionsKt.first(records);
                    String[] parents = firstRecord.getParentsHashes();
                    Intrinsics.checkNotNullExpressionValue((Object)parents, (String)"parents");
                    String[] stringArray = parents;
                    boolean bl = false;
                    if (stringArray.length == 0 || parents.length == records.size()) {
                        this.$commitConsumer.consume(this.this$0.createCommit(records, this.$factory, this.$requirements.getDiffRenameLimit()));
                    } else {
                        GitDetailsCollector.access$getLOG$cp().warn("Not enough records for commit " + firstRecord.getHash() + ' ' + "expected " + parents.length + " records, but got " + records.size());
                    }
                }
                {
                    this.this$0 = gitDetailsCollector;
                    this.$commitConsumer = consumer2;
                    this.$factory = vcsLogObjectsFactory;
                    this.$requirements = gitCommitRequirements;
                    super(1);
                }
            };
            GitLogRecordCollector<R> recordCollector = this.createRecordsCollector(consumer2);
            Consumer consumer3 = recordCollector;
            String[] stringArray = commandParameters;
            Intrinsics.checkNotNullExpressionValue((Object)commandParameters, (String)"commandParameters");
            this.readRecordsFromHandler(handler, consumer3, Arrays.copyOf(stringArray, stringArray.length));
            recordCollector.finish();
        } else {
            Consumer consumer4 = new Consumer(this, commitConsumer, factory, requirements){
                final /* synthetic */ GitDetailsCollector this$0;
                final /* synthetic */ Consumer $commitConsumer;
                final /* synthetic */ VcsLogObjectsFactory $factory;
                final /* synthetic */ GitCommitRequirements $requirements;

                public final void consume(R record) {
                    this.$commitConsumer.consume(this.this$0.createCommit(CollectionsKt.mutableListOf((Object[])new GitLogRecord[]{record}), this.$factory, this.$requirements.getDiffRenameLimit()));
                }
                {
                    this.this$0 = gitDetailsCollector;
                    this.$commitConsumer = consumer2;
                    this.$factory = vcsLogObjectsFactory;
                    this.$requirements = gitCommitRequirements;
                }
            };
            String[] stringArray = commandParameters;
            Intrinsics.checkNotNullExpressionValue((Object)commandParameters, (String)"commandParameters");
            this.readRecordsFromHandler(handler, consumer4, Arrays.copyOf(stringArray, stringArray.length));
        }
    }

    private final void readRecordsFromHandler(GitLineHandler handler, Consumer<R> converter, String ... parameters) throws VcsException {
        GitLogParser<R> parser = new GitLogParser<R>(this.project, this.recordBuilder, GitLogParser.NameStatus.STATUS, Arrays.copyOf(GitLogUtil.COMMIT_METADATA_OPTIONS, GitLogUtil.COMMIT_METADATA_OPTIONS.length));
        handler.setStdoutSuppressed(true);
        handler.addParameters(Arrays.copyOf(parameters, parameters.length));
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--name-status");
        handler.endOptions();
        StopWatch stopWatch = StopWatch.start((String)("loading details in [" + this.root.getName() + "]"));
        Intrinsics.checkNotNullExpressionValue((Object)stopWatch, (String)"StopWatch.start(\"loading\u2026 in [\" + root.name + \"]\")");
        StopWatch sw = stopWatch;
        GitLogOutputSplitter<R> handlerListener = new GitLogOutputSplitter<R>(handler, parser, converter);
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        handlerListener.reportErrors();
        sw.report();
    }

    @NotNull
    protected abstract GitLogRecordCollector<R> createRecordsCollector(@NotNull Function1<? super List<? extends R>, Unit> var1);

    @NotNull
    protected abstract C createCommit(@NotNull List<? extends R> var1, @NotNull VcsLogObjectsFactory var2, @NotNull GitCommitRequirements.DiffRenameLimit var3);

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final VirtualFile getRoot() {
        return this.root;
    }

    public GitDetailsCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogRecordBuilder<R> recordBuilder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(recordBuilder, (String)"recordBuilder");
        this.project = project;
        this.root = root;
        this.recordBuilder = recordBuilder;
        GitVcs gitVcs = GitVcs.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"GitVcs.getInstance(project)");
        this.vcs = gitVcs;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitDetailsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitDe\u2026ilsCollector::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/history/GitDetailsCollector$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

