/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.AbstractCommitter;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.checkin.GitCommitAndPushExecutorKt;
import git4idea.checkin.GitCommitOptions;
import git4idea.checkin.GitPushAfterCommitDialog;
import git4idea.checkin.GitRepositoryCommitter;
import git4idea.index.GitStageCommitState;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\b\u0010\u001e\u001a\u00020\u0019H\u0014J\b\u0010\u001f\u001a\u00020\u0019H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/index/GitStageCommitter;", "Lcom/intellij/vcs/commit/AbstractCommitter;", "project", "Lcom/intellij/openapi/project/Project;", "commitState", "Lgit4idea/index/GitStageCommitState;", "toStage", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/openapi/vcs/FilePath;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/GitStageCommitState;Ljava/util/Map;Lcom/intellij/openapi/vcs/changes/CommitContext;)V", "failedRoots", "", "Lcom/intellij/openapi/vcs/VcsException;", "getFailedRoots", "()Ljava/util/Map;", "successfulRepositories", "", "Lgit4idea/repo/GitRepository;", "getSuccessfulRepositories", "()Ljava/util/Set;", "afterCommit", "", "commit", "commitRepository", "repository", "onFailure", "onFinish", "onSuccess", "intellij.vcs.git"})
public final class GitStageCommitter
extends AbstractCommitter {
    @NotNull
    private final Set<GitRepository> successfulRepositories;
    @NotNull
    private final Map<VirtualFile, VcsException> failedRoots;
    private final GitStageCommitState commitState;
    private final Map<VirtualFile, Collection<FilePath>> toStage;

    @NotNull
    public final Set<GitRepository> getSuccessfulRepositories() {
        return this.successfulRepositories;
    }

    @NotNull
    public final Map<VirtualFile, VcsException> getFailedRoots() {
        return this.failedRoots;
    }

    /*
     * WARNING - void declaration
     */
    protected void commit() {
        Collection<VirtualFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = LocalChangesCommitterKt.getCommitWithoutChangesRoots((CommitContext)this.getCommitContext());
        Set<VirtualFile> set = this.commitState.getRoots();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection<FilePath> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VirtualFile virtualFile;
            void it;
            VcsRoot vcsRoot = (VcsRoot)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getPath(), (String)"it.path");
            collection.add(virtualFile);
        }
        collection = (List)destination$iv$iv;
        Set roots = SetsKt.plus(set, (Iterable)collection);
        for (VirtualFile root : roots) {
            try {
                GitRepository repository;
                Collection<FilePath> toStageInRoot = this.toStage.get(root);
                if (toStageInRoot != null) {
                    boolean bl = false;
                    if (!destination$iv$iv.isEmpty()) {
                        GitFileUtils.addPaths(this.getProject(), root, toStageInRoot, true);
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)GitUtil.getRepositoryForFile(this.getProject(), root), (String)"getRepositoryForFile(project, root)");
                this.commitRepository(repository);
                this.successfulRepositories.add(repository);
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                VcsException rootError = this.asVcsException(e);
                this.addException(rootError);
                this.failedRoots.put(root, rootError);
            }
        }
    }

    protected void afterCommit() {
    }

    protected void onSuccess() {
        if (GitCommitAndPushExecutorKt.isPushAfterCommit(this.getCommitContext())) {
            GitPushAfterCommitDialog.showOrPush(this.getProject(), (Collection<GitRepository>)this.successfulRepositories);
        }
    }

    protected void onFailure() {
    }

    protected void onFinish() {
        for (GitRepository repository : this.successfulRepositories) {
            GitUtil.getRepositoryManager(this.getProject()).updateRepository(repository.getRoot());
            if (!GitSubmoduleKt.isSubmodule(repository)) continue;
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.getProject());
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
            vcsDirtyScopeManager.dirDirtyRecursively(virtualFile.getParent());
        }
        VcsFileUtil.markFilesDirty((Project)this.getProject(), (Collection)this.commitState.getRoots());
    }

    private final void commitRepository(GitRepository repository) throws VcsException {
        GitRepositoryCommitter committer = new GitRepositoryCommitter(repository, new GitCommitOptions(this.getCommitContext()));
        committer.commitStaged(this.getCommitMessage());
    }

    public GitStageCommitter(@NotNull Project project, @NotNull GitStageCommitState commitState, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> toStage, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        Intrinsics.checkNotNullParameter(toStage, (String)"toStage");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        super(project, CollectionsKt.emptyList(), commitState.getCommitMessage(), commitContext);
        this.commitState = commitState;
        this.toStage = toStage;
        boolean bl = false;
        this.successfulRepositories = new LinkedHashSet();
        bl = false;
        this.failedRoots = new LinkedHashMap();
    }
}

