/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogIconCellRenderer;
import git4idea.GitIcons;
import git4idea.commit.signature.GitCommitSignature;
import git4idea.i18n.GitBundle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lgit4idea/log/GitCommitSignatureLogCellRenderer;", "Lcom/intellij/vcs/log/ui/table/VcsLogIconCellRenderer;", "()V", "customize", "", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "Companion", "intellij.vcs.git"})
public final class GitCommitSignatureLogCellRenderer
extends VcsLogIconCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void customize(@NotNull VcsLogGraphTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = value;
        if (!(object instanceof GitCommitSignature)) {
            object = null;
        }
        GitCommitSignature signature = (GitCommitSignature)object;
        this.setIcon(Companion.getIcon(signature));
        this.setToolTipText(Companion.getToolTip(signature).toString());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\t"}, d2={"Lgit4idea/log/GitCommitSignatureLogCellRenderer$Companion;", "", "()V", "getIcon", "Ljavax/swing/Icon;", "signature", "Lgit4idea/commit/signature/GitCommitSignature;", "getToolTip", "Lcom/intellij/openapi/util/text/HtmlChunk;", "intellij.vcs.git"})
    public static final class Companion {
        @Nullable
        public final Icon getIcon(@Nullable GitCommitSignature signature) {
            Icon icon;
            GitCommitSignature gitCommitSignature = signature;
            if (gitCommitSignature instanceof GitCommitSignature.Verified) {
                icon = GitIcons.Verified;
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NotVerified.INSTANCE)) {
                icon = GitIcons.Signed;
            } else if (gitCommitSignature == null || Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
                icon = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return icon;
        }

        @NotNull
        public final HtmlChunk getToolTip(@Nullable GitCommitSignature signature) {
            HtmlChunk htmlChunk;
            GitCommitSignature gitCommitSignature = signature;
            if (gitCommitSignature instanceof GitCommitSignature.Verified) {
                HtmlChunk htmlChunk2 = new HtmlBuilder().append(GitBundle.message("tooltip.commit.signature.verify.success", new Object[0])).append((HtmlChunk)HtmlChunk.br()).append(((GitCommitSignature.Verified)signature).getUser()).append((HtmlChunk)HtmlChunk.br()).append(((GitCommitSignature.Verified)signature).getFingerprint()).toFragment();
                htmlChunk = htmlChunk2;
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"HtmlBuilder()\n          \u2026            .toFragment()");
            } else if (Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NotVerified.INSTANCE)) {
                HtmlChunk htmlChunk3 = HtmlChunk.text((String)GitBundle.message("tooltip.commit.signature.verify.failure", new Object[0]));
                htmlChunk = htmlChunk3;
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk3, (String)"HtmlChunk.text(message(\"\u2026gnature.verify.failure\"))");
            } else if (gitCommitSignature == null || Intrinsics.areEqual((Object)gitCommitSignature, (Object)GitCommitSignature.NoSignature.INSTANCE)) {
                HtmlChunk htmlChunk4 = HtmlChunk.text((String)GitBundle.message("tooltip.no.commit.signature", new Object[0]));
                htmlChunk = htmlChunk4;
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk4, (String)"HtmlChunk.text(message(\"\u2026ip.no.commit.signature\"))");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return htmlChunk;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

