/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import git4idea.commit.signature.GitCommitSignature;
import git4idea.i18n.GitBundle;
import git4idea.log.GitCommitSignatureLoaderBase;
import git4idea.log.GitCommitSignatureLogCellRenderer;
import git4idea.log.NonCancellableGitCommitSignatureLoader;
import git4idea.log.SimpleGitCommitSignatureLoader;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lgit4idea/log/GitCommitSignatureStatusProvider;", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;", "Lgit4idea/commit/signature/GitCommitSignature;", "()V", "id", "", "getId", "()Ljava/lang/String;", "createLoader", "Lgit4idea/log/GitCommitSignatureLoaderBase;", "project", "Lcom/intellij/openapi/project/Project;", "getPresentation", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation$Signature;", "commit", "Lcom/intellij/vcs/log/CommitId;", "status", "Companion", "GitCommitSignatureStatusPresentation", "intellij.vcs.git"})
public final class GitCommitSignatureStatusProvider
implements VcsCommitExternalStatusProvider<GitCommitSignature> {
    @NotNull
    private final String id;
    @NotNull
    public static final String ID = "Git.CommitSignature";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public GitCommitSignatureLoaderBase createLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SystemInfo.isWindows ? (GitCommitSignatureLoaderBase)new NonCancellableGitCommitSignatureLoader(project) : (GitCommitSignatureLoaderBase)new SimpleGitCommitSignatureLoader(project);
    }

    @Nullable
    public VcsCommitExternalStatusPresentation.Signature getPresentation(@NotNull Project project, @NotNull CommitId commit, @NotNull GitCommitSignature status) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Icon icon = GitCommitSignatureLogCellRenderer.Companion.getIcon(status);
        if (icon == null) {
            return null;
        }
        Icon icon2 = icon;
        GitCommitSignature gitCommitSignature = status;
        if (gitCommitSignature instanceof GitCommitSignature.NotVerified) {
            string = GitBundle.message("commit.signature.unverified", new Object[0]);
        } else if (gitCommitSignature instanceof GitCommitSignature.Verified) {
            string = GitBundle.message("commit.signature.verified", new Object[0]);
        } else if (gitCommitSignature instanceof GitCommitSignature.NoSignature) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (status) {\n      is\u2026e.NoSignature -> \"\"\n    }");
        String text = string;
        String string2 = GitCommitSignatureLogCellRenderer.Companion.getToolTip(status).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitCommitSignatureLogCel\u2026oolTip(status).toString()");
        String tooltip = string2;
        return new GitCommitSignatureStatusPresentation(icon2, text, tooltip);
    }

    public GitCommitSignatureStatusProvider() {
        this.id = ID;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lgit4idea/log/GitCommitSignatureStatusProvider$GitCommitSignatureStatusPresentation;", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation$Signature;", "icon", "Ljavax/swing/Icon;", "shortDescriptionText", "", "fullDescriptionHtml", "(Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;)V", "getFullDescriptionHtml", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getShortDescriptionText", "intellij.vcs.git"})
    private static final class GitCommitSignatureStatusPresentation
    implements VcsCommitExternalStatusPresentation.Signature {
        @NotNull
        private final Icon icon;
        @NotNull
        private final String shortDescriptionText;
        @NotNull
        private final String fullDescriptionHtml;

        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public String getShortDescriptionText() {
            return this.shortDescriptionText;
        }

        @NotNull
        public String getFullDescriptionHtml() {
            return this.fullDescriptionHtml;
        }

        public GitCommitSignatureStatusPresentation(@NotNull Icon icon, @Nls @NotNull String shortDescriptionText, @Nls @NotNull String fullDescriptionHtml) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)shortDescriptionText, (String)"shortDescriptionText");
            Intrinsics.checkNotNullParameter((Object)fullDescriptionHtml, (String)"fullDescriptionHtml");
            this.icon = icon;
            this.shortDescriptionText = shortDescriptionText;
            this.fullDescriptionHtml = fullDescriptionHtml;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/log/GitCommitSignatureStatusProvider$Companion;", "", "()V", "ID", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

