/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitDisposable;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    @NotNull
    private final Collection<? extends VirtualFile> myRoots;
    @NotNull
    private final Params myParams;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final AbstractVcsHelper myVcsHelper;

    public GitConflictResolver(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull Params params) {
        if (project == null) {
            GitConflictResolver.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(1);
        }
        if (params == null) {
            GitConflictResolver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    @RequiresBackgroundThread
    protected boolean proceedAfterAllMerged() throws VcsException {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return true;
    }

    @RequiresBackgroundThread
    public final void mergeNoProceed() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        this.merge(true);
    }

    @RequiresEdt
    public final void mergeNoProceedInBackground() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        new Task.Backgroundable(this.myProject, GitBundle.message("apply.changes.resolving.conflicts.progress.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitConflictResolver.this.mergeNoProceed();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/merge/GitConflictResolver$1", "run"));
            }
        }.queue();
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, GitBundle.message("merge.unresolved.conflicts.remaining.notification.body", new Object[0]) + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning(GitBundle.message("merge.unresolved.conflicts.remaining.notification.title", new Object[0]), this.myParams.myErrorNotificationAdditionalDescription);
    }

    protected void notifyWarning(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content2) {
        if (title == null) {
            GitConflictResolver.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            GitConflictResolver.$$$reportNull$$$0(4);
        }
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, content2, NotificationType.WARNING);
        notification2.setDisplayId("git.cannot.resolve.conflict");
        notification2.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.text.resolve", new Object[0]), () -> {
            notification2.expire();
            BackgroundTaskUtil.executeOnPooledThread((Disposable)GitDisposable.getInstance(this.myProject), () -> this.mergeNoProceed());
        }));
        VcsNotifier.getInstance((Project)this.myProject).notify(notification2);
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        try {
            Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
            if (initiallyUnmergedFiles.isEmpty()) {
                LOG.info("merge: no unmerged files");
                return mergeDialogInvokedFromNotification || this.proceedIfNothingToMerge();
            }
            this.showMergeDialog(initiallyUnmergedFiles);
            Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
            if (unmergedFilesAfterResolve.isEmpty()) {
                LOG.info("merge no more unmerged files");
                return mergeDialogInvokedFromNotification || this.proceedAfterAllMerged();
            }
            LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
            if (mergeDialogInvokedFromNotification) {
                this.notifyUnresolvedRemainAfterNotification();
            } else {
                this.notifyUnresolvedRemain();
            }
        }
        catch (VcsException e) {
            this.notifyException(e);
        }
        return false;
    }

    private void showMergeDialog(@NotNull Collection<? extends VirtualFile> initiallyUnmergedFiles) {
        if (initiallyUnmergedFiles == null) {
            GitConflictResolver.$$$reportNull$$$0(5);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitMergeProvider mergeProvider = new GitMergeProvider(this.myProject, this.myParams.reverse);
            this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, this.myParams.myMergeDialogCustomizer);
        });
    }

    private void notifyException(@NotNull VcsException e) {
        if (e == null) {
            GitConflictResolver.$$$reportNull$$$0(6);
        }
        LOG.info("mergeFiles ", (Throwable)e);
        String description = GitBundle.message("conflict.resolver.unmerged.files.check.error.notification.description.text", this.myParams.myErrorNotificationAdditionalDescription);
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.conflict.resolving.error", this.myParams.myErrorNotificationTitle, new HtmlBuilder().appendRaw(description).br().appendRaw(e.getLocalizedMessage()).toString());
    }

    @NotNull
    private Collection<VirtualFile> getUnmergedFiles(@NotNull Collection<? extends VirtualFile> roots) throws VcsException {
        if (roots == null) {
            GitConflictResolver.$$$reportNull$$$0(7);
        }
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(virtualFile));
        }
        HashSet<VirtualFile> hashSet = unmergedFiles;
        if (hashSet == null) {
            GitConflictResolver.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    private Collection<VirtualFile> getUnmergedFiles(@NotNull VirtualFile root) throws VcsException {
        GitRepository repository;
        if (root == null) {
            GitConflictResolver.$$$reportNull$$$0(9);
        }
        if ((repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)) == null) {
            LOG.error("Repository not found for root " + root);
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                GitConflictResolver.$$$reportNull$$$0(10);
            }
            return list2;
        }
        List<FilePath> files = GitChangeUtils.getUnmergedFiles(repository);
        List list3 = ContainerUtil.mapNotNull(files, it -> LocalFileSystem.getInstance().refreshAndFindFileByPath(it.getPath()));
        if (list3 == null) {
            GitConflictResolver.$$$reportNull$$$0(11);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initiallyUnmergedFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitConflictResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitConflictResolver";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyWarning";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showMergeDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyException";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Params {
        private boolean reverse;
        private @NlsContexts.NotificationTitle String myErrorNotificationTitle = "";
        private @NlsContexts.NotificationContent String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer;

        public Params() {
            this.myMergeDialogCustomizer = new MergeDialogCustomizer(){

                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    if (files == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = myMergeDescription;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "files";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "git4idea/merge/GitConflictResolver$Params$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "git4idea/merge/GitConflictResolver$Params$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getMultipleFileMergeDescription";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getMultipleFileMergeDescription";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public Params(Project project) {
            this.myMergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(project){

                @Override
                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    if (files == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!StringUtil.isEmpty((String)myMergeDescription)) {
                        String string = myMergeDescription;
                        if (string == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    String string = super.getMultipleFileMergeDescription(files);
                    if (string == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "files";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "git4idea/merge/GitConflictResolver$Params$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "git4idea/merge/GitConflictResolver$Params$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getMultipleFileMergeDescription";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getMultipleFileMergeDescription";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(@NlsContexts.NotificationTitle String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(@NlsContexts.NotificationContent String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(@Nls String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

