/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.stash.GitStashTrackerListener;
import git4idea.stash.GitStashUtils;
import git4idea.ui.StashInfo;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0001J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u0014R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/stash/GitStashTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/stash/GitStashTrackerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/stash/GitStashTracker$Stashes;", "stashes", "getStashes", "()Ljava/util/Map;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "addListener", "", "listener", "disposable", "dispose", "", "Lgit4idea/ui/StashInfo;", "root", "scheduleRefresh", "Companion", "Stashes", "intellij.vcs.git"})
public final class GitStashTracker
implements Disposable {
    private final EventDispatcher<GitStashTrackerListener> eventDispatcher;
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private Map<VirtualFile, ? extends Stashes> stashes;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Map<VirtualFile, Stashes> getStashes() {
        return this.stashes;
    }

    public final void scheduleRefresh() {
        if (!GitStashTrackerKt.isStashToolWindowEnabled(this.project)) {
            return;
        }
        this.updateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", (Runnable)new Runnable(this){
            final /* synthetic */ GitStashTracker this$0;

            public final void run() {
                boolean bl = false;
                Map newStashes = new LinkedHashMap<K, V>();
                GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(GitStashTracker.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
                for (GitRepository repo : gitRepositoryManager.getRepositories()) {
                    try {
                        GitRepository gitRepository = repo;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                        VirtualFile virtualFile = gitRepository.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                        Project project = GitStashTracker.access$getProject$p(this.this$0);
                        VirtualFile virtualFile2 = repo.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"repo.root");
                        newStashes.put(virtualFile, new Stashes.Loaded(GitStashUtils.loadStashStack(project, virtualFile2)));
                    }
                    catch (VcsException e) {
                        GitRepository gitRepository = repo;
                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                        VirtualFile virtualFile = gitRepository.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repo.root");
                        newStashes.put(virtualFile, new Stashes.Error(e));
                        GitStashTracker.access$getLOG$cp().warn((Throwable)e);
                    }
                }
                BaseSingleTaskControllerKt.runInEdt((Disposable)this.this$0, (Function0)((Function0)new Function0<Unit>(this, newStashes){
                    final /* synthetic */ scheduleRefresh.1 this$0;
                    final /* synthetic */ Map $newStashes;

                    public final void invoke() {
                        GitStashTracker.access$setStashes$p(this.this$0.this$0, this.$newStashes);
                        ((GitStashTrackerListener)GitStashTracker.access$getEventDispatcher$p(this.this$0.this$0).getMulticaster()).stashesUpdated();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$newStashes = map2;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = gitStashTracker;
            }
        }));
    }

    public final void addListener(@NotNull GitStashTrackerListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener, disposable);
    }

    @NotNull
    public final List<StashInfo> getStashes(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Stashes stashes = this.stashes.get(root);
        return stashes instanceof Stashes.Loaded ? ((Stashes.Loaded)stashes).getStashes() : CollectionsKt.emptyList();
    }

    public void dispose() {
        this.stashes = MapsKt.emptyMap();
    }

    public GitStashTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        EventDispatcher eventDispatcher = EventDispatcher.create(GitStashTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(G\u2026ckerListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.updateQueue = new MergingUpdateQueue("GitStashTracker", 300, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.stashes = MapsKt.emptyMap();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean bl;
                block8: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
                    List<GitRepository> list2 = gitRepositoryManager.getRepositories();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"GitRepositoryManager.get\u2026nce(project).repositories");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl2;
                            block7: {
                                GitRepository repo = (GitRepository)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = events;
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        VFileEvent e = (VFileEvent)element$iv2;
                                        boolean bl4 = false;
                                        GitRepository gitRepository = repo;
                                        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repo");
                                        if (!gitRepository.getRepositoryFiles().isStashReflogFile(e.getPath())) continue;
                                        bl2 = true;
                                        break block7;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.scheduleRefresh();
                }
            }
        });
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

            public final void directoryMappingChanged() {
                this.scheduleRefresh();
            }
        });
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public final void repositoryChanged(@NotNull GitRepository it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.scheduleRefresh();
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            this.scheduleRefresh();
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitStashTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitStashTracker::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Map access$getStashes$p(GitStashTracker $this) {
        return $this.stashes;
    }

    public static final /* synthetic */ void access$setStashes$p(GitStashTracker $this, Map map2) {
        $this.stashes = map2;
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(GitStashTracker $this) {
        return $this.eventDispatcher;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes;", "", "()V", "Error", "Loaded", "Lgit4idea/stash/GitStashTracker$Stashes$Loaded;", "Lgit4idea/stash/GitStashTracker$Stashes$Error;", "intellij.vcs.git"})
    public static abstract class Stashes {
        private Stashes() {
        }

        public /* synthetic */ Stashes(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes$Loaded;", "Lgit4idea/stash/GitStashTracker$Stashes;", "stashes", "", "Lgit4idea/ui/StashInfo;", "(Ljava/util/List;)V", "getStashes", "()Ljava/util/List;", "intellij.vcs.git"})
        public static final class Loaded
        extends Stashes {
            @NotNull
            private final List<StashInfo> stashes;

            @NotNull
            public final List<StashInfo> getStashes() {
                return this.stashes;
            }

            public Loaded(@NotNull List<StashInfo> stashes) {
                Intrinsics.checkNotNullParameter(stashes, (String)"stashes");
                super(null);
                this.stashes = stashes;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/GitStashTracker$Stashes$Error;", "Lgit4idea/stash/GitStashTracker$Stashes;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/vcs/VcsException;)V", "getError", "()Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
        public static final class Error
        extends Stashes {
            @NotNull
            private final VcsException error;

            @NotNull
            public final VcsException getError() {
                return this.error;
            }

            public Error(@NotNull VcsException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                super(null);
                this.error = error;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/stash/GitStashTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

