/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.maven.MavenJpsBundle;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTargetType;

public class MavenResourcesBuilder
extends TargetBuilder<MavenResourceRootDescriptor, MavenResourcesTarget> {
    private static final Logger LOG = Logger.getInstance(MavenResourcesBuilder.class);

    public MavenResourcesBuilder() {
        super(Arrays.asList(MavenResourcesTargetType.PRODUCTION, MavenResourcesTargetType.TEST));
    }

    public void build(final @NotNull MavenResourcesTarget target, @NotNull DirtyFilesHolder<MavenResourceRootDescriptor, MavenResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(3);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        if (projectConfig == null) {
            context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.resources.compiler", new Object[0]), BuildMessage.Kind.ERROR, MavenJpsBundle.message("maven.project.configuration.required", target.getModule().getName())));
            throw new StopBuildException();
        }
        MavenModuleResourceConfiguration config = target.getModuleResourcesConfiguration(dataPaths);
        if (config == null) {
            return;
        }
        final HashMap files = new HashMap();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<MavenResourceRootDescriptor, MavenResourcesTarget>(){

            public boolean apply(MavenResourcesTarget t, File file, MavenResourceRootDescriptor rd) throws IOException {
                assert (target == t);
                ArrayList<File> fileList = (ArrayList<File>)files.get((Object)rd);
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    files.put(rd, fileList);
                }
                fileList.add(file);
                return true;
            }
        });
        MavenResourceRootDescriptor[] roots = files.keySet().toArray(new MavenResourceRootDescriptor[0]);
        Arrays.sort(roots, (r1, r2) -> {
            int res = r1.getIndexInPom() - r2.getIndexInPom();
            if (r1.isOverwrite()) {
                assert (r2.isOverwrite());
                return res;
            }
            if (r1.getConfiguration().isFiltered && !r2.getConfiguration().isFiltered) {
                return 1;
            }
            if (!r1.getConfiguration().isFiltered && r2.getConfiguration().isFiltered) {
                return -1;
            }
            if (!r1.getConfiguration().isFiltered) {
                res = -res;
            }
            return res;
        });
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfig, target.getModule().getProject(), config);
        context.processMessage((BuildMessage)new ProgressMessage(MavenJpsBundle.message("copying.resources", target.getModule().getName())));
        for (MavenResourceRootDescriptor rd : roots) {
            for (File file : (List)files.get((Object)rd)) {
                String relPath = FileUtil.getRelativePath((File)rd.getRootFile(), (File)file);
                if (relPath == null) continue;
                String outputDirectory = target.isTests() ? config.testOutputDirectory : config.outputDirectory;
                File outputDir = MavenResourcesTarget.getOutputDir(target.getModuleOutputDir(), rd.getConfiguration(), outputDirectory);
                if (outputDir == null) continue;
                File outputFile = new File(outputDir, relPath);
                String sourcePath = file.getPath();
                try {
                    fileProcessor.copyFile(file, outputFile, rd.getConfiguration(), context, FileFilters.EVERYTHING);
                    outputConsumer.registerOutputFile(outputFile, Collections.singleton(sourcePath));
                }
                catch (UnsupportedEncodingException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.resources.compiler", new Object[0]), BuildMessage.Kind.INFO, MavenJpsBundle.message("resource.was.not.copied", e.getMessage()), sourcePath));
                }
                catch (IOException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(MavenJpsBundle.message("maven.resources.compiler", new Object[0]), BuildMessage.Kind.ERROR, MavenJpsBundle.message("failed.to.copy.0.to.1.2", sourcePath, outputFile.getAbsolutePath(), e.getMessage())));
                    LOG.info((Throwable)e);
                }
                if (!context.getCancelStatus().isCanceled()) continue;
                return;
            }
        }
        context.checkCanceled();
        context.processMessage((BuildMessage)new ProgressMessage(""));
    }

    @NotNull
    public String getPresentableName() {
        String string = MavenJpsBundle.message("maven.resources.compiler", new Object[0]);
        if (string == null) {
            MavenResourcesBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

