/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SetKeywordsDialog
extends DialogWrapper {
    private static final List<@NlsSafe String> KNOWN_KEYWORDS = ContainerUtil.newArrayList((Object[])new String[]{"Id", "HeadURL", "LastChangedDate", "LastChangedRevision", "LastChangedBy"});
    private static final Map<String, String> KNOWN_KEYWORD_ALIASES = ContainerUtil.immutableMapBuilder().put((Object)"URL", (Object)"HeadURL").put((Object)"Date", (Object)"LastChangedDate").put((Object)"Revision", (Object)"LastChangedRevision").put((Object)"Rev", (Object)"LastChangedRevision").put((Object)"Author", (Object)"LastChangedBy").build();
    @Nullable
    private final PropertyValue myKeywordsValue;
    @NotNull
    private final List<JCheckBox> myKeywordOptions = new ArrayList<JCheckBox>();

    protected SetKeywordsDialog(Project project, @Nullable PropertyValue keywordsValue) {
        super(project, false);
        this.myKeywordsValue = keywordsValue;
        this.setTitle(SvnBundle.message("dialog.title.svn.keywords", new Object[0]));
        this.setResizable(false);
        this.init();
    }

    @Nullable
    public String getKeywords() {
        List selectedKeywords = ContainerUtil.filter(this.myKeywordOptions, keywordOption -> keywordOption.isSelected());
        return StringUtil.nullize((String)StringUtil.join((Collection)selectedKeywords, keywordOption -> keywordOption.getText(), (String)" "));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JBLabel(SvnBundle.message("label.select.keywords.to.set", new Object[0])), "North");
        JPanel buttonsPanel = new JPanel(new GridLayout(5, 1));
        for (String keyword : KNOWN_KEYWORDS) {
            JCheckBox keywordOption = new JCheckBox(keyword);
            this.myKeywordOptions.add(keywordOption);
            buttonsPanel.add(keywordOption);
        }
        panel2.add((Component)buttonsPanel, "Center");
        return panel2;
    }

    protected void init() {
        super.init();
        this.updateKeywordOptions();
    }

    private void updateKeywordOptions() {
        Set<String> keywords = SetKeywordsDialog.parseKeywords(this.myKeywordsValue);
        for (JCheckBox keywordOption : this.myKeywordOptions) {
            keywordOption.setSelected(keywords.contains(keywordOption.getText()));
        }
    }

    @NotNull
    private static Set<String> parseKeywords(@Nullable PropertyValue keywordsValue) {
        HashSet<String> result = new HashSet<String>();
        if (keywordsValue != null) {
            for (String keyword : StringUtil.split((String)PropertyValue.toString(keywordsValue), (String)" ")) {
                result.add((String)ObjectUtils.notNull((Object)KNOWN_KEYWORD_ALIASES.get(keyword), (Object)keyword));
            }
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            SetKeywordsDialog.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/SetKeywordsDialog", "parseKeywords"));
    }
}

