/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.activity;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class LombokBuildManagerListener
implements BuildManagerListener {
    public void beforeBuildProcessStarted(@NotNull Project project, @NotNull UUID sessionId) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(0);
        }
        if (sessionId == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(1);
        }
        if (!LombokBuildManagerListener.hasAnnotationProcessorsEnabled(project) && ((Boolean)ReadAction.nonBlocking(() -> LombokLibraryUtil.hasLombokLibrary(project)).executeSynchronously()).booleanValue()) {
            LombokBuildManagerListener.suggestEnableAnnotations(project);
        }
    }

    private static CompilerConfigurationImpl getCompilerConfiguration(@NotNull Project project) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(2);
        }
        return (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
    }

    private static boolean hasAnnotationProcessorsEnabled(@NotNull Project project) {
        CompilerConfigurationImpl compilerConfiguration;
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(3);
        }
        return (compilerConfiguration = LombokBuildManagerListener.getCompilerConfiguration(project)).getDefaultProcessorProfile().isEnabled() && ContainerUtil.and((Iterable)compilerConfiguration.getModuleProcessorProfiles(), AnnotationProcessingConfiguration::isEnabled);
    }

    private static void enableAnnotationProcessors(@NotNull Project project) {
        if (project == null) {
            LombokBuildManagerListener.$$$reportNull$$$0(4);
        }
        CompilerConfigurationImpl compilerConfiguration = LombokBuildManagerListener.getCompilerConfiguration(project);
        compilerConfiguration.getDefaultProcessorProfile().setEnabled(true);
        compilerConfiguration.getModuleProcessorProfiles().forEach(pp -> pp.setEnabled(true));
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(LombokBundle.message("popup.content.java.annotation.processing.has.been.enabled", new Object[0]), MessageType.INFO, null).setFadeoutTime(3000L).createBalloon().show(RelativePoint.getNorthEastOf((JComponent)statusBar.getComponent()), Balloon.Position.atRight);
    }

    private static void suggestEnableAnnotations(Project project) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Lombok plugin");
        Notification notification = notificationGroup.createNotification(LombokBundle.message("config.warn.annotation-processing.disabled.title", new Object[0]), LombokBundle.message("config.warn.annotation-processing.disabled.message", new Object[0]), NotificationType.ERROR);
        notification.setListener((not, e) -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                LombokBuildManagerListener.enableAnnotationProcessors(project);
                not.expire();
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/activity/LombokBuildManagerListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeBuildProcessStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompilerConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAnnotationProcessorsEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "enableAnnotationProcessors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

