/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.EqualsAndHashCodeProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.GetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ToStringProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AllArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.NoArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ValueProcessor
extends AbstractClassProcessor {
    public ValueProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Value");
    }

    private ToStringProcessor getToStringProcessor() {
        return (ToStringProcessor)ApplicationManager.getApplication().getService(ToStringProcessor.class);
    }

    private AllArgsConstructorProcessor getAllArgsConstructorProcessor() {
        return (AllArgsConstructorProcessor)ApplicationManager.getApplication().getService(AllArgsConstructorProcessor.class);
    }

    private NoArgsConstructorProcessor getNoArgsConstructorProcessor() {
        return (NoArgsConstructorProcessor)ApplicationManager.getApplication().getService(NoArgsConstructorProcessor.class);
    }

    private GetterProcessor getGetterProcessor() {
        return (GetterProcessor)ApplicationManager.getApplication().getService(GetterProcessor.class);
    }

    private EqualsAndHashCodeProcessor getEqualsAndHashCodeProcessor() {
        return (EqualsAndHashCodeProcessor)ApplicationManager.getApplication().getService(EqualsAndHashCodeProcessor.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        PsiAnnotation equalsAndHashCodeAnnotation;
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            ValueProcessor.$$$reportNull$$$0(2);
        }
        if (null == (equalsAndHashCodeAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode"))) {
            this.getEqualsAndHashCodeProcessor().validateCallSuperParamExtern(psiAnnotation, psiClass, builder);
        }
        return this.validateAnnotationOnRightType(psiClass, builder);
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            ValueProcessor.$$$reportNull$$$0(4);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addError(LombokBundle.message("inspection.message.value.only.supported.on.class.type", new Object[0]));
            result = false;
        }
        return result;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(5);
        }
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(6);
        }
        if (target == null) {
            ValueProcessor.$$$reportNull$$$0(7);
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Getter")) {
            target.addAll(this.getGetterProcessor().createFieldGetters(psiClass, "public"));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode")) {
            target.addAll(this.getEqualsAndHashCodeProcessor().createEqualAndHashCode(psiClass, psiAnnotation));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.ToString")) {
            target.addAll(this.getToStringProcessor().createToStringMethod(psiClass, psiAnnotation));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.Builder")) {
            Collection<PsiMethod> definedConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
            this.filterToleratedElements(definedConstructors);
            String staticName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "staticConstructor", "");
            Collection<PsiField> requiredFields = this.getAllArgsConstructorProcessor().getAllFields(psiClass);
            if (this.getAllArgsConstructorProcessor().validateIsConstructorNotDefined(psiClass, staticName, requiredFields, ProblemEmptyBuilder.getInstance())) {
                target.addAll(this.getAllArgsConstructorProcessor().createAllArgsConstructor(psiClass, "public", psiAnnotation, staticName, requiredFields, true));
            }
        }
        if (this.shouldGenerateExtraNoArgsConstructor(psiClass)) {
            target.addAll(this.getNoArgsConstructorProcessor().createNoArgsConstructor(psiClass, "private", psiAnnotation, true));
        }
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(8);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addClassAnnotation(result, psiClass, "lombok.experimental.NonFinal", "lombok.experimental.PackagePrivate");
        this.addFieldsAnnotation(result, psiClass, "lombok.experimental.NonFinal", "lombok.experimental.PackagePrivate");
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            ValueProcessor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            ValueProcessor.$$$reportNull$$$0(10);
        }
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(11);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/ValueProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/ValueProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

