/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.BuilderElementHandler;
import de.plushnikov.intellij.plugin.processor.handler.singular.SingularHandlerFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class BuilderInfo {
    private static final String BUILDER_OBTAIN_VIA_FIELD = "field";
    private static final String BUILDER_OBTAIN_VIA_METHOD = "method";
    private static final String BUILDER_OBTAIN_VIA_STATIC = "isStatic";
    private static final String BUILDER_OBTAIN_VIA_ANNOTATION = "lombok.Builder.ObtainVia";
    private static final String BUILDER_DEFAULT_ANNOTATION = "lombok.Builder.Default";
    private PsiVariable variableInClass;
    private PsiType fieldInBuilderType;
    private boolean deprecated;
    private String visibilityModifier;
    private String setterPrefix;
    private String builderChainResult = "this";
    private PsiClass builderClass;
    private PsiType builderClassType;
    private String fieldInBuilderName;
    private PsiExpression fieldInitializer;
    private boolean hasBuilderDefaultAnnotation;
    private PsiAnnotation singularAnnotation;
    private BuilderElementHandler builderElementHandler;
    private PsiAnnotation obtainViaAnnotation;
    private String viaFieldName;
    private String viaMethodName;
    private boolean viaStaticCall;
    private String instanceVariableName = "this";

    public static BuilderInfo fromPsiParameter(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            BuilderInfo.$$$reportNull$$$0(0);
        }
        BuilderInfo result = new BuilderInfo();
        result.variableInClass = psiParameter;
        result.fieldInBuilderType = psiParameter.getType();
        result.deprecated = BuilderInfo.hasDeprecatedAnnotation((PsiModifierListOwner)psiParameter);
        result.fieldInitializer = null;
        result.hasBuilderDefaultAnnotation = false;
        result.fieldInBuilderName = psiParameter.getName();
        result.singularAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiParameter, "lombok.Singular");
        result.builderElementHandler = SingularHandlerFactory.getHandlerFor((PsiVariable)psiParameter, null != result.singularAnnotation);
        return result;
    }

    private static boolean hasDeprecatedAnnotation(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            BuilderInfo.$$$reportNull$$$0(1);
        }
        return PsiAnnotationSearchUtil.isAnnotatedWith(modifierListOwner, Deprecated.class.getName());
    }

    public static BuilderInfo fromPsiField(@NotNull PsiField psiField) {
        if (psiField == null) {
            BuilderInfo.$$$reportNull$$$0(2);
        }
        BuilderInfo result = new BuilderInfo();
        result.variableInClass = psiField;
        result.deprecated = BuilderInfo.isDeprecated(psiField);
        result.fieldInBuilderType = psiField.getType();
        result.fieldInitializer = psiField.getInitializer();
        result.hasBuilderDefaultAnnotation = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, BUILDER_DEFAULT_ANNOTATION);
        AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
        result.fieldInBuilderName = accessorsInfo.removePrefix(psiField.getName());
        result.singularAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.Singular");
        result.builderElementHandler = SingularHandlerFactory.getHandlerFor((PsiVariable)psiField, null != result.singularAnnotation);
        return result;
    }

    private static boolean isDeprecated(@NotNull PsiField psiField) {
        if (psiField == null) {
            BuilderInfo.$$$reportNull$$$0(3);
        }
        return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)psiField) || BuilderInfo.hasDeprecatedAnnotation((PsiModifierListOwner)psiField);
    }

    public BuilderInfo withSubstitutor(@NotNull PsiSubstitutor builderSubstitutor) {
        if (builderSubstitutor == null) {
            BuilderInfo.$$$reportNull$$$0(4);
        }
        this.fieldInBuilderType = builderSubstitutor.substitute(this.fieldInBuilderType);
        return this;
    }

    public BuilderInfo withVisibilityModifier(String visibilityModifier) {
        this.visibilityModifier = visibilityModifier;
        return this;
    }

    public BuilderInfo withSetterPrefix(String setterPrefix) {
        this.setterPrefix = setterPrefix;
        return this;
    }

    public BuilderInfo withBuilderClass(@NotNull PsiClass builderClass) {
        if (builderClass == null) {
            BuilderInfo.$$$reportNull$$$0(5);
        }
        this.builderClass = builderClass;
        this.builderClassType = PsiClassUtil.getTypeWithGenerics(builderClass);
        return this;
    }

    public BuilderInfo withBuilderClassType(@NotNull PsiClassType builderClassType) {
        if (builderClassType == null) {
            BuilderInfo.$$$reportNull$$$0(6);
        }
        this.builderClassType = builderClassType;
        return this;
    }

    public BuilderInfo withBuilderChainResult(@NotNull String builderChainResult) {
        if (builderChainResult == null) {
            BuilderInfo.$$$reportNull$$$0(7);
        }
        this.builderChainResult = builderChainResult;
        return this;
    }

    public BuilderInfo withObtainVia() {
        this.obtainViaAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)this.variableInClass, BUILDER_OBTAIN_VIA_ANNOTATION);
        if (null != this.obtainViaAnnotation) {
            this.viaFieldName = PsiAnnotationUtil.getStringAnnotationValue(this.obtainViaAnnotation, BUILDER_OBTAIN_VIA_FIELD, "");
            this.viaMethodName = PsiAnnotationUtil.getStringAnnotationValue(this.obtainViaAnnotation, BUILDER_OBTAIN_VIA_METHOD, "");
            this.viaStaticCall = PsiAnnotationUtil.getBooleanAnnotationValue(this.obtainViaAnnotation, BUILDER_OBTAIN_VIA_STATIC, false);
        }
        return this;
    }

    public boolean useForBuilder() {
        boolean result = true;
        PsiModifierList modifierList = this.variableInClass.getModifierList();
        if (null != modifierList) {
            boolean isInitializedFinalField;
            result = !modifierList.hasModifierProperty("static");
            boolean bl = isInitializedFinalField = null != this.fieldInitializer && modifierList.hasModifierProperty("final");
            if (isInitializedFinalField && !this.hasBuilderDefaultAnnotation) {
                result = false;
            }
        }
        return result &= !this.fieldInBuilderName.startsWith("$");
    }

    public boolean notAlreadyExistingField(Collection<String> alreadyExistingFieldNames) {
        return !alreadyExistingFieldNames.contains(this.fieldInBuilderName);
    }

    public boolean notAlreadyExistingMethod(Collection<String> alreadyExistedMethodNames) {
        return !alreadyExistedMethodNames.contains(this.calcBuilderMethodName());
    }

    public Project getProject() {
        return this.variableInClass.getProject();
    }

    public PsiManager getManager() {
        return this.variableInClass.getManager();
    }

    public String getFieldName() {
        return this.fieldInBuilderName;
    }

    public PsiType getFieldType() {
        return this.fieldInBuilderType;
    }

    public PsiVariable getVariable() {
        return this.variableInClass;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    @PsiModifier.ModifierConstant
    public String getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public String getSetterPrefix() {
        return this.setterPrefix;
    }

    public PsiClass getBuilderClass() {
        return this.builderClass;
    }

    public PsiType getBuilderType() {
        return this.builderClassType;
    }

    public String getBuilderChainResult() {
        return this.builderChainResult;
    }

    public PsiAnnotation getSingularAnnotation() {
        return this.singularAnnotation;
    }

    public boolean hasSingularAnnotation() {
        return null != this.singularAnnotation;
    }

    public boolean hasBuilderDefaultAnnotation() {
        return this.hasBuilderDefaultAnnotation;
    }

    public boolean hasNoInitializer() {
        return null == this.fieldInitializer;
    }

    public boolean hasObtainViaAnnotation() {
        return null != this.obtainViaAnnotation;
    }

    public PsiExpression getFieldInitializer() {
        return this.fieldInitializer;
    }

    public String getViaFieldName() {
        return this.viaFieldName;
    }

    public String getViaMethodName() {
        return this.viaMethodName;
    }

    public boolean isViaStaticCall() {
        return this.viaStaticCall;
    }

    public String getInstanceVariableName() {
        return this.instanceVariableName;
    }

    public Collection<String> getAnnotations() {
        if (this.deprecated) {
            return Collections.singleton("java.lang.Deprecated");
        }
        return Collections.emptyList();
    }

    public Collection<PsiField> renderBuilderFields() {
        return this.builderElementHandler.renderBuilderFields(this);
    }

    private String calcBuilderMethodName() {
        return this.builderElementHandler.calcBuilderMethodName(this);
    }

    public Collection<PsiMethod> renderBuilderMethods() {
        return this.builderElementHandler.renderBuilderMethod(this);
    }

    public String renderBuildPrepare() {
        return this.builderElementHandler.renderBuildPrepare(this);
    }

    public String renderSuperBuilderConstruction() {
        return this.builderElementHandler.renderSuperBuilderConstruction(this.variableInClass, this.fieldInBuilderName);
    }

    public String renderBuildCall() {
        return this.renderFieldName();
    }

    public String renderFieldName() {
        return this.hasBuilderDefaultAnnotation ? this.fieldInBuilderName + "$value" : this.fieldInBuilderName;
    }

    public String renderFieldDefaultSetName() {
        return this.hasBuilderDefaultAnnotation ? this.fieldInBuilderName + "$set" : null;
    }

    public String renderFieldDefaultProviderName() {
        return this.hasBuilderDefaultAnnotation ? "$default$" + this.fieldInBuilderName : null;
    }

    public CharSequence renderToBuilderCall() {
        if (this.hasObtainViaAnnotation()) {
            StringBuilder result = new StringBuilder();
            result.append(this.fieldInBuilderName);
            result.append('(');
            if (StringUtil.isNotEmpty((String)this.viaFieldName)) {
                result.append(this.instanceVariableName).append(".").append(this.viaFieldName);
            } else if (StringUtil.isNotEmpty((String)this.viaMethodName)) {
                result.append(this.viaStaticCall ? this.getPsiClass().getName() : this.instanceVariableName);
                result.append('.');
                result.append(this.viaMethodName);
                result.append((String)(this.viaStaticCall ? "(" + this.instanceVariableName + ")" : "()"));
            } else {
                result.append(this.instanceVariableName).append(".").append(this.variableInClass.getName());
            }
            result.append(')');
            return result;
        }
        return this.builderElementHandler.renderToBuilderCall(this);
    }

    private PsiClass getPsiClass() {
        return this.builderClass.getContainingClass();
    }

    public Optional<PsiType> getObtainViaFieldVariableType() {
        PsiClass resolvedPsiVariableClass;
        PsiType psiVariableType;
        PsiField fieldByName;
        PsiVariable psiVariable = this.variableInClass;
        if (StringUtil.isNotEmpty((String)this.viaFieldName) && (fieldByName = this.getPsiClass().findFieldByName(this.viaFieldName, false)) != null) {
            psiVariable = fieldByName;
        }
        if ((psiVariableType = psiVariable.getType()) instanceof PsiClassReferenceType && (resolvedPsiVariableClass = ((PsiClassReferenceType)psiVariableType).resolve()) instanceof PsiTypeParameter) {
            return Optional.of(psiVariableType);
        }
        return Optional.empty();
    }

    public void withInstanceVariableName(String instanceVariableName) {
        this.instanceVariableName = instanceVariableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderSubstitutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClassType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderChainResult";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/BuilderInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fromPsiParameter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDeprecatedAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fromPsiField";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeprecated";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withSubstitutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "withBuilderClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withBuilderClassType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "withBuilderChainResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

