/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.IncorrectOperationException;
import de.plushnikov.intellij.plugin.psi.LombokLightIdentifier;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import icons.LombokIcons;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLightFieldBuilder
extends LightFieldBuilder
implements SyntheticElement {
    private String myName;
    private final LombokLightIdentifier myNameIdentifier;
    private final LombokLightModifierList myModifierList;

    public LombokLightFieldBuilder(@NotNull PsiManager manager, @NotNull String name, @NotNull PsiType type) {
        if (manager == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(1);
        }
        if (type == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(2);
        }
        super(manager, name, type);
        this.myName = name;
        this.myNameIdentifier = new LombokLightIdentifier(manager, name);
        this.myModifierList = new LombokLightModifierList(manager);
        this.setBaseIcon(LombokIcons.Nodes.LombokField);
    }

    @NotNull
    public LombokLightModifierList getModifierList() {
        LombokLightModifierList lombokLightModifierList = this.myModifierList;
        if (lombokLightModifierList == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(3);
        }
        return lombokLightModifierList;
    }

    public LombokLightFieldBuilder setModifiers(String ... modifiers) {
        this.myModifierList.clearModifiers();
        Stream.of(modifiers).forEach(arg_0 -> ((LombokLightModifierList)this.myModifierList).addModifier(arg_0));
        return this;
    }

    public LombokLightFieldBuilder setModifierList(LightModifierList modifierList) {
        this.setModifiers(modifierList.getModifiers());
        return this;
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(4);
        }
        return this.myModifierList.hasModifierProperty(name);
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass != null ? containingClass.getContainingFile() : null;
    }

    public LombokLightFieldBuilder withContainingClass(PsiClass psiClass) {
        this.setContainingClass(psiClass);
        return this;
    }

    public LombokLightFieldBuilder withImplicitModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(5);
        }
        this.myModifierList.addImplicitModifierProperty(modifier);
        return this;
    }

    public LombokLightFieldBuilder withModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(6);
        }
        this.myModifierList.addModifier(modifier);
        return this;
    }

    public LombokLightFieldBuilder withNavigationElement(PsiElement navigationElement) {
        this.setNavigationElement(navigationElement);
        return this;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) {
        if (name == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(8);
        }
        this.myName = name;
        this.myNameIdentifier.setText(this.myName);
        return this;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        LombokLightIdentifier lombokLightIdentifier = this.myNameIdentifier;
        if (lombokLightIdentifier == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(9);
        }
        return lombokLightIdentifier;
    }

    public String toString() {
        return "LombokLightFieldBuilder: " + this.getName();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiClass containingClass;
        if (newElement == null) {
            LombokLightFieldBuilder.$$$reportNull$$$0(10);
        }
        if (null != (containingClass = this.getContainingClass())) {
            CheckUtil.checkWritable((PsiElement)containingClass);
            return containingClass.add(newElement);
        }
        return null;
    }

    public TextRange getTextRange() {
        TextRange r = super.getTextRange();
        return r == null ? TextRange.EMPTY_RANGE : r;
    }

    public void delete() throws IncorrectOperationException {
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof LombokLightFieldBuilder) {
            boolean stillEquivalent;
            LombokLightFieldBuilder anotherLightField = (LombokLightFieldBuilder)another;
            boolean bl = stillEquivalent = this.getName().equals(anotherLightField.getName()) && this.getType().equals(anotherLightField.getType());
            if (stillEquivalent) {
                PsiClass containingClass = this.getContainingClass();
                PsiClass anotherContainingClass = anotherLightField.getContainingClass();
                stillEquivalent = null == containingClass && null == anotherContainingClass || null != containingClass && containingClass.isEquivalentTo((PsiElement)anotherContainingClass);
            }
            return stillEquivalent;
        }
        return super.isEquivalentTo(another);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LombokLightFieldBuilder that = (LombokLightFieldBuilder)((Object)o);
        return Objects.equals(this.myName, that.myName) && Objects.equals((Object)this.myNameIdentifier, (Object)that.myNameIdentifier) && Objects.equals((Object)this.myModifierList, (Object)that.myModifierList) && Objects.equals(this.getContainingClass(), that.getContainingClass());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myName, this.myNameIdentifier, this.myModifierList, this.getContainingClass()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/psi/LombokLightFieldBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/psi/LombokLightFieldBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withImplicitModifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withModifier";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

