/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCodegenFactory;", "Lorg/jetbrains/kotlin/codegen/CodegenFactory;", "()V", "generateModule", "", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "generateMultifileClass", "multifileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "generatePackage", "packageFqName", "ktFiles", "backend"})
public final class DefaultCodegenFactory
implements CodegenFactory {
    @NotNull
    public static final DefaultCodegenFactory INSTANCE = new DefaultCodegenFactory();

    private DefaultCodegenFactory() {
    }

    @Override
    public void generateModule(@NotNull GenerationState state, @NotNull Collection<? extends KtFile> files2) {
        Collection collection;
        Object fileClassInfo;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        MultiMap filesInPackages = new MultiMap();
        MultiMap filesInMultifileClasses = new MultiMap();
        for (KtFile ktFile : files2) {
            fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue((Object)fileClassInfo.getFacadeClassFqName(), (Object)ktFile);
                continue;
            }
            filesInPackages.putValue((Object)ktFile.getPackageFqName(), (Object)ktFile);
        }
        HashSet obsoleteMultifileClasses = new HashSet(state.getObsoleteMultifileClasses());
        fileClassInfo = filesInMultifileClasses.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)fileClassInfo, (String)"filesInMultifileClasses.keySet()");
        for (FqName multifileClassFqName : SetsKt.plus((Set)fileClassInfo, (Iterable)obsoleteMultifileClasses)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            Intrinsics.checkNotNullExpressionValue((Object)multifileClassFqName, (String)"multifileClassFqName");
            collection = filesInMultifileClasses.get((Object)multifileClassFqName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"filesInMultifileClasses.get(multifileClassFqName)");
            this.generateMultifileClass(state, multifileClassFqName, collection);
        }
        HashSet hashSet = new HashSet(state.getPackagesWithObsoleteParts());
        Set set = hashSet;
        collection = filesInPackages.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"filesInPackages.keySet()");
        for (FqName packageFqName : SetsKt.plus((Set)set, (Iterable)collection)) {
            CodegenFactory.Companion.doCheckCancelled(state);
            Intrinsics.checkNotNullExpressionValue((Object)packageFqName, (String)"packageFqName");
            Collection collection2 = filesInPackages.get((Object)packageFqName);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"filesInPackages.get(packageFqName)");
            this.generatePackage(state, packageFqName, collection2);
        }
    }

    private final void generateMultifileClass(GenerationState state, FqName multifileClassFqName, Collection<? extends KtFile> files2) {
        state.getFactory().forMultifileClass(multifileClassFqName, files2).generate();
    }

    public final void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        state.getFactory().forPackage(packageFqName, ktFiles).generate();
    }
}

