/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u000256B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b/J\u0010\u00100\u001a\u00020*2\u0006\u0010$\u001a\u00020#H\u0002J\r\u00101\u001a\u00020*H\u0000\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b4R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000b@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R,\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000b@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u0004\u0018\u00010\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010$\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000\u001d8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001f\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "name", "", "kind", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/lang/String;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;)V", "_nodes", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "_subGraphs", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<set-?>", "enterNode", "getEnterNode", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "setEnterNode$resolve", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "exitNode", "getExitNode", "setExitNode$resolve", "getKind", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "getName", "()Ljava/lang/String;", "nodes", "", "getNodes", "()Ljava/util/List;", "owner", "getOwner", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$State;", "state", "getState", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$State;", "subGraphs", "getSubGraphs", "addNode", "", "node", "addNode$resolve", "addSubGraph", "graph", "addSubGraph$resolve", "assertState", "complete", "complete$resolve", "removeSubGraph", "removeSubGraph$resolve", "Kind", "State", "resolve"})
public final class ControlFlowGraph {
    @Nullable
    private final FirDeclaration declaration;
    @NotNull
    private final String name;
    @NotNull
    private final Kind kind;
    @NotNull
    private List<CFGNode<?>> _nodes;
    public CFGNode<?> enterNode;
    public CFGNode<?> exitNode;
    @Nullable
    private ControlFlowGraph owner;
    @NotNull
    private State state;
    @NotNull
    private final List<ControlFlowGraph> _subGraphs;

    public ControlFlowGraph(@Nullable FirDeclaration declaration, @NotNull String name, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.declaration = declaration;
        this.name = name;
        this.kind = kind;
        boolean bl = false;
        this._nodes = new ArrayList();
        this.state = State.Building;
        bl = false;
        this._subGraphs = new ArrayList();
    }

    @Nullable
    public final FirDeclaration getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final List<CFGNode<?>> getNodes() {
        return this._nodes;
    }

    public final void addNode$resolve(@NotNull CFGNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        this.assertState(State.Building);
        this._nodes.add(node);
    }

    @NotNull
    public final CFGNode<?> getEnterNode() {
        CFGNode<?> cFGNode = this.enterNode;
        if (cFGNode != null) {
            return cFGNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"enterNode");
        throw null;
    }

    public final void setEnterNode$resolve(@NotNull CFGNode<?> cFGNode) {
        Intrinsics.checkNotNullParameter(cFGNode, (String)"<set-?>");
        this.enterNode = cFGNode;
    }

    @NotNull
    public final CFGNode<?> getExitNode() {
        CFGNode<?> cFGNode = this.exitNode;
        if (cFGNode != null) {
            return cFGNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"exitNode");
        throw null;
    }

    public final void setExitNode$resolve(@NotNull CFGNode<?> cFGNode) {
        Intrinsics.checkNotNullParameter(cFGNode, (String)"<set-?>");
        this.exitNode = cFGNode;
    }

    @Nullable
    public final ControlFlowGraph getOwner() {
        return this.owner;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @NotNull
    public final List<ControlFlowGraph> getSubGraphs() {
        return this._subGraphs;
    }

    public final void complete$resolve() {
        this.assertState(State.Building);
        this.state = State.Completed;
        if (this.kind == Kind.Stub) {
            return;
        }
        LinkedHashSet sortedNodes2 = ControlFlowGraphKt.access$orderNodes(this);
        this._nodes.clear();
        this._nodes.addAll(sortedNodes2);
    }

    public final void addSubGraph$resolve(@NotNull ControlFlowGraph graph2) {
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        boolean bl = graph2.owner == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "SubGraph already has owner";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        graph2.owner = this;
        ControlFlowGraph controlFlowGraph = this;
        Collection collection = controlFlowGraph._subGraphs;
        boolean bl4 = false;
        collection.add(graph2);
    }

    public final void removeSubGraph$resolve(@NotNull ControlFlowGraph graph2) {
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        boolean bl = Intrinsics.areEqual((Object)graph2.owner, (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this._subGraphs.remove(graph2);
        graph2.owner = null;
        CFGNode.Companion.removeAllIncomingEdges$resolve(graph2.getEnterNode());
        CFGNode.Companion.removeAllOutgoingEdges$resolve(graph2.getExitNode());
    }

    private final void assertState(State state) {
        boolean bl = this.state == state;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "This action can not be performed at " + this + " state";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$State;", "", "(Ljava/lang/String;I)V", "Building", "Completed", "resolve"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Building = new State();
        public static final /* enum */ State Completed = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            State[] stateArray = $VALUES;
            State[] stateArray2 = new State[stateArray.length];
            System.arraycopy(stateArray, 0, stateArray2, 0, stateArray.length);
            return stateArray2;
        }

        public static State valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.Building, State.Completed};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "", "withBody", "", "(Ljava/lang/String;IZ)V", "getWithBody", "()Z", "Function", "AnonymousFunction", "ClassInitializer", "PropertyInitializer", "TopLevel", "AnnotationCall", "DefaultArgument", "Stub", "resolve"})
    public static final class Kind
    extends Enum<Kind> {
        private final boolean withBody;
        public static final /* enum */ Kind Function = new Kind(true);
        public static final /* enum */ Kind AnonymousFunction = new Kind(true);
        public static final /* enum */ Kind ClassInitializer = new Kind(true);
        public static final /* enum */ Kind PropertyInitializer = new Kind(true);
        public static final /* enum */ Kind TopLevel = new Kind(false);
        public static final /* enum */ Kind AnnotationCall = new Kind(true);
        public static final /* enum */ Kind DefaultArgument = new Kind(false);
        public static final /* enum */ Kind Stub = new Kind(true);
        private static final /* synthetic */ Kind[] $VALUES;

        private Kind(boolean withBody) {
            this.withBody = withBody;
        }

        public final boolean getWithBody() {
            return this.withBody;
        }

        public static Kind[] values() {
            Kind[] kindArray = $VALUES;
            Kind[] kindArray2 = new Kind[kindArray.length];
            System.arraycopy(kindArray, 0, kindArray2, 0, kindArray.length);
            return kindArray2;
        }

        public static Kind valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(Kind.class, value2);
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.Function, Kind.AnonymousFunction, Kind.ClassInitializer, Kind.PropertyInitializer, Kind.TopLevel, Kind.AnnotationCall, Kind.DefaultArgument, Kind.Stub};
        }
    }
}

