/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class InlineParameterChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineParameterChecker INSTANCE = new InlineParameterChecker();

    private InlineParameterChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration instanceof KtFunction)) break block5;
            boolean inline = declaration.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration).getValueParameters()) {
                Object object;
                Object object2;
                VariableDescriptor parameterDescriptor;
                block7: {
                    block6: {
                        parameterDescriptor = (VariableDescriptor)context2.getTrace().get(BindingContext.VALUE_PARAMETER, parameter);
                        if (!inline) break block6;
                        if (parameterDescriptor == null) break block7;
                        object2 = parameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameterDescriptor.type");
                        if (FunctionTypesKt.isBuiltinFunctionalType(object2)) break block7;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                    object2 = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"NOINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, (KtModifierKeywordToken)((Object)object2), context2.getTrace());
                    object2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, (KtModifierKeywordToken)((Object)object2), context2.getTrace());
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD) || parameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD) || !Intrinsics.areEqual((object2 = parameterDescriptor) == null ? null : ((object = object2.getType()) == null ? null : Boolean.valueOf(FunctionTypesKt.isSuspendFunctionType((KotlinType)object))), (Object)true)) continue;
                if (declaration.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    KtElementImplStub ktElementImplStub = parameter.getTypeReference();
                    Intrinsics.checkNotNull((Object)ktElementImplStub);
                    Object typeReference = object = ktElementImplStub;
                    KtModifierList ktModifierList = ((KtModifierListOwnerStub)typeReference).getModifierList();
                    Intrinsics.checkNotNull((Object)ktModifierList);
                    KtElementImplStub modifierList2 = ktElementImplStub = ktModifierList;
                    PsiElement psiElement = ((KtModifierList)modifierList2).getModifier(KtTokens.SUSPEND_KEYWORD);
                    Intrinsics.checkNotNull((Object)psiElement);
                    KtModifierList modifier = ktModifierList = psiElement;
                    context2.getTrace().report(Errors.REDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE.on((PsiElement)modifier));
                    continue;
                }
                context2.getTrace().report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(KtParameter $this$reportIncorrectInline, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        KtModifierList ktModifierList = $this$reportIncorrectInline.getModifierList();
        PsiElement modifier = ktModifierList == null ? null : ktModifierList.getModifier(modifierToken);
        ktModifierList = modifier;
        if (ktModifierList != null) {
            KtModifierList ktModifierList2 = ktModifierList;
            boolean bl = false;
            boolean bl2 = false;
            KtModifierList it = ktModifierList2;
            boolean bl3 = false;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }
}

