/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.CompileTimeUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "receiverClass", "Ljava/lang/Class;", "typeFqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getValue", "()Ljava/lang/Object;", "getJavaOriginalName", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getMethod", "Ljava/lang/invoke/MethodHandle;", "toString", "Companion", "ir.interpreter"})
public final class Wrapper
extends Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object value;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final FqNameUnsafe typeFqName;
    @NotNull
    private final Class<? extends Object> receiverClass;
    @NotNull
    private static final Map<String, Object> companionObjectValue = MapsKt.mapOf(TuplesKt.to("kotlin.text.Regex$Companion", Regex.Companion));

    public Wrapper(@NotNull Object value2, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        boolean bl = false;
        super(irClass2, new ArrayList());
        this.value = value2;
        this.irClass = irClass2;
        FqNameUnsafe fqNameUnsafe = AdditionalIrUtilsKt.getFqNameForIrSerialization(this.getIrClass()).toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "irClass.fqNameForIrSerialization.toUnsafe()");
        this.typeFqName = fqNameUnsafe;
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction2) {
        Object object;
        Object v4;
        block10: {
            void $this$firstOrNull$iv;
            Object object2;
            Object object3;
            CharSequence charSequence;
            Boolean bl;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            String string2 = UtilsKt.getEvaluateIntrinsicValue(irFunction2);
            if (string2 == null) {
                bl = null;
            } else {
                charSequence = string2;
                boolean bl2 = false;
                bl = charSequence.length() == 0;
            }
            if (Intrinsics.areEqual(bl, true)) {
                return null;
            }
            Object object4 = object3 = irFunction2 instanceof IrSimpleFunction ? (Object)irFunction2 : null;
            Object object5 = object3 == null ? null : (charSequence = (object2 = object3.getCorrespondingPropertySymbol()) == null ? null : (IrProperty)object2.getOwner());
            String propertyName = charSequence == null ? null : ((object3 = charSequence.getName()) == null ? null : object3.asString());
            object3 = new String[2];
            object3[0] = propertyName;
            object2 = propertyName;
            object3[1] = Intrinsics.stringPlus("get", object2 == null ? null : CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object2));
            object3 = CollectionsKt.listOfNotNull(object3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl3;
                block9: {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    Method[] methodArray = this.receiverClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue(methodArray, "receiverClass.methods");
                    Object[] $this$any$iv = methodArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        Method method = (Method)element$iv2;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual(method.getName(), it)) continue;
                        bl3 = true;
                        break block9;
                    }
                    bl3 = false;
                }
                if (!bl3) continue;
                v4 = element$iv;
                break block10;
            }
            v4 = null;
        }
        String propertyCall = v4;
        String intrinsicName = this.getJavaOriginalName(irFunction2);
        String string3 = intrinsicName;
        if (string3 == null) {
            String string4 = propertyCall;
            if (string4 == null) {
                String string5 = irFunction2.getName().toString();
                Intrinsics.checkNotNullExpressionValue(string5, "irFunction.name.toString()");
                object = string5;
            } else {
                object = string4;
            }
        } else {
            object = string3;
        }
        Object methodName = object;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction2);
        return MethodHandles.lookup().findVirtual(this.receiverClass, (String)methodName, methodType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getJavaOriginalName(IrFunction irFunction2) {
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(UtilsKt.getLastOverridden(irFunction2));
        if (fqName2 == null) {
            return null;
        }
        String string2 = fqName2.asString();
        String string3 = string2;
        if (string3 == null) return null;
        int n = -1;
        switch (string3.hashCode()) {
            case 73906511: {
                if (string3.equals("kotlin.collections.Map.<get-keys>")) {
                    n = 1;
                }
                break;
            }
            case -1544237172: {
                if (string3.equals("kotlin.CharSequence.get")) {
                    n = 2;
                }
                break;
            }
            case 113597193: {
                if (string3.equals("kotlin.collections.Map.<get-entries>")) {
                    n = 3;
                }
                break;
            }
            case 2038007751: {
                if (string3.equals("kotlin.collections.MutableList.removeAt")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                return "entrySet";
            }
            case 1: {
                return "keySet";
            }
            case 2: {
                return "charAt";
            }
            case 4: {
                return "remove";
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public String toString() {
        return "Wrapper(obj='" + this.typeFqName + "', value=" + this.value + ')';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\rJ\u001c\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\rH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\rH\u0002J\f\u0010\u001f\u001a\u00020\u0019*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u0019*\u00020\rH\u0002J\u0014\u0010!\u001a\u00020\u0019*\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "()V", "companionObjectValue", "", "", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getConstructorMethod", "Ljava/lang/invoke/MethodHandle;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnumEntry", "enumClass", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getStaticMethod", "irFunction", "getClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "", "getMethodType", "Ljava/lang/invoke/MethodType;", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "isExtensionReceiverPrimitive", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass2) {
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            String string2 = UtilsKt.getEvaluateIntrinsicValue(irClass2);
            Intrinsics.checkNotNull(string2);
            String objectName = string2;
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw new AssertionError((Object)("Companion object " + objectName + " cannot be interpreted"));
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass2);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor2) {
            Intrinsics.checkNotNullParameter(irConstructor2, "irConstructor");
            String intrinsicValue = UtilsKt.getEvaluateIntrinsicValue(IrUtilsKt.getParentAsClass(irConstructor2));
            if (Intrinsics.areEqual(intrinsicValue, "kotlin.Char") || Intrinsics.areEqual(intrinsicValue, "kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor2);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor2.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction2) {
            Boolean bl;
            String intrinsicName;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            String string2 = intrinsicName = UtilsKt.getEvaluateIntrinsicValue(irFunction2);
            if (string2 == null) {
                bl = null;
            } else {
                CharSequence charSequence = string2;
                boolean bl2 = false;
                bl = charSequence.length() == 0;
            }
            if (Intrinsics.areEqual(bl, true)) {
                return null;
            }
            Intrinsics.checkNotNull(intrinsicName);
            Class<?> jvmClassName = Class.forName(intrinsicName);
            MethodType methodType = this.getMethodType(irFunction2);
            return MethodHandles.lookup().findStatic(jvmClassName, irFunction2.getName().asString(), methodType);
        }

        @Nullable
        public final MethodHandle getStaticGetter(@NotNull IrField field) {
            Intrinsics.checkNotNullParameter(field, "field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field)), true);
            Class<? extends Object> returnType2 = this.getClass(field.getType(), false);
            return MethodHandles.lookup().findStaticGetter(jvmClass, field.getName().asString(), returnType2);
        }

        @Nullable
        public final MethodHandle getEnumEntry(@NotNull IrClass enumClass2) {
            Boolean bl;
            String intrinsicName;
            Intrinsics.checkNotNullParameter(enumClass2, "enumClass");
            String string2 = intrinsicName = UtilsKt.getEvaluateIntrinsicValue(enumClass2);
            if (string2 == null) {
                bl = null;
            } else {
                CharSequence charSequence = string2;
                boolean bl2 = false;
                bl = charSequence.length() == 0;
            }
            if (Intrinsics.areEqual(bl, true)) {
                return null;
            }
            Intrinsics.checkNotNull(intrinsicName);
            Class<?> enumClassName = Class.forName(intrinsicName);
            MethodType methodType = MethodType.methodType(enumClassName, String.class);
            return MethodHandles.lookup().findStatic(enumClassName, "valueOf", methodType);
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            MethodType methodType2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getMethodType.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Class<? extends Object> clazz = Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndex()));
                collection.add(clazz);
            }
            List argsClasses = (List)destination$iv$iv;
            if ($this$getMethodType instanceof IrSimpleFunction) {
                IrType irType;
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                IrValueParameter irValueParameter = $this$getMethodType.getExtensionReceiverParameter();
                Class<? extends Object> extensionClass = irValueParameter == null ? null : ((irType = irValueParameter.getType()) == null ? null : this.getClass(irType, this.isExtensionReceiverPrimitive($this$getMethodType)));
                methodType2 = MethodType.methodType(returnClass, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(extensionClass), (Iterable)argsClasses));
                Intrinsics.checkNotNullExpressionValue(methodType2, "{\n                // for regular methods and functions\n                val returnClass = this.returnType.getClass(this.isReturnTypePrimitiveAsObject())\n                val extensionClass = this.extensionReceiverParameter?.type?.getClass(this.isExtensionReceiverPrimitive())\n\n                MethodType.methodType(returnClass, listOfNotNull(extensionClass) + argsClasses)\n            }");
                methodType = methodType2;
            } else {
                methodType2 = MethodType.methodType(Void.TYPE, argsClasses);
                Intrinsics.checkNotNullExpressionValue(methodType2, "{\n                // for constructors\n                MethodType.methodType(Void::class.javaPrimitiveType, argsClasses)\n            }");
                methodType = methodType2;
            }
            return methodType;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class clazz;
            Class clazz2;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass owner = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
            IrClass irClass2 = owner;
            String fqName2 = irClass2 == null ? null : ((clazz2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : ((FqName)((Object)clazz2)).asString());
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType$default(notNullType, false, 1, null) || IrTypePredicatesKt.isString(notNullType)) {
                clazz2 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                Intrinsics.checkNotNull(clazz2);
                clazz = clazz2;
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                clazz = asObject ? Object[].class : Object[].class;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (UtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.Enum")) {
                clazz = Enum.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Collection") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableCollection")) {
                clazz = Collection.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.List") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableList")) {
                clazz = List.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Set") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableSet")) {
                clazz = Set.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Map") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableMap")) {
                clazz = Map.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.ListIterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableListIterator")) {
                clazz = ListIterator.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Iterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableIterator")) {
                clazz = Iterator.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Map.Entry") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableMap.MutableEntry")) {
                clazz = Map.Entry.class;
            } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.ListIterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableListIterator")) {
                clazz = ListIterator.class;
            } else if (UtilsKt.hasAnnotation(owner, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) {
                Intrinsics.checkNotNull(owner);
                clazz2 = Class.forName(UtilsKt.getEvaluateIntrinsicValue(owner));
                Intrinsics.checkNotNullExpressionValue(clazz2, "forName(owner!!.getEvaluateIntrinsicValue())");
                clazz = clazz2;
            } else if (fqName2 == null) {
                clazz = Object.class;
            } else {
                clazz2 = Class.forName(UtilsKt.internalName(owner));
                Intrinsics.checkNotNullExpressionValue(clazz2, "forName(owner.internalName())");
                clazz = clazz2;
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            boolean bl = false;
            List overriddenSymbols2 = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                List pool = CollectionsKt.toMutableList(((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator iterator2 = pool.listIterator();
                Iterator iterator3 = iterator2;
                boolean bl2 = false;
                Iterator iterator4 = iterator3;
                while (iterator4.hasNext()) {
                    IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)iterator4.next();
                    if (((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols().isEmpty()) {
                        Collection collection = overriddenSymbols2;
                        boolean bl3 = false;
                        collection.add(symbol2);
                        iterator2.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl4 = false;
                        iterator2.add(it);
                    }
                }
            }
            if (overriddenSymbols2.isEmpty()) {
                overriddenSymbols2.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols2;
        }

        private final boolean isExtensionReceiverPrimitive(IrFunction $this$isExtensionReceiverPrimitive) {
            IrType irType;
            IrValueParameter irValueParameter = $this$isExtensionReceiverPrimitive.getExtensionReceiverParameter();
            return Intrinsics.areEqual(irValueParameter == null ? null : ((irType = irValueParameter.getType()) == null ? null : Boolean.valueOf(IrTypePredicatesKt.isPrimitiveType$default(irType, false, 1, null))), false);
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index2) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getValueParameters().get(index2).getType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getValueParameters().get(index2).getType())) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

