/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.HighlightingErrorsProviderBase;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanelProvider;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewToolWindowUtils;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemsView
implements DumbAware,
ToolWindowFactory {
    public static final String ID = "Problems View";

    @Nullable
    public static ToolWindow getToolWindow(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project).getToolWindow(ID);
    }

    public static void toggleCurrentFileProblems(@NotNull Project project, @Nullable VirtualFile file2) {
        ToolWindow window;
        if (project == null) {
            ProblemsView.$$$reportNull$$$0(0);
        }
        if ((window = ProblemsView.getToolWindow(project)) == null) {
            return;
        }
        ContentManager manager2 = window.getContentManager();
        HighlightingPanel panel2 = ProblemsView.get(HighlightingPanel.class, manager2.getSelectedContent());
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
        if (file2 == null || panel2 == null || !panel2.isShowing()) {
            ProblemsViewToolWindowUtils.INSTANCE.selectContent(manager2, "CurrentFile");
            window.setAvailable(true, null);
            toolWindowManager.activateToolWindow(window.getId(), null, true, ToolWindowEventSource.InspectionsWidget);
        } else if (file2.equals(panel2.getCurrentFile())) {
            toolWindowManager.hideToolWindow(window.getId(), false, true, ToolWindowEventSource.InspectionsWidget);
        } else {
            panel2.setCurrentFile(file2);
            toolWindowManager.activateToolWindow(window.getId(), null, true, ToolWindowEventSource.InspectionsWidget);
        }
    }

    public static void selectHighlighterIfVisible(@NotNull Project project, @NotNull RangeHighlighterEx highlighter) {
        HighlightingPanel panel2;
        if (project == null) {
            ProblemsView.$$$reportNull$$$0(1);
        }
        if (highlighter == null) {
            ProblemsView.$$$reportNull$$$0(2);
        }
        if ((panel2 = ProblemsView.get(HighlightingPanel.class, ProblemsView.getSelectedContent(project))) != null && panel2.isShowing()) {
            panel2.selectHighlighter(highlighter);
        }
    }

    @Nullable
    public static Document getDocument(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            ProblemsView.$$$reportNull$$$0(3);
        }
        PsiFileSystemItem item = file2.isDirectory() ? null : PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)file2);
        return item instanceof PsiFile ? PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)item) : null;
    }

    @Nullable
    public static ProblemsViewPanel getSelectedPanel(@Nullable Project project) {
        return ProblemsView.get(ProblemsViewPanel.class, ProblemsView.getSelectedContent(project));
    }

    @Nullable
    private static Content getSelectedContent(@Nullable Project project) {
        ToolWindow window = ProblemsView.getToolWindow(project);
        ContentManager manager2 = window == null ? null : window.getContentManagerIfCreated();
        return manager2 == null ? null : manager2.getSelectedContent();
    }

    private static void createContent(@NotNull ContentManager manager2, @NotNull ProblemsViewTab panel2) {
        if (manager2 == null) {
            ProblemsView.$$$reportNull$$$0(4);
        }
        if (panel2 == null) {
            ProblemsView.$$$reportNull$$$0(5);
        }
        if (!(panel2 instanceof JComponent)) {
            throw new IllegalArgumentException("panel is not JComponent");
        }
        JComponent component2 = (JComponent)((Object)panel2);
        Content content2 = manager2.getFactory().createContent(component2, panel2.getName(0), false);
        content2.setCloseable(false);
        manager2.addContent(content2);
    }

    private static void selectionChanged(boolean selected2, @Nullable Content content2) {
        ProblemsViewPanel panel2 = ProblemsView.get(ProblemsViewPanel.class, content2);
        if (panel2 != null) {
            panel2.selectionChangedTo(selected2);
        }
    }

    private static void visibilityChanged(boolean visible, @Nullable Content content2) {
        ProblemsViewPanel panel2 = ProblemsView.get(ProblemsViewPanel.class, content2);
        if (panel2 != null) {
            panel2.visibilityChangedTo(visible);
        }
    }

    @Nullable
    private static <T> T get(@NotNull Class<T> type, @Nullable Content content2) {
        if (type == null) {
            ProblemsView.$$$reportNull$$$0(6);
        }
        JComponent component2 = content2 == null ? null : content2.getComponent();
        return (T)(type.isInstance(component2) ? component2 : null);
    }

    static boolean isProjectErrorsEnabled() {
        return true;
    }

    public void init(@NotNull ToolWindow window) {
        if (window == null) {
            ProblemsView.$$$reportNull$$$0(7);
        }
        if (!ProblemsView.isProjectErrorsEnabled()) {
            return;
        }
        Project project = ((ToolWindowEx)window).getProject();
        HighlightingErrorsProviderBase.getInstance(project);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow window) {
        if (project == null) {
            ProblemsView.$$$reportNull$$$0(8);
        }
        if (window == null) {
            ProblemsView.$$$reportNull$$$0(9);
        }
        final ProblemsViewState state = ProblemsViewState.getInstance(project);
        state.setShowToolbar(ToggleToolbarAction.isToolbarVisible(window, project));
        ContentManager manager2 = window.getContentManager();
        for (ProblemsViewPanelProvider provider2 : (ProblemsViewPanelProvider[])ProblemsViewPanelProvider.getEP().getExtensions((AreaInstance)project)) {
            ProblemsViewTab panel2 = provider2.create();
            if (panel2 == null) continue;
            ProblemsView.createContent(manager2, panel2);
        }
        String selectedTabId = state.getSelectedTabId();
        if (selectedTabId != null) {
            ProblemsViewToolWindowUtils.INSTANCE.selectContent(manager2, selectedTabId);
        }
        ProblemsView.selectionChanged(true, manager2.getSelectedContent());
        manager2.addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean selected2 = ContentManagerEvent.ContentOperation.add == event.getOperation();
                JComponent component2 = event.getContent().getComponent();
                if (component2 instanceof ProblemsViewTab) {
                    ProblemsViewTab problemsView = (ProblemsViewTab)((Object)component2);
                    ProblemsView.selectionChanged(selected2, event.getContent());
                    if (selected2) {
                        state.setSelectedTabId(problemsView.getTabId());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/analysis/problemsView/toolWindow/ProblemsView$1", "selectionChanged"));
            }
        });
        project.getMessageBus().connect((Disposable)manager2).subscribe(ToolWindowManagerListener.TOPIC, (Object)ProblemsView.createListener());
    }

    @NotNull
    private static ToolWindowManagerListener createListener() {
        return new ToolWindowManagerListener(){
            private final AtomicBoolean orientation = new AtomicBoolean();
            private final AtomicBoolean visibility = new AtomicBoolean(true);

            @Override
            public void stateChanged(@NotNull ToolWindowManager manager2) {
                boolean visible;
                boolean vertical;
                ToolWindow window;
                if (manager2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((window = manager2.getToolWindow(ProblemsView.ID)) == null || window.isDisposed()) {
                    return;
                }
                boolean bl = vertical = !window.getAnchor().isHorizontal();
                if (vertical != this.orientation.getAndSet(vertical)) {
                    for (Content content2 : window.getContentManager().getContents()) {
                        ProblemsViewPanel panel2 = ProblemsView.get(ProblemsViewPanel.class, content2);
                        if (panel2 == null) continue;
                        panel2.orientationChangedTo(vertical);
                    }
                }
                if ((visible = window.isVisible()) != this.visibility.getAndSet(visible)) {
                    ProblemsView.visibilityChanged(visible, window.getContentManager().getSelectedContent());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/analysis/problemsView/toolWindow/ProblemsView$2", "stateChanged"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        objectArray2[1] = "com/intellij/analysis/problemsView/toolWindow/ProblemsView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleCurrentFileProblems";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectHighlighterIfVisible";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

