/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.DynamicBundle;
import com.intellij.application.options.codeStyle.MarginOptionsUtil;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.AnActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.CommaSeparatedIntegersField;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.components.fields.valueEditors.CommaSeparatedIntegersValueEditor;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class RightMarginForm {
    private IntegerField myRightMarginField;
    private JPanel myTopPanel;
    private JComboBox<String> myWrapOnTypingCombo;
    private CommaSeparatedIntegersField myVisualGuidesField;
    private AnActionLink myResetLink;
    private JLabel myVisualGuidesHint;
    private JLabel myVisualGuidesLabel;
    private AnActionLink myResetGuidesLink;
    private final Language myLanguage;
    private final CodeStyleSettings mySettings;

    public RightMarginForm(@NotNull Language language2, @NotNull CodeStyleSettings settings) {
        if (language2 == null) {
            RightMarginForm.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            RightMarginForm.$$$reportNull$$$0(1);
        }
        this.myLanguage = language2;
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myWrapOnTypingCombo.setModel(new DefaultComboBoxModel<String>(CodeStyleSettingsCustomizableOptions.getInstance().WRAP_ON_TYPING_OPTIONS));
        MarginOptionsUtil.customizeWrapOnTypingCombo(this.myWrapOnTypingCombo, settings);
        this.myVisualGuidesHint.setForeground((Color)JBColor.GRAY);
        this.myVisualGuidesHint.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myVisualGuidesLabel.setText(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]) + ":");
    }

    void createUIComponents() {
        this.myRightMarginField = new IntegerField(ApplicationBundle.message((String)"editbox.right.margin.columns", (Object[])new Object[0]), 0, 1000);
        this.myRightMarginField.getValueEditor().addListener((ValueEditor.Listener)new ValueEditor.Listener<Integer>(){

            public void valueChanged(@NotNull Integer newValue2) {
                if (newValue2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                RightMarginForm.this.myResetLink.setVisible(!newValue2.equals(RightMarginForm.this.myRightMarginField.getDefaultValue()));
                RightMarginForm.this.myRightMarginField.getEmptyText().setText(MarginOptionsUtil.getDefaultRightMarginText(RightMarginForm.this.mySettings));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/application/options/codeStyle/RightMarginForm$1", "valueChanged"));
            }
        });
        this.myRightMarginField.setCanBeEmpty(true);
        this.myRightMarginField.setDefaultValue(Integer.valueOf(-1));
        this.myRightMarginField.setMinimumSize(new Dimension(JBUIScale.scale((int)120), this.myRightMarginField.getMinimumSize().height));
        this.myVisualGuidesField = new CommaSeparatedIntegersField(ApplicationBundle.message((String)"settings.code.style.visual.guides", (Object[])new Object[0]), 0, 1000, ApplicationBundle.message((String)"settings.code.style.visual.guides.optional", (Object[])new Object[0]));
        this.myVisualGuidesField.getValueEditor().addListener((ValueEditor.Listener)new ValueEditor.Listener<List<Integer>>(){

            public void valueChanged(@NotNull List<Integer> newValue2) {
                if (newValue2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                RightMarginForm.this.myResetGuidesLink.setVisible(!RightMarginForm.this.myVisualGuidesField.isEmpty());
                RightMarginForm.this.myVisualGuidesField.getEmptyText().setText(RightMarginForm.getDefaultVisualGuidesText(RightMarginForm.this.mySettings));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/application/options/codeStyle/RightMarginForm$2", "valueChanged"));
            }
        });
        this.myResetLink = new AnActionLink(LangBundle.message((String)"action.link.reset", (Object[])new Object[0]), (AnAction)new ResetRightMarginAction());
        this.myVisualGuidesLabel = new JLabel();
        this.myResetGuidesLink = new AnActionLink(LangBundle.message((String)"action.link.reset", (Object[])new Object[0]), (AnAction)new ResetGuidesAction());
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            RightMarginForm.$$$reportNull$$$0(2);
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        this.myRightMarginField.setValue(Integer.valueOf(langSettings.RIGHT_MARGIN));
        for (int i2 = 0; i2 < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES.length; ++i2) {
            if (langSettings.WRAP_ON_TYPING != CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES[i2]) continue;
            this.myWrapOnTypingCombo.setSelectedIndex(i2);
            break;
        }
        this.myVisualGuidesField.setValue(langSettings.getSoftMargins());
        this.myResetLink.setVisible(langSettings.RIGHT_MARGIN >= 0);
        this.myResetGuidesLink.setVisible(!langSettings.getSoftMargins().isEmpty());
        this.myRightMarginField.getEmptyText().setText(MarginOptionsUtil.getDefaultRightMarginText(settings));
        this.myVisualGuidesField.getEmptyText().setText(RightMarginForm.getDefaultVisualGuidesText(settings));
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            RightMarginForm.$$$reportNull$$$0(3);
        }
        this.myRightMarginField.validateContent();
        this.myVisualGuidesField.validateContent();
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        langSettings.RIGHT_MARGIN = this.myRightMarginField.getValue();
        langSettings.WRAP_ON_TYPING = this.getSelectedWrapOnTypingValue();
        settings.setSoftMargins(this.myLanguage, this.myVisualGuidesField.getValue());
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            RightMarginForm.$$$reportNull$$$0(4);
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        return langSettings.RIGHT_MARGIN != this.myRightMarginField.getValue() || langSettings.WRAP_ON_TYPING != this.getSelectedWrapOnTypingValue() || !langSettings.getSoftMargins().equals(this.myVisualGuidesField.getValue());
    }

    private int getSelectedWrapOnTypingValue() {
        int i2 = this.myWrapOnTypingCombo.getSelectedIndex();
        if (i2 >= 0 && i2 < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES.length) {
            return CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES[i2];
        }
        return CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue;
    }

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    @NlsContexts.Label
    private static String getDefaultVisualGuidesText(@NotNull CodeStyleSettings settings) {
        List margins;
        if (settings == null) {
            RightMarginForm.$$$reportNull$$$0(5);
        }
        String marginsString = (margins = settings.getDefaultSoftMargins()).size() <= 2 ? CommaSeparatedIntegersValueEditor.intListToString((List)margins) : CommaSeparatedIntegersValueEditor.intListToString(margins.subList(0, 2)) + ",...";
        return MarginOptionsUtil.getDefaultValueText(marginsString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/RightMarginForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultVisualGuidesText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ApplicationBundle", RightMarginForm.class).getString("editbox.right.margin.columns"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", RightMarginForm.class).getString("wrapping.wrap.on.typing"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myWrapOnTypingCombo = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        IntegerField integerField = this.myRightMarginField;
        integerField.setColumns(12);
        jPanel2.add((Component)integerField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        CommaSeparatedIntegersField commaSeparatedIntegersField = this.myVisualGuidesField;
        jPanel2.add((Component)commaSeparatedIntegersField, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = this.myVisualGuidesLabel;
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/LangBundle", RightMarginForm.class).getString("label.right.margin.visual.guides"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", RightMarginForm.class).getString("margin.columns"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/ApplicationBundle", RightMarginForm.class).getString("margin.columns"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        AnActionLink anActionLink = this.myResetLink;
        this.$$$loadButtonText$$$((AbstractButton)anActionLink, DynamicBundle.getBundle((String)"messages/LangBundle", RightMarginForm.class).getString("link.right.margin.reset"));
        jPanel2.add((Component)anActionLink, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myVisualGuidesHint = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ApplicationBundle", RightMarginForm.class).getString("settings.code.style.general.visual.guides.hint"));
        jPanel2.add((Component)jLabel, new GridConstraints(3, 1, 1, 4, 8, 0, 0, 0, null, null, null));
        AnActionLink anActionLink2 = this.myResetGuidesLink;
        this.$$$loadButtonText$$$((AbstractButton)anActionLink2, DynamicBundle.getBundle((String)"messages/LangBundle", RightMarginForm.class).getString("link.right.margin.reset"));
        jPanel2.add((Component)anActionLink2, new GridConstraints(2, 3, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ResetGuidesAction
    extends DumbAwareAction {
        private ResetGuidesAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetGuidesAction.$$$reportNull$$$0(0);
            }
            RightMarginForm.this.myVisualGuidesField.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/RightMarginForm$ResetGuidesAction", "actionPerformed"));
        }
    }

    private class ResetRightMarginAction
    extends DumbAwareAction {
        private ResetRightMarginAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetRightMarginAction.$$$reportNull$$$0(0);
            }
            RightMarginForm.this.myRightMarginField.resetToDefault();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/RightMarginForm$ResetRightMarginAction", "actionPerformed"));
        }
    }
}

