/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.codeStyle.excludedFiles.ExcludedFilesPanelBase;
import com.intellij.application.options.codeStyle.excludedFiles.GlobPatternDescriptor;
import com.intellij.application.options.codeStyle.excludedFiles.NamedScopeDescriptor;
import com.intellij.application.options.codeStyle.excludedFiles.NamedScopeToGlobConverter;
import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExcludedGlobPatternsPanel
extends ExcludedFilesPanelBase {
    private static final String PATTERN_SEPARATOR = ";";
    private final ExpandableTextField myPatternsField;
    private final JComponent myConversionMessage;

    public ExcludedGlobPatternsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        c.insets = JBUI.insetsRight((int)5);
        this.add((Component)new JLabel(CodeStyleBundle.message((String)"excluded.files.glob.patterns.label", (Object[])new Object[0])), c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.fill = 2;
        c.insets = JBUI.emptyInsets();
        this.myPatternsField = new ExpandableTextField(s -> ExcludedGlobPatternsPanel.toStringList(s), strings -> StringUtil.join((Collection)strings, (String)PATTERN_SEPARATOR));
        this.add((Component)this.myPatternsField, c);
        c.gridy = 1;
        this.add((Component)ExcludedGlobPatternsPanel.createLinkComponent(), c);
        ++c.gridy;
        c.gridx = 1;
        c.insets = JBUI.insetsTop((int)5);
        this.myConversionMessage = this.createWarningMessage(CodeStyleBundle.message((String)"excluded.files.migration.message", (Object[])new Object[0]));
        this.add((Component)this.myConversionMessage, c);
        this.myConversionMessage.setVisible(false);
    }

    private static JComponent createLinkComponent() {
        JPanel linkPanel = new JPanel(new FlowLayout(0));
        String message2 = CodeStyleBundle.message((String)"excluded.files.glob.patterns.hint", (Object[])new Object[0]);
        String textPart = message2.replaceFirst("<a>.*</a>", "").trim();
        String linkPart = message2.replaceFirst("^.*<a>", "").replaceFirst("</a>.*$", "");
        JLabel hintLabel = new JLabel(textPart);
        hintLabel.setFont((Font)JBUI.Fonts.smallFont());
        hintLabel.setForeground(UIUtil.getContextHelpForeground());
        linkPanel.add(hintLabel);
        BrowserLink link2 = new BrowserLink(linkPart, "https://en.wikipedia.org/wiki/Glob_(programming)");
        link2.setFont((Font)JBUI.Fonts.smallFont());
        link2.setIconTextGap(0);
        link2.setHorizontalTextPosition(2);
        linkPanel.add((Component)link2);
        return linkPanel;
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(0);
        }
        settings.getExcludedFiles().setDescriptors("globPattern", this.getDescriptors());
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(1);
        }
        this.myPatternsField.setText(this.getPatternsText(settings));
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        boolean modified;
        if (settings == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(2);
        }
        boolean bl = modified = !settings.getExcludedFiles().getDescriptors("globPattern").equals(this.getDescriptors());
        if (!modified) {
            this.myConversionMessage.setVisible(false);
        }
        return modified;
    }

    private String getPatternsText(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(3);
        }
        ArrayList<String> patterns = new ArrayList<String>(ContainerUtil.map((Collection)settings.getExcludedFiles().getDescriptors("globPattern"), d -> d.getPattern()));
        List<String> convertedPatterns = ExcludedGlobPatternsPanel.getConvertedPatterns(settings);
        this.myConversionMessage.setVisible(convertedPatterns.size() > 0);
        patterns.addAll(convertedPatterns);
        return StringUtil.join(patterns, (String)PATTERN_SEPARATOR);
    }

    @NotNull
    private static List<String> getConvertedPatterns(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(4);
        }
        List<String> list2 = settings.getExcludedFiles().getDescriptors("namedScope").stream().map(descriptor2 -> NamedScopeToGlobConverter.convert((NamedScopeDescriptor)descriptor2)).filter(descriptor2 -> descriptor2 != null).map(descriptor2 -> descriptor2.getPattern()).collect(Collectors.toList());
        if (list2 == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private List<FileSetDescriptor> getDescriptors() {
        String patternsText = this.myPatternsField.getText();
        return ExcludedGlobPatternsPanel.toStringList(patternsText).stream().sorted().map(s -> new GlobPatternDescriptor((String)s)).collect(Collectors.toList());
    }

    private static List<String> toStringList(@NotNull String patternsText) {
        if (patternsText == null) {
            ExcludedGlobPatternsPanel.$$$reportNull$$$0(6);
        }
        return StringUtil.isEmpty((String)patternsText) ? Collections.emptyList() : Arrays.stream(patternsText.split(PATTERN_SEPARATOR)).map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/excludedFiles/ExcludedGlobPatternsPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/excludedFiles/ExcludedGlobPatternsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConvertedPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPatternsText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedPatterns";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toStringList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

