/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class PathMacroEditor
extends DialogWrapper {
    private JTextField myNameField;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myValueField;
    private final Validator myValidator;

    public PathMacroEditor(@NlsContexts.DialogTitle String title2, @NlsSafe String macroName, @NlsSafe String value2, Validator validator2) {
        super(true);
        this.$$$setupUI$$$();
        this.setTitle(title2);
        this.myValidator = validator2;
        this.myNameField.setText(macroName);
        DocumentAdapter documentListener2 = new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PathMacroEditor.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/pathMacros/PathMacroEditor$1", "textChanged"));
            }
        };
        this.myNameField.getDocument().addDocumentListener((DocumentListener)documentListener2);
        this.myValueField.setText(value2);
        this.myValueField.addBrowseFolderListener(null, null, null, new FileChooserDescriptor(false, true, true, false, true, false), (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component2) {
                return component2.getText();
            }

            public void setText(JTextField component2, @NotNull String text2) {
                int len;
                if (text2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((len = text2.length()) > 0 && text2.charAt(len - 1) == File.separatorChar) {
                    text2 = text2.substring(0, len - 1);
                }
                component2.setText(text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/pathMacros/PathMacroEditor$2", "setText"));
            }
        });
        this.myValueField.getTextField().getDocument().addDocumentListener((DocumentListener)documentListener2);
        this.init();
        this.updateControls();
    }

    public void setMacroNameEditable(boolean isEditable) {
        this.myNameField.setEditable(isEditable);
    }

    private void updateControls() {
        boolean isNameOK = this.myValidator.checkName(this.myNameField.getText());
        this.getOKAction().setEnabled(isNameOK);
        if (isNameOK) {
            String text2 = this.myValueField.getText().trim();
            this.getOKAction().setEnabled(text2.length() > 0 && !"/".equals(text2.trim()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected String getHelpId() {
        return "preferences.pathVariables";
    }

    protected void doOKAction() {
        if (!this.myValidator.isOK(this.getName(), this.getValue())) {
            return;
        }
        super.doOKAction();
    }

    public String getName() {
        return this.myNameField.getText().trim();
    }

    public String getValue() {
        String path2 = this.myValueField.getText().trim();
        File file2 = new File(path2);
        if (file2.isAbsolute()) {
            try {
                return file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path2;
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myValueField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ApplicationBundle", PathMacroEditor.class).getString("editbox.path.macro.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", PathMacroEditor.class).getString("editbox.path.macro.value"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Validator {
        public boolean checkName(String var1);

        public boolean isOK(String var1, String var2);
    }
}

