/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.pathMacros.PathMacroEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.table.JBTable;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public final class PathMacroTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance(PathMacroTable.class);
    private final PathMacros myPathMacros = PathMacros.getInstance();
    private final MyTableModel myTableModel = new MyTableModel();
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private final List<Couple<String>> myMacros = new ArrayList<Couple<String>>();
    private static final Comparator<Pair<String, String>> MACRO_COMPARATOR = Pair.comparingByFirst();
    private final Collection<String> myUndefinedMacroNames;

    public PathMacroTable() {
        this(null);
    }

    public PathMacroTable(Collection<String> undefinedMacroNames) {
        this.myUndefinedMacroNames = undefinedMacroNames;
        this.setShowGrid(false);
        this.setModel(this.myTableModel);
        TableColumn column2 = this.getColumnModel().getColumn(0);
        column2.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
                Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
                String macroValue = PathMacroTable.this.getMacroValueAt(row2);
                component2.setForeground((Color)(macroValue.length() == 0 ? JBColor.RED : (isSelected ? table.getSelectionForeground() : table.getForeground())));
                return component2;
            }
        });
        this.setSelectionMode(2);
        this.getEmptyText().setText(ApplicationBundle.message((String)"text.no.path.variables", (Object[])new Object[0]));
    }

    public String getMacroValueAt(int row2) {
        return (String)this.getValueAt(row2, 1);
    }

    public void addMacro() {
        String title2 = ApplicationBundle.message((String)"title.add.variable", (Object[])new Object[0]);
        PathMacroEditor macroEditor = new PathMacroEditor(title2, "", "", new AddValidator(title2));
        if (macroEditor.showAndGet()) {
            String name2 = macroEditor.getName();
            this.myMacros.add((Couple<String>)Couple.of((Object)name2, (Object)macroEditor.getValue()));
            this.myMacros.sort(MACRO_COMPARATOR);
            int index2 = this.indexOfMacroWithName(name2);
            LOG.assertTrue(index2 >= 0);
            this.myTableModel.fireTableDataChanged();
            this.setRowSelectionInterval(index2, index2);
        }
    }

    private boolean isValidRow(int selectedRow) {
        return selectedRow >= 0 && selectedRow < this.myMacros.size();
    }

    public void removeSelectedMacros() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        Arrays.sort(selectedRows);
        int originalRow = selectedRows[0];
        for (int i2 = selectedRows.length - 1; i2 >= 0; --i2) {
            int selectedRow = selectedRows[i2];
            if (!this.isValidRow(selectedRow)) continue;
            this.myMacros.remove(selectedRow);
        }
        this.myTableModel.fireTableDataChanged();
        if (originalRow < this.getRowCount()) {
            this.setRowSelectionInterval(originalRow, originalRow);
        } else if (this.getRowCount() > 0) {
            int index2 = this.getRowCount() - 1;
            this.setRowSelectionInterval(index2, index2);
        }
    }

    public void commit() {
        this.myPathMacros.removeAllMacros();
        for (Couple<String> pair : this.myMacros) {
            String value2 = (String)pair.getSecond();
            if (StringUtil.isEmptyOrSpaces((String)value2)) continue;
            String path2 = StringUtil.trimEnd((String)value2.replace(File.separatorChar, '/'), (String)"/");
            this.myPathMacros.setMacro((String)pair.getFirst(), path2);
        }
    }

    public void reset() {
        this.obtainData();
    }

    private boolean hasMacroWithName(String name2) {
        if (PathMacros.getInstance().getSystemMacroNames().contains(name2)) {
            return true;
        }
        for (Couple<String> macro : this.myMacros) {
            if (!name2.equals(macro.getFirst())) continue;
            return true;
        }
        return false;
    }

    private int indexOfMacroWithName(String name2) {
        for (int i2 = 0; i2 < this.myMacros.size(); ++i2) {
            Couple<String> pair = this.myMacros.get(i2);
            if (!name2.equals(pair.getFirst())) continue;
            return i2;
        }
        return -1;
    }

    private void obtainData() {
        this.obtainMacroPairs(this.myMacros);
        this.myTableModel.fireTableDataChanged();
    }

    private void obtainMacroPairs(@NotNull List<Couple<String>> macros) {
        if (macros == null) {
            PathMacroTable.$$$reportNull$$$0(0);
        }
        macros.clear();
        Map macroNames = this.myPathMacros.getUserMacros();
        for (String name2 : macroNames.keySet()) {
            macros.add((Couple<String>)Couple.of((Object)name2, (Object)FileUtilRt.toSystemDependentName((String)((String)macroNames.get(name2)))));
        }
        if (this.myUndefinedMacroNames != null) {
            for (String undefinedMacroName : this.myUndefinedMacroNames) {
                macros.add((Couple<String>)Couple.of((Object)undefinedMacroName, (Object)""));
            }
        }
        macros.sort(MACRO_COMPARATOR);
    }

    public void editMacro() {
        String macroName;
        if (this.getSelectedRowCount() != 1) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        Couple<String> pair = this.myMacros.get(selectedRow);
        String title2 = ApplicationBundle.message((String)"title.edit.variable", (Object[])new Object[0]);
        PathMacroEditor macroEditor = new PathMacroEditor(title2, macroName = (String)pair.getFirst(), (String)pair.getSecond(), new EditValidator());
        if (macroEditor.showAndGet()) {
            this.myMacros.remove(selectedRow);
            this.myMacros.add((Couple<String>)Couple.of((Object)macroEditor.getName(), (Object)macroEditor.getValue()));
            this.myMacros.sort(MACRO_COMPARATOR);
            this.myTableModel.fireTableDataChanged();
        }
    }

    public boolean isModified() {
        ArrayList<Couple<String>> macros = new ArrayList<Couple<String>>();
        this.obtainMacroPairs(macros);
        return !macros.equals(this.myMacros);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macros", "com/intellij/application/options/pathMacros/PathMacroTable", "obtainMacroPairs"));
    }

    private static class EditValidator
    implements PathMacroEditor.Validator {
        private EditValidator() {
        }

        @Override
        public boolean checkName(String name2) {
            if (name2.isEmpty() || PathMacros.getInstance().getSystemMacroNames().contains(name2)) {
                return false;
            }
            return PathMacrosCollector.MACRO_PATTERN.matcher("$" + name2 + "$").matches();
        }

        @Override
        public boolean isOK(String name2, String value2) {
            return this.checkName(name2);
        }
    }

    private final class AddValidator
    implements PathMacroEditor.Validator {
        @NlsContexts.DialogTitle
        private final String myTitle;

        AddValidator(String title2) {
            this.myTitle = title2;
        }

        @Override
        public boolean checkName(String name2) {
            if (name2.length() == 0) {
                return false;
            }
            return PathMacrosCollector.MACRO_PATTERN.matcher("$" + name2 + "$").matches();
        }

        @Override
        public boolean isOK(String name2, String value2) {
            if (name2.length() == 0) {
                return false;
            }
            if (PathMacroTable.this.hasMacroWithName(name2)) {
                Messages.showErrorDialog((Component)((Object)PathMacroTable.this), (String)ApplicationBundle.message((String)"error.variable.already.exists", (Object[])new Object[]{name2}), (String)this.myTitle);
                return false;
            }
            return true;
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PathMacroTable.this.myMacros.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Couple<String> pair = PathMacroTable.this.myMacros.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return pair.getFirst();
                }
                case 1: {
                    return pair.getSecond();
                }
            }
            LOG.error("Wrong indices");
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ApplicationBundle.message((String)"column.name", (Object[])new Object[0]);
                }
                case 1: {
                    return ApplicationBundle.message((String)"column.value", (Object[])new Object[0]);
                }
            }
            return null;
        }
    }
}

