/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.Filterable;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildView
extends CompositeView<ExecutionConsole>
implements BuildProgressListener,
ConsoleView,
DataProvider,
Filterable<ExecutionNode>,
OccurenceNavigator,
ObservableConsoleView {
    public static final String CONSOLE_VIEW_NAME = "consoleView";
    @ApiStatus.Experimental
    public static final DataKey<List<AnAction>> RESTART_ACTIONS = DataKey.create("restart actions");
    @NotNull
    private final Project myProject;
    @NotNull
    private final ViewManager myViewManager;
    private final AtomicBoolean isBuildStartEventProcessed;
    private final List<BuildEvent> myAfterStartEvents;
    @NotNull
    private final DefaultBuildDescriptor myBuildDescriptor;
    @Nullable
    private volatile ExecutionConsole myExecutionConsole;
    private volatile BuildViewSettingsProvider myViewSettingsProvider;

    public BuildView(@NotNull Project project, @NotNull BuildDescriptor buildDescriptor, @NonNls @Nullable String selectionStateKey, @NotNull ViewManager viewManager) {
        if (project == null) {
            BuildView.$$$reportNull$$$0(0);
        }
        if (buildDescriptor == null) {
            BuildView.$$$reportNull$$$0(1);
        }
        if (viewManager == null) {
            BuildView.$$$reportNull$$$0(2);
        }
        this(project, null, buildDescriptor, selectionStateKey, viewManager);
    }

    public BuildView(@NotNull Project project, @Nullable ExecutionConsole executionConsole, @NotNull BuildDescriptor buildDescriptor, @NonNls @Nullable String selectionStateKey, @NotNull ViewManager viewManager) {
        if (project == null) {
            BuildView.$$$reportNull$$$0(3);
        }
        if (buildDescriptor == null) {
            BuildView.$$$reportNull$$$0(4);
        }
        if (viewManager == null) {
            BuildView.$$$reportNull$$$0(5);
        }
        super(selectionStateKey);
        this.isBuildStartEventProcessed = new AtomicBoolean();
        this.myAfterStartEvents = ContainerUtil.createConcurrentList();
        this.myProject = project;
        this.myViewManager = viewManager;
        this.myExecutionConsole = executionConsole;
        this.myBuildDescriptor = buildDescriptor instanceof DefaultBuildDescriptor ? (DefaultBuildDescriptor)buildDescriptor : new DefaultBuildDescriptor(buildDescriptor);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(6);
        }
        if (event == null) {
            BuildView.$$$reportNull$$$0(7);
        }
        if (event instanceof StartBuildEvent) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                this.onStartBuild(buildId, (StartBuildEvent)event);
                for (BuildEvent buildEvent : this.myAfterStartEvents) {
                    this.processEvent(buildId, buildEvent);
                }
                this.myAfterStartEvents.clear();
                this.isBuildStartEventProcessed.set(true);
            });
            return;
        }
        if (!this.isBuildStartEventProcessed.get()) {
            this.myAfterStartEvents.add(event);
        } else {
            this.processEvent(buildId, event);
        }
    }

    private void processEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(8);
        }
        if (event == null) {
            BuildView.$$$reportNull$$$0(9);
        }
        if (event instanceof OutputBuildEvent && (event.getParentId() == null || event.getParentId() == this.myBuildDescriptor.getId())) {
            ExecutionConsole consoleView = this.getConsoleView();
            if (consoleView instanceof BuildProgressListener) {
                ((BuildProgressListener)consoleView).onEvent(buildId, event);
            }
        } else {
            BuildTreeConsoleView eventView = this.getEventView();
            if (eventView != null) {
                EdtExecutorService.getInstance().execute(() -> eventView.onEvent(buildId, event));
            }
        }
    }

    private void onStartBuild(@NotNull Object buildId, @NotNull StartBuildEvent startBuildEvent) {
        ExecutionConsole executionConsole;
        Application application;
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(10);
        }
        if (startBuildEvent == null) {
            BuildView.$$$reportNull$$$0(11);
        }
        if ((application = ApplicationManager.getApplication()).isHeadlessEnvironment() && !application.isUnitTestMode()) {
            return;
        }
        if (startBuildEvent instanceof StartBuildEventImpl) {
            this.myViewSettingsProvider = ((StartBuildEventImpl)startBuildEvent).getBuildViewSettingsProvider();
        }
        if (this.myViewSettingsProvider == null) {
            this.myViewSettingsProvider = () -> false;
        }
        if (this.myExecutionConsole == null) {
            Supplier<? extends RunContentDescriptor> descriptorSupplier = this.myBuildDescriptor.getContentDescriptorSupplier();
            RunContentDescriptor runContentDescriptor = descriptorSupplier != null ? descriptorSupplier.get() : null;
            BuildTextConsoleView buildTextConsoleView = this.myExecutionConsole = runContentDescriptor != null && runContentDescriptor.getExecutionConsole() != null && runContentDescriptor.getExecutionConsole() != this ? runContentDescriptor.getExecutionConsole() : new BuildTextConsoleView(this.myProject, false, this.myBuildDescriptor.getExecutionFilters());
            if (runContentDescriptor != null && Disposer.findRegisteredObject((Disposable)runContentDescriptor, (Disposable)this) == null) {
                Disposer.register((Disposable)this, (Disposable)runContentDescriptor);
            }
        }
        if ((executionConsole = this.myExecutionConsole) != null) {
            executionConsole.getComponent();
            if (this.myViewSettingsProvider.isExecutionViewHidden()) {
                this.addViewAndShowIfNeeded(executionConsole, CONSOLE_VIEW_NAME, this.myViewManager.isConsoleEnabledByDefault());
            }
        }
        BuildTreeConsoleView eventView = null;
        if (!this.myViewSettingsProvider.isExecutionViewHidden() && (eventView = this.getEventView()) == null) {
            String eventViewName = BuildTreeConsoleView.class.getName();
            eventView = new BuildTreeConsoleView(this.myProject, this.myBuildDescriptor, this.myExecutionConsole, this.myViewSettingsProvider);
            this.addView(eventView, eventViewName);
            this.showView(eventViewName);
        }
        BuildProcessHandler processHandler2 = this.myBuildDescriptor.getProcessHandler();
        if (this.myExecutionConsole instanceof ConsoleView) {
            ConsoleView consoleView = (ConsoleView)this.myExecutionConsole;
            if (consoleView != null && !(consoleView instanceof BuildTextConsoleView)) {
                this.myBuildDescriptor.getExecutionFilters().forEach(arg_0 -> ((ConsoleView)consoleView).addMessageFilter(arg_0));
            }
            if (processHandler2 != null) {
                assert (consoleView != null);
                consoleView.attachToProcess((ProcessHandler)processHandler2);
                Consumer<? super ConsoleView> attachedConsoleConsumer = this.myBuildDescriptor.getAttachedConsoleConsumer();
                if (attachedConsoleConsumer != null) {
                    attachedConsoleConsumer.consume((Object)consoleView);
                }
            }
        }
        if (processHandler2 != null && !processHandler2.isStartNotified()) {
            processHandler2.startNotify();
        }
        if (eventView != null) {
            eventView.onEvent(buildId, (BuildEvent)startBuildEvent);
        }
    }

    @Nullable
    @ApiStatus.Internal
    public ExecutionConsole getConsoleView() {
        return this.myExecutionConsole;
    }

    @Nullable
    @ApiStatus.Internal
    BuildTreeConsoleView getEventView() {
        return this.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        ExecutionConsole console2;
        if (listener2 == null) {
            BuildView.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            BuildView.$$$reportNull$$$0(13);
        }
        if ((console2 = this.getConsoleView()) instanceof ObservableConsoleView) {
            ((ObservableConsoleView)console2).addChangeListener(listener2, parent);
        }
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildView.$$$reportNull$$$0(14);
        }
        if (contentType == null) {
            BuildView.$$$reportNull$$$0(15);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.print(text2, contentType)));
    }

    private void delegateToConsoleView(Consumer<? super ConsoleView> viewConsumer) {
        ExecutionConsole console2 = this.getConsoleView();
        if (console2 instanceof ConsoleView) {
            viewConsumer.consume((Object)((ConsoleView)console2));
        }
    }

    @Nullable
    private <R> R getConsoleViewValue(Function<? super ConsoleView, ? extends R> viewConsumer) {
        ExecutionConsole console2 = this.getConsoleView();
        if (console2 instanceof ConsoleView) {
            return viewConsumer.apply((ConsoleView)((ConsoleView)console2));
        }
        return null;
    }

    public void clear() {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)ConsoleView::clear));
    }

    public void scrollTo(int offset) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.scrollTo(offset)));
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            BuildView.$$$reportNull$$$0(16);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.attachToProcess(processHandler2)));
    }

    public boolean isOutputPaused() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::isOutputPaused);
        return result2 != null && result2 != false;
    }

    public void setOutputPaused(boolean value2) {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.setOutputPaused(value2)));
    }

    public boolean hasDeferredOutput() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::hasDeferredOutput);
        return result2 != null && result2 != false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildView.$$$reportNull$$$0(17);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.performWhenNoDeferredOutput(runnable2)));
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildView.$$$reportNull$$$0(18);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.setHelpId(helpId)));
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildView.$$$reportNull$$$0(19);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.addMessageFilter(filter)));
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info2) {
        if (hyperlinkText == null) {
            BuildView.$$$reportNull$$$0(20);
        }
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)view -> view.printHyperlink(hyperlinkText, info2)));
    }

    public int getContentSize() {
        Integer result2 = this.getConsoleViewValue(ConsoleView::getContentSize);
        return result2 == null ? 0 : result2;
    }

    public boolean canPause() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::canPause);
        return result2 != null && result2 != false;
    }

    @Override
    public AnAction @NotNull [] createConsoleActions() {
        ExecutionConsole consoleView;
        if (!this.myViewManager.isBuildContentView()) {
            if (AnAction.EMPTY_ARRAY == null) {
                BuildView.$$$reportNull$$$0(21);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
        StopProcessAction stopAction = null;
        if (this.myBuildDescriptor.getProcessHandler() != null) {
            stopAction = new StopProcessAction(IdeBundle.messagePointer((String)"action.DumbAware.BuildView.text.stop", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.DumbAware.CopyrightProfilesPanel.description.stop", (Object[])new Object[0]), (ProcessHandler)this.myBuildDescriptor.getProcessHandler());
            ActionUtil.copyFrom((AnAction)stopAction, (String)"Stop");
            stopAction.registerCustomShortcutSet(stopAction.getShortcutSet(), this);
        }
        if ((consoleView = this.getConsoleView()) instanceof ConsoleView) {
            consoleView.getComponent();
            if (stopAction == null) {
                Object[] consoleActions = ((ConsoleView)consoleView).createConsoleActions();
                stopAction = (AnAction)ContainerUtil.find((Object[])consoleActions, StopAction.class::isInstance);
            }
        }
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        for (AnAction anAction2 : this.myBuildDescriptor.getRestartActions()) {
            rerunActionGroup.add(anAction2);
        }
        if (stopAction != null) {
            rerunActionGroup.add((AnAction)stopAction);
        }
        actionGroup2.add((AnAction)rerunActionGroup);
        DefaultActionGroup otherActionGroup = new DefaultActionGroup();
        List<AnAction> otherActions = this.myBuildDescriptor.getActions();
        if (!otherActions.isEmpty()) {
            otherActionGroup.addSeparator();
            for (AnAction anAction3 : otherActions) {
                otherActionGroup.add(anAction3);
            }
            otherActionGroup.addSeparator();
        }
        AnAction[] anActionArray = new AnAction[]{actionGroup2, otherActionGroup};
        if (anActionArray == null) {
            BuildView.$$$reportNull$$$0(22);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.delegateToConsoleView((Consumer<? super ConsoleView>)((Consumer)ConsoleView::allowHeavyFilters));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildView.$$$reportNull$$$0(23);
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this.getConsoleView();
        }
        Object data2 = super.getData(dataId);
        if (data2 != null) {
            return data2;
        }
        if (LangDataKeys.RUN_PROFILE.is(dataId)) {
            ExecutionEnvironment environment2 = this.myBuildDescriptor.getExecutionEnvironment();
            return environment2 == null ? null : environment2.getRunProfile();
        }
        if (ExecutionDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return this.myBuildDescriptor.getExecutionEnvironment();
        }
        if (RESTART_ACTIONS.is(dataId)) {
            return this.myBuildDescriptor.getRestartActions();
        }
        return null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.getEventView() != null;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        BuildTreeConsoleView eventView = this.getEventView();
        Predicate<ExecutionNode> predicate2 = eventView == null ? executionNode -> true : eventView.getFilter();
        if (predicate2 == null) {
            BuildView.$$$reportNull$$$0(24);
        }
        return predicate2;
    }

    @Override
    public void addFilter(@NotNull Predicate<? super ExecutionNode> filter) {
        BuildTreeConsoleView eventView;
        if (filter == null) {
            BuildView.$$$reportNull$$$0(25);
        }
        if ((eventView = this.getEventView()) != null) {
            eventView.addFilter(filter);
        }
    }

    @Override
    public void removeFilter(@NotNull Predicate<? super ExecutionNode> filter) {
        BuildTreeConsoleView eventView;
        if (filter == null) {
            BuildView.$$$reportNull$$$0(26);
        }
        if ((eventView = this.getEventView()) != null) {
            eventView.removeFilter(filter);
        }
    }

    @Override
    public boolean contains(@NotNull Predicate<? super ExecutionNode> filter) {
        BuildTreeConsoleView eventView;
        if (filter == null) {
            BuildView.$$$reportNull$$$0(27);
        }
        return (eventView = this.getEventView()) != null && eventView.contains(filter);
    }

    @NotNull
    private OccurenceNavigator getOccurenceNavigator() {
        BuildTreeConsoleView eventView = this.getEventView();
        if (eventView != null) {
            BuildTreeConsoleView buildTreeConsoleView = eventView;
            if (buildTreeConsoleView == null) {
                BuildView.$$$reportNull$$$0(28);
            }
            return buildTreeConsoleView;
        }
        ExecutionConsole executionConsole = this.getConsoleView();
        if (executionConsole instanceof OccurenceNavigator) {
            OccurenceNavigator occurenceNavigator = (OccurenceNavigator)executionConsole;
            if (occurenceNavigator == null) {
                BuildView.$$$reportNull$$$0(29);
            }
            return occurenceNavigator;
        }
        OccurenceNavigator occurenceNavigator = EMPTY;
        if (occurenceNavigator == null) {
            BuildView.$$$reportNull$$$0(30);
        }
        return occurenceNavigator;
    }

    public boolean hasNextOccurence() {
        return this.getOccurenceNavigator().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.getOccurenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.getOccurenceNavigator().getNextOccurenceActionName();
        if (string == null) {
            BuildView.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.getOccurenceNavigator().getPreviousOccurenceActionName();
        if (string == null) {
            BuildView.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewManager";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBuildEvent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildView";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurenceNavigator";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onStartBuild";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

