/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCodeInsightAction
extends CodeInsightAction {
    private final boolean myLookForInjectedEditor;

    protected BaseCodeInsightAction() {
        this(true);
    }

    protected BaseCodeInsightAction(boolean lookForInjectedEditor) {
        this.myLookForInjectedEditor = lookForInjectedEditor;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project, boolean forUpdate) {
        if (dataContext == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(1);
        }
        Editor editor2 = this.getBaseEditor(dataContext, project);
        if (!this.myLookForInjectedEditor) {
            return editor2;
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor2, !forUpdate);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor2) {
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(2);
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor2, true);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor2, boolean commit2) {
        PsiDocumentManager documentManager;
        PsiFile psiFile;
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(3);
        }
        Editor injectedEditor = editor2;
        if (editor2 != null && (psiFile = (documentManager = PsiDocumentManager.getInstance((Project)project)).getCachedPsiFile(editor2.getDocument())) != null) {
            if (commit2) {
                documentManager.commitAllDocuments();
            }
            injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor2, psiFile);
        }
        return injectedEditor;
    }

    @Nullable
    protected Editor getBaseEditor(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(5);
        }
        return super.getEditor(dataContext, project, true);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseCodeInsightAction.$$$reportNull$$$0(6);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation2.setEnabled(false);
            return;
        }
        LookupEx activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null) {
            presentation2.setEnabled(this.isValidForLookup());
        } else {
            super.update(event);
        }
    }

    protected boolean isValidForLookup() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/BaseCodeInsightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectedEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

