/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.formatting.KeptLineFeedsCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance(ReformatCodeProcessor.class);
    private static final Key<Trinity<Long, Date, List<TextRange>>> SECOND_FORMAT_KEY = Key.create((String)"second.format");
    private static final String SECOND_REFORMAT_CONFIRMED = "second.reformat.confirmed";
    private final List<TextRange> myRanges;
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project, boolean processChangedTextOnly) {
        super(project, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(0);
        }
        if (selectionModel == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), false);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(2);
        }
        super(processor2, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText());
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText());
        this.myRanges = new ArrayList<TextRange>();
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, Module module, boolean processChangedTextOnly) {
        super(project, module, ReformatCodeProcessor.getCommandName(), ReformatCodeProcessor.getProgressText(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project, directory, includeSubdirs, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile file2, @Nullable TextRange range2, boolean processChangedTextOnly) {
        super(project, file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
        if (range2 != null) {
            this.myRanges.add(range2);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, TextRange[] ranges) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), false);
        this.myRanges = new ArrayList<TextRange>();
        for (TextRange range2 : ranges) {
            if (range2 == null) continue;
            this.myRanges.add(range2);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(4);
        }
        super(file2.getProject(), file2, ReformatCodeProcessor.getProgressText(), ReformatCodeProcessor.getCommandName(), processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project, files2, ReformatCodeProcessor.getCommandName(), postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, @NlsContexts.Command String commandName2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project, files2, ReformatCodeProcessor.getProgressText(), commandName2, postRunnable, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public void setDoNotKeepLineBreaks(PsiFile file2) {
        file2.putUserData(SECOND_FORMAT_KEY, (Object)Trinity.create((Object)file2.getModificationStamp(), (Object)new Date(), this.myRanges));
    }

    @Override
    protected boolean needsReadActionToPrepareTask() {
        return false;
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        PsiFile fileToProcess;
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(5);
        }
        if ((fileToProcess = (PsiFile)ReadAction.compute(() -> ReformatCodeProcessor.ensureValid(file2))) == null) {
            return new FutureTask<Boolean>(() -> false);
        }
        boolean doNotKeepLineBreaks = this.confirmSecondReformat(file2);
        return new FutureTask<Boolean>(() -> {
            Ref result2 = new Ref();
            CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.getSettings((PsiFile)fileToProcess), settings -> {
                if (doNotKeepLineBreaks) {
                    settings.getCommonSettings((Language)fileToProcess.getLanguage()).KEEP_LINE_BREAKS = false;
                }
                result2.set((Object)this.doReformat(file2, processChangedTextOnly));
            });
            return (Boolean)result2.get();
        });
    }

    private boolean isSecondReformatDisabled() {
        return !CodeStyle.getSettings((Project)this.myProject).ENABLE_SECOND_REFORMAT && PropertiesComponent.getInstance().isValueSet(SECOND_REFORMAT_CONFIRMED);
    }

    private boolean confirmSecondReformat(@NotNull PsiFile file2) {
        boolean doNotKeepLineBreaks;
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(6);
        }
        if (!(doNotKeepLineBreaks = this.isDoNotKeepLineBreaks(file2)) || this.isSecondReformatDisabled()) {
            return false;
        }
        final CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject);
        if (!settings.ENABLE_SECOND_REFORMAT) {
            Ref ref = Ref.create((Object)true);
            ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)CodeInsightBundle.message((String)"second.reformat", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"do.you.want.to.remove.custom.line.breaks", (Object[])new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (isSelected) {
                        settings.ENABLE_SECOND_REFORMAT = exitCode == 0;
                        PropertiesComponent.getInstance().setValue(ReformatCodeProcessor.SECOND_REFORMAT_CONFIRMED, true);
                    }
                }
            })).ask(this.myProject)));
            return (Boolean)ref.get();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReformat(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        boolean bl;
        PsiFile fileToProcess;
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(7);
        }
        if ((fileToProcess = ReformatCodeProcessor.ensureValid(file2)) == null) {
            LOG.warn("Invalid file " + file2.getName() + ", skipping reformat");
            return false;
        }
        FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
        try {
            CharSequence before;
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(fileToProcess);
            LayoutCodeInfoCollector infoCollector = this.getInfoCollector();
            LOG.assertTrue(infoCollector == null || document != null);
            CharSequence charSequence = before = document == null ? null : document.getImmutableCharSequence();
            if (!this.isSecondReformatDisabled()) {
                KeptLineFeedsCollector.setup(fileToProcess);
            }
            try {
                EditorScrollingPositionKeeper.perform(document, true, () -> SlowOperations.allowSlowOperations(() -> {
                    if (processChangedTextOnly) {
                        ChangedRangesInfo info2 = VcsFacade.getInstance().getChangedRangesInfo(fileToProcess);
                        if (info2 != null) {
                            ReformatCodeProcessor.assertFileIsValid(fileToProcess);
                            CodeStyleManager.getInstance((Project)this.myProject).reformatTextWithContext(fileToProcess, info2);
                        }
                    } else {
                        Collection<TextRange> ranges = this.getRangesToFormat(fileToProcess);
                        CodeStyleManager.getInstance((Project)this.myProject).reformatText(fileToProcess, ranges);
                    }
                }));
            }
            catch (ProcessCanceledException pce) {
                if (before != null) {
                    document.setText(before);
                }
                if (infoCollector != null) {
                    infoCollector.setReformatCodeNotification(CodeInsightBundle.message((String)"hint.text.formatting.canceled", (Object[])new Object[0]));
                }
                boolean bl2 = false;
                this.myRanges.clear();
                return bl2;
            }
            finally {
                List<Segment> segments = KeptLineFeedsCollector.getLineFeedsAndCleanup();
                if (!segments.isEmpty() && infoCollector != null) {
                    infoCollector.setSecondFormatNotification(CodeInsightBundle.message((String)"hint.text.custom.line.breaks.are.preserved", (Object[])new Object[0]));
                    this.setDoNotKeepLineBreaks(fileToProcess);
                } else {
                    fileToProcess.putUserData(SECOND_FORMAT_KEY, null);
                }
            }
            if (infoCollector != null) {
                this.prepareUserNotificationMessage(document, before);
            }
            bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.myRanges.clear();
        }
        return bl;
    }

    private boolean isDoNotKeepLineBreaks(PsiFile file2) {
        Trinity previous = (Trinity)SECOND_FORMAT_KEY.get((UserDataHolder)file2);
        return previous != null && ((Long)previous.first).longValue() == file2.getModificationStamp() && new Date().getTime() - ((Date)previous.second).getTime() < 5000L && this.myRanges.equals(previous.third);
    }

    @Nullable
    private static PsiFile ensureValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(8);
        }
        if (file2.isValid()) {
            return file2;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (!virtualFile2.isValid()) {
            return null;
        }
        FileViewProvider provider2 = file2.getManager().findViewProvider(virtualFile2);
        if (provider2 == null) {
            return null;
        }
        Language language2 = file2.getLanguage();
        return provider2.hasLanguage(language2) ? provider2.getPsi(language2) : provider2.getPsi(provider2.getBaseLanguage());
    }

    private static void assertFileIsValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(9);
        }
        if (!file2.isValid()) {
            LOG.error("Invalid Psi file, name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName() + " , " + PsiInvalidElementAccessException.findOutInvalidationReason((PsiElement)file2));
        }
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        if (document == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(10);
        }
        if (before == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = VcsFacade.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message2 = CodeInsightBundle.message((String)"hint.text.formatted.line", (Object[])new Object[]{number});
            this.getInfoCollector().setReformatCodeNotification(message2);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(PsiFile file2) {
        if (this.mySelectionModel != null) {
            List<TextRange> list2 = ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
            if (list2 == null) {
                ReformatCodeProcessor.$$$reportNull$$$0(12);
            }
            return list2;
        }
        ArrayList arrayList = !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
        if (arrayList == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NlsContexts.ProgressText
    private static String getProgressText() {
        return CodeStyleBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    }

    @NlsContexts.Command
    public static String getCommandName() {
        return CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/ReformatCodeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/ReformatCodeProcessor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "confirmSecondReformat";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doReformat";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertFileIsValid";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareUserNotificationMessage";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

