/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions.onSave;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.onSave.FormatOnSaveOptionsBase;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatOnSaveActionInfoBase<Options extends FormatOnSaveOptionsBase<?>>
extends ActionOnSaveInfo {
    @NotNull
    private final @NlsContexts.Checkbox String myActionOnSaveName;
    @NotNull
    private final Options myCurrentUiState;

    public FormatOnSaveActionInfoBase(@NotNull ActionOnSaveContext context2, @NotNull @NlsContexts.Checkbox String actionOnSaveName, @NotNull Key<Options> currentUiStateKey) {
        if (context2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(0);
        }
        if (actionOnSaveName == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(1);
        }
        if (currentUiStateKey == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(2);
        }
        super(context2);
        this.myActionOnSaveName = actionOnSaveName;
        Object options2 = (FormatOnSaveOptionsBase)this.getContext().getUserData(currentUiStateKey);
        if (options2 == null) {
            Options storedState = this.getOptionsFromStoredState();
            options2 = ((FormatOnSaveOptionsBase)storedState).clone();
            this.getContext().putUserData(currentUiStateKey, options2);
        }
        this.myCurrentUiState = options2;
    }

    @NotNull
    protected abstract Options getOptionsFromStoredState();

    @NotNull
    protected Options getCurrentUiState() {
        Options Options2 = this.myCurrentUiState;
        if (Options2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(3);
        }
        return Options2;
    }

    @Override
    @NotNull
    @NlsContexts.Checkbox
    public final String getActionOnSaveName() {
        String string = this.myActionOnSaveName;
        if (string == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public final boolean isActionOnSaveEnabled() {
        return ((FormatOnSaveOptionsBase)this.myCurrentUiState).isRunOnSaveEnabled();
    }

    @Override
    public final void setActionOnSaveEnabled(boolean enabled) {
        ((FormatOnSaveOptionsBase)this.myCurrentUiState).setRunOnSaveEnabled(enabled);
    }

    @Override
    @Nullable
    public ActionOnSaveComment getComment() {
        if (((FormatOnSaveOptionsBase)this.myCurrentUiState).isRunOnSaveEnabled() && !((FormatOnSaveOptionsBase)this.myCurrentUiState).isAllFileTypesSelected() && ((FormatOnSaveOptionsBase)this.myCurrentUiState).getSelectedFileTypes().isEmpty()) {
            return ActionOnSaveComment.warning(CodeInsightBundle.message((String)"actions.on.save.page.warning.no.file.types.selected", (Object[])new Object[0]));
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends DropDownLink<?>> getDropDownLinks() {
        List<DropDownLink<String>> list2 = List.of(this.createFileTypesDropDownLink());
        if (list2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    protected DropDownLink<String> createFileTypesDropDownLink() {
        Function1<DropDownLink<String>, JBPopup> popupBuilder = new Function1<DropDownLink<String>, JBPopup>(){

            public JBPopup invoke(DropDownLink<String> link2) {
                return FormatOnSaveActionInfoBase.this.createFileTypesPopup(link2);
            }
        };
        return new DropDownLink((Object)this.getFileTypesLinkText(), (Function1)popupBuilder);
    }

    @NotNull
    @NlsContexts.LinkLabel
    private String getFileTypesLinkText() {
        String presentableFileType;
        if (((FormatOnSaveOptionsBase)this.myCurrentUiState).isAllFileTypesSelected()) {
            String string = CodeInsightBundle.message((String)"actions.on.save.page.label.all.file.types", (Object[])new Object[0]);
            if (string == null) {
                FormatOnSaveActionInfoBase.$$$reportNull$$$0(6);
            }
            return string;
        }
        Set<String> fileTypes = ((FormatOnSaveOptionsBase)this.myCurrentUiState).getSelectedFileTypes();
        if (fileTypes.isEmpty()) {
            String string = CodeInsightBundle.message((String)"actions.on.save.page.label.select.file.types", (Object[])new Object[0]);
            if (string == null) {
                FormatOnSaveActionInfoBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        String fileTypeName = fileTypes.iterator().next();
        FileType fileType = FileTypeRegistry.getInstance().findFileTypeByName(fileTypeName);
        String string = presentableFileType = fileType != null ? FormatOnSaveActionInfoBase.getFileTypePresentableName(fileType) : fileTypeName;
        if (fileTypes.size() == 1) {
            String string2 = CodeInsightBundle.message((String)"actions.on.save.page.label.one.file.type.selected", (Object[])new Object[]{presentableFileType});
            if (string2 == null) {
                FormatOnSaveActionInfoBase.$$$reportNull$$$0(8);
            }
            return string2;
        }
        String string3 = CodeInsightBundle.message((String)"actions.on.save.page.label.many.file.types.selected", (Object[])new Object[]{presentableFileType, fileTypes.size() - 1});
        if (string3 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(9);
        }
        return string3;
    }

    @NotNull
    private JBPopup createFileTypesPopup(final @NotNull DropDownLink<String> link2) {
        if (link2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(10);
        }
        final CheckedTreeNode root2 = new CheckedTreeNode((Object)CodeInsightBundle.message((String)"actions.on.save.page.label.all.file.types", (Object[])new Object[0]));
        TreeSet<FileType> result2 = new TreeSet<FileType>(Comparator.comparing(FormatOnSaveActionInfoBase::getFileTypePresentableName));
        this.addApplicableFileTypes(result2);
        for (FileType fileType : result2) {
            root2.add((MutableTreeNode)new CheckedTreeNode((Object)fileType));
        }
        CheckboxTree tree = this.createFileTypesCheckboxTree(root2);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)new JBScrollPane((Component)((Object)tree)), (JComponent)((Object)tree)).setRequestFocus(true).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                FormatOnSaveActionInfoBase.this.onFileTypePopupClosed((DropDownLink<String>)link2, root2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/actions/onSave/FormatOnSaveActionInfoBase$2", "onClosed"));
            }
        }).createPopup();
        if (jBPopup == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(11);
        }
        return jBPopup;
    }

    protected abstract void addApplicableFileTypes(@NotNull Collection<FileType> var1);

    @NotNull
    private CheckboxTree createFileTypesCheckboxTree(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(12);
        }
        CheckboxTree tree = new CheckboxTree(FormatOnSaveActionInfoBase.createFileTypesRenderer(), root2){

            @Override
            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)path2 -> {
                    CheckedTreeNode node2 = (CheckedTreeNode)path2.getLastPathComponent();
                    Object userObject = node2.getUserObject();
                    if (userObject instanceof FileType) {
                        return FormatOnSaveActionInfoBase.getFileTypePresentableName((FileType)userObject);
                    }
                    return userObject.toString();
                }));
            }
        };
        tree.setRootVisible(true);
        tree.setSelectionRow(0);
        this.resetTree(root2);
        CheckboxTree checkboxTree = tree;
        if (checkboxTree == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(13);
        }
        return checkboxTree;
    }

    private void resetTree(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(14);
        }
        if (((FormatOnSaveOptionsBase)this.myCurrentUiState).isAllFileTypesSelected()) {
            root2.setChecked(true);
            return;
        }
        root2.setChecked(false);
        Enumeration fileTypesEnum = root2.children();
        while (fileTypesEnum.hasMoreElements()) {
            CheckedTreeNode node2 = (CheckedTreeNode)fileTypesEnum.nextElement();
            FileType fileType = (FileType)node2.getUserObject();
            node2.setChecked(((FormatOnSaveOptionsBase)this.myCurrentUiState).isFileTypeSelected(fileType));
        }
    }

    private void onFileTypePopupClosed(@NotNull DropDownLink<String> link2, @NotNull CheckedTreeNode root2) {
        if (link2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(15);
        }
        if (root2 == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(16);
        }
        Options options2 = this.myCurrentUiState;
        if (root2.isChecked()) {
            ((FormatOnSaveOptionsBase)options2).setRunForAllFileTypes();
        } else {
            ArrayList<FileType> fileTypes = new ArrayList<FileType>();
            Enumeration fileTypesEnum = root2.children();
            while (fileTypesEnum.hasMoreElements()) {
                CheckedTreeNode node2 = (CheckedTreeNode)fileTypesEnum.nextElement();
                if (!node2.isChecked()) continue;
                fileTypes.add((FileType)node2.getUserObject());
            }
            ((FormatOnSaveOptionsBase)options2).setRunForSelectedFileTypes(fileTypes);
        }
        link2.setText(this.getFileTypesLinkText());
    }

    @NotNull
    private static CheckboxTree.CheckboxTreeCellRenderer createFileTypesRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree t, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean focus) {
                if (!(value2 instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node2 = (CheckedTreeNode)value2;
                Object userObject = node2.getUserObject();
                if (userObject instanceof String) {
                    this.getTextRenderer().append((String)userObject);
                }
                if (userObject instanceof FileType) {
                    this.getTextRenderer().setIcon(((FileType)userObject).getIcon());
                    this.getTextRenderer().append(FormatOnSaveActionInfoBase.getFileTypePresentableName((FileType)userObject));
                }
            }
        };
    }

    @NotNull
    @Nls
    protected static String getFileTypePresentableName(@NotNull FileType fileType) {
        if (fileType == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(17);
        }
        if (fileType instanceof LanguageFileType) {
            String string = ((LanguageFileType)fileType).getLanguage().getDisplayName();
            if (string == null) {
                FormatOnSaveActionInfoBase.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = fileType.getDescription();
        if (string == null) {
            FormatOnSaveActionInfoBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    protected final boolean isModified() {
        return !((FormatOnSaveOptionsBase)this.getOptionsFromStoredState()).equals(this.myCurrentUiState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOnSaveName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentUiStateKey";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveActionInfoBase";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveActionInfoBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentUiState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionOnSaveName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropDownLinks";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesLinkText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTypesPopup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTypesCheckboxTree";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypePresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileTypesPopup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFileTypesCheckboxTree";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resetTree";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onFileTypePopupClosed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypePresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

