/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions.onSave;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FormatOnSaveOptionsBase<S extends StateBase>
implements PersistentStateComponent<S>,
Cloneable {
    protected static final ExtensionPointName<DefaultsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.formatOnSaveOptions.defaultsProvider");
    @NotNull
    private S myState;

    public FormatOnSaveOptionsBase(@NotNull S state) {
        if (state == null) {
            FormatOnSaveOptionsBase.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    @NotNull
    public final S getState() {
        S s = this.myState;
        if (s == null) {
            FormatOnSaveOptionsBase.$$$reportNull$$$0(1);
        }
        return s;
    }

    public final void loadState(@NotNull S state) {
        if (state == null) {
            FormatOnSaveOptionsBase.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    public final void noStateLoaded() {
        this.convertOldProperties();
    }

    protected void convertOldProperties() {
    }

    public boolean isRunOnSaveEnabled() {
        return ((StateBase)this.myState).myRunOnSave;
    }

    void setRunOnSaveEnabled(boolean enabled) {
        ((StateBase)this.myState).myRunOnSave = enabled;
    }

    public boolean isAllFileTypesSelected() {
        return ((StateBase)this.myState).myAllFileTypesSelected;
    }

    void setRunForAllFileTypes() {
        ((StateBase)this.myState).myAllFileTypesSelected = true;
        ((StateBase)this.myState).mySelectedFileTypes.clear();
    }

    void setRunForSelectedFileTypes(@NotNull @NotNull Collection<@NotNull FileType> fileTypes) {
        if (fileTypes == null) {
            FormatOnSaveOptionsBase.$$$reportNull$$$0(3);
        }
        ((StateBase)this.myState).myAllFileTypesSelected = false;
        ((StateBase)this.myState).mySelectedFileTypes.clear();
        for (FileType fileType : fileTypes) {
            ((StateBase)this.myState).mySelectedFileTypes.add(fileType.getName());
        }
    }

    public boolean isFileTypeSelected(@NotNull FileType fileType) {
        if (fileType == null) {
            FormatOnSaveOptionsBase.$$$reportNull$$$0(4);
        }
        return ((StateBase)this.myState).myAllFileTypesSelected || ((StateBase)this.myState).mySelectedFileTypes.contains(fileType.getName());
    }

    Set<String> getSelectedFileTypes() {
        return new TreeSet<String>(((StateBase)this.myState).mySelectedFileTypes);
    }

    public FormatOnSaveOptionsBase<S> clone() {
        try {
            FormatOnSaveOptionsBase clone = (FormatOnSaveOptionsBase)super.clone();
            clone.myState = ((StateBase)this.myState).clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormatOnSaveOptionsBase base = (FormatOnSaveOptionsBase)o;
        return ((StateBase)this.myState).equals(base.myState);
    }

    public int hashCode() {
        return Objects.hash(this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveOptionsBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveOptionsBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRunForSelectedFileTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileTypeSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class StateBase
    implements Cloneable {
        public boolean myRunOnSave;
        public boolean myAllFileTypesSelected;
        @NotNull
        public @NotNull SortedSet<@NotNull String> mySelectedFileTypes;

        StateBase(@NotNull Function<DefaultsProvider, Collection<FileType>> enabledByDefaultProvider) {
            if (enabledByDefaultProvider == null) {
                StateBase.$$$reportNull$$$0(0);
            }
            this.mySelectedFileTypes = new TreeSet<String>();
            for (DefaultsProvider provider2 : EP_NAME.getExtensionList()) {
                Collection<@NotNull FileType> fileTypes = enabledByDefaultProvider.apply(provider2);
                this.mySelectedFileTypes.addAll(ContainerUtil.map(fileTypes, FileType::getName));
            }
            if (this.mySelectedFileTypes.isEmpty()) {
                this.myRunOnSave = false;
                this.myAllFileTypesSelected = true;
            } else {
                this.myRunOnSave = true;
                this.myAllFileTypesSelected = false;
            }
        }

        public StateBase clone() {
            try {
                StateBase clone = (StateBase)super.clone();
                clone.mySelectedFileTypes = new TreeSet<String>(this.mySelectedFileTypes);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateBase state = (StateBase)o;
            return this.myRunOnSave == state.myRunOnSave && this.myAllFileTypesSelected == state.myAllFileTypesSelected && this.mySelectedFileTypes.equals(state.mySelectedFileTypes);
        }

        public int hashCode() {
            return Objects.hash(this.myRunOnSave, this.myAllFileTypesSelected, this.mySelectedFileTypes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enabledByDefaultProvider", "com/intellij/codeInsight/actions/onSave/FormatOnSaveOptionsBase$StateBase", "<init>"));
        }
    }

    public static interface DefaultsProvider {
        @NotNull
        default public @NotNull Collection<@NotNull FileType> getFileTypesFormattedOnSaveByDefault() {
            List<FileType> list2 = Collections.emptyList();
            if (list2 == null) {
                DefaultsProvider.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @NotNull
        default public @NotNull Collection<@NotNull FileType> getFileTypesWithOptimizeImportsOnSaveByDefault() {
            List<FileType> list2 = Collections.emptyList();
            if (list2 == null) {
                DefaultsProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/actions/onSave/FormatOnSaveOptionsBase$DefaultsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypesFormattedOnSaveByDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypesWithOptimizeImportsOnSaveByDefault";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

