/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/completion/ml/VcsFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "intellij.platform.vcs.impl"})
public final class VcsFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "vcs";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element2, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map features;
        block4: {
            PsiElement psi;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
            boolean bl = false;
            features = new LinkedHashMap();
            Project project = location.getProject();
            PsiElement psiElement = psi = element2.getPsiElement();
            Object psiFile = psiElement != null ? psiElement.getContainingFile() : null;
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null || (psiFile2 = psiFile2.getViewProvider()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block4;
            PsiFile psiFile3 = psiFile2;
            boolean bl2 = false;
            boolean bl3 = false;
            PsiFile file2 = psiFile3;
            boolean bl4 = false;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
            ChangeListManager changeListManager2 = changeListManager;
            Change change = changeListManager2.getChange((VirtualFile)file2);
            if (change != null) {
                Change change2 = change;
                boolean bl5 = false;
                boolean bl6 = false;
                Change change3 = change2;
                boolean bl7 = false;
                Change change4 = change3;
                Intrinsics.checkNotNullExpressionValue((Object)change4, (String)"change");
                features.put("file_state", MLFeatureValue.Companion.categorical((Enum)change4.getType()));
                if (change3.getType() == Change.Type.MODIFICATION && psi instanceof PsiNameIdentifierOwner) {
                    Document document = PsiDocumentManager.getInstance((Project)project).getCachedDocument(psiFile);
                    TextRange range2 = ((PsiNameIdentifierOwner)psi).getTextRange();
                    if (document != null && range2 != null && range2.getEndOffset() <= document.getTextLength()) {
                        Project project2 = project;
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        LineStatusTracker<?> lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project2).getLineStatusTracker(document);
                        if (lineStatusTracker != null && lineStatusTracker.isValid() && lineStatusTracker.isRangeModified(document.getLineNumber(range2.getStartOffset()), document.getLineNumber(range2.getEndOffset()))) {
                            features.put("declaration_is_changed", MLFeatureValue.Companion.binary(true));
                        }
                    }
                }
            }
        }
        return features;
    }
}

