/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorStripeUpdateManager
implements Disposable {
    private final Project myProject;
    private final PsiDocumentManager myPsiDocumentManager;

    public static ErrorStripeUpdateManager getInstance(Project project) {
        return (ErrorStripeUpdateManager)project.getService(ErrorStripeUpdateManager.class);
    }

    public ErrorStripeUpdateManager(Project project) {
        this.myProject = project;
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        TrafficLightRendererContributor.EP_NAME.addChangeListener(() -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                TextEditor textEditor = (TextEditor)fileEditor;
                this.repaintErrorStripePanel(textEditor.getEditor());
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public void repaintErrorStripePanel(@NotNull Editor editor2) {
        if (editor2 == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myProject.isInitialized()) {
            return;
        }
        PsiFile file2 = this.myPsiDocumentManager.getPsiFile(editor2.getDocument());
        EditorMarkupModel markup = (EditorMarkupModel)editor2.getMarkupModel();
        markup.setErrorPanelPopupHandler(new DaemonEditorPopup(this.myProject, editor2));
        markup.setErrorStripTooltipRendererProvider(this.createTooltipRenderer(editor2));
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
        this.setOrRefreshErrorStripeRenderer(markup, file2);
    }

    void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @Nullable PsiFile file2) {
        if (editorMarkupModel == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || file2 == null || !DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(file2)) {
            return;
        }
        ErrorStripeRenderer renderer2 = editorMarkupModel.getErrorStripeRenderer();
        if (renderer2 instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer2;
            EditorMarkupModelImpl markupModelImpl = (EditorMarkupModelImpl)editorMarkupModel;
            tlr.refresh(markupModelImpl);
            markupModelImpl.repaintTrafficLightIcon();
            if (tlr.isValid()) {
                return;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Editor editor2 = editorMarkupModel.getEditor();
            if (editor2.isDisposed()) {
                return;
            }
            TrafficLightRenderer tlRenderer = this.createRenderer(editor2, file2);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor2.isDisposed()) {
                    Disposer.dispose((Disposable)tlRenderer);
                    return;
                }
                editorMarkupModel.setErrorStripeRenderer(tlRenderer);
            });
        });
    }

    @NotNull
    private ErrorStripTooltipRendererProvider createTooltipRenderer(Editor editor2) {
        return new DaemonTooltipRendererProvider(this.myProject, editor2);
    }

    @NotNull
    private TrafficLightRenderer createRenderer(@NotNull Editor editor2, @Nullable PsiFile file2) {
        if (editor2 == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(2);
        }
        for (TrafficLightRendererContributor contributor : TrafficLightRendererContributor.EP_NAME.getExtensionList()) {
            TrafficLightRenderer renderer2 = contributor.createRenderer(editor2, file2);
            if (renderer2 == null) continue;
            TrafficLightRenderer trafficLightRenderer = renderer2;
            if (trafficLightRenderer == null) {
                ErrorStripeUpdateManager.$$$reportNull$$$0(3);
            }
            return trafficLightRenderer;
        }
        return this.createFallbackRenderer(editor2);
    }

    @NotNull
    private TrafficLightRenderer createFallbackRenderer(final @NotNull Editor editor2) {
        if (editor2 == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(4);
        }
        return new TrafficLightRenderer(this.myProject, editor2.getDocument()){

            @Override
            @NotNull
            protected UIController createUIController() {
                UIController uIController = super.createUIController(editor2);
                if (uIController == null) {
                    1.$$$reportNull$$$0(0);
                }
                return uIController;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager$1", "createUIController"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorMarkupModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripePanel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setOrRefreshErrorStripeRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFallbackRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

