/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HintRenderer$Companion$WhenMappings;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0005\u00a2\u0006\u0002\b\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J,\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "getWidthAdjustment", "()Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "setWidthAdjustment", "(Lcom/intellij/codeInsight/hints/HintWidthAdjustment;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "doCalcWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "getFontMetrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFontMetrics$", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Companion", "intellij.platform.ide.impl"})
public class HintRenderer
implements EditorCustomElementRenderer {
    @Nullable
    private HintWidthAdjustment widthAdjustment;
    @Nullable
    private String text;
    private static final Key<Companion.MyFontMetrics> HINT_FONT_METRICS;
    private static final float BACKGROUND_ALPHA = 0.55f;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final HintWidthAdjustment getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public final void setWidthAdjustment(@Nullable HintWidthAdjustment hintWidthAdjustment) {
        this.widthAdjustment = hintWidthAdjustment;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        return Companion.calcWidthInPixels(editor2, this.text, this.widthAdjustment);
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return editor2.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        TextAttributes textAttributes2;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        Editor editor3 = editor2;
        if (!(editor3 instanceof EditorImpl)) {
            return;
        }
        Segment focusModeRange = ((EditorImpl)editor3).getFocusModeRange();
        if (focusModeRange != null && (inlay.getOffset() <= focusModeRange.getStartOffset() || focusModeRange.getEndOffset() <= inlay.getOffset())) {
            textAttributes2 = (TextAttributes)editor3.getUserData(FocusModeModel.FOCUS_MODE_ATTRIBUTES);
            if (textAttributes2 == null) {
                textAttributes2 = this.getTextAttributes(editor3);
            }
        } else {
            textAttributes2 = this.getTextAttributes(editor3);
        }
        TextAttributes attributes2 = textAttributes2;
        Companion.paintHint(g, (EditorImpl)editor3, r, this.text, attributes2, textAttributes, this.widthAdjustment);
    }

    protected final int doCalcWidth(@Nullable String text2, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return Companion.calcHintTextWidth(text2, fontMetrics);
    }

    @JvmName(name="getFontMetrics$")
    protected final /* synthetic */ Companion.MyFontMetrics getFontMetrics$(Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return Companion.getFontMetrics(editor2);
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    public HintRenderer(@Nullable String text2) {
        this.text = text2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ParameterHintFontMetrics");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<MyFontMetrics\u2026arameterHintFontMetrics\")");
        HINT_FONT_METRICS = key;
    }

    @JvmStatic
    public static final int calcWidthInPixels(@NotNull Editor editor2, @Nullable String text2, @Nullable HintWidthAdjustment widthAdjustment) {
        return Companion.calcWidthInPixels(editor2, text2, widthAdjustment);
    }

    @JvmStatic
    public static final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor2, @NotNull Rectangle r, @Nullable String text2, @Nullable TextAttributes attributes2, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment) {
        Companion.paintHint(g, editor2, r, text2, attributes2, textAttributes, widthAdjustment);
    }

    @JvmStatic
    @NotNull
    protected static final Companion.MyFontMetrics getFontMetrics(@NotNull Editor editor2) {
        return Companion.getFontMetrics(editor2);
    }

    @JvmStatic
    protected static final int calcHintTextWidth(@Nullable String text2, @NotNull FontMetrics fontMetrics) {
        return Companion.calcHintTextWidth(text2, fontMetrics);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0005J,\u0010\u0010\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0005J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002JF\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0004H\u0002J\f\u0010+\u001a\u00020,*\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion;", "", "()V", "BACKGROUND_ALPHA", "", "HINT_FONT_METRICS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "calcHintTextWidth", "", "text", "", "fontMetrics", "Ljava/awt/FontMetrics;", "calcWidthAdjustment", "editor", "Lcom/intellij/openapi/editor/Editor;", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "calcWidthInPixels", "getFont", "Ljava/awt/Font;", "getFontMetrics", "isInsufficientContrast", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "surroundingAttributes", "paintHint", "", "g", "Ljava/awt/Graphics;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "r", "Ljava/awt/Rectangle;", "textAttributes", "srcOverBlend", "Ljava/awt/Color;", "foreground", "background", "foregroundAlpha", "toGray", "", "MyFontMetrics", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public final int calcWidthInPixels(@NotNull Editor editor2, @Nullable String text2, @Nullable HintWidthAdjustment widthAdjustment) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            FontMetrics fontMetrics = this.getFontMetrics(editor2).getMetrics();
            return this.calcHintTextWidth(text2, fontMetrics) + this.calcWidthAdjustment(text2, editor2, fontMetrics, widthAdjustment);
        }

        @JvmStatic
        public final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor2, @NotNull Rectangle r, @Nullable String text2, @Nullable TextAttributes attributes2, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            int ascent = editor2.getAscent();
            int descent = editor2.getDescent();
            Graphics2D g2d = (Graphics2D)g;
            if (text2 != null && attributes2 != null) {
                Color foregroundColor;
                MyFontMetrics fontMetrics = this.getFontMetrics(editor2);
                int gap = r.height < fontMetrics.getLineHeight() + 2 ? 1 : 2;
                Color backgroundColor = attributes2.getBackgroundColor();
                if (backgroundColor != null) {
                    float alpha = this.isInsufficientContrast(attributes2, textAttributes) ? 1.0f : 0.55f;
                    GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                    GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha);
                    g.setColor(backgroundColor);
                    g.fillRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                    config2.restore();
                }
                if ((foregroundColor = attributes2.getForegroundColor()) != null) {
                    Object savedHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    Shape savedClip = g.getClip();
                    g.setColor(foregroundColor);
                    g.setFont(this.getFont(editor2));
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                    g.clipRect(r.x + 3, r.y + 2, r.width - 6, r.height - 4);
                    FontMetrics metrics = fontMetrics.getMetrics();
                    int startX = r.x + 7;
                    int startY = r.y + Math.max(ascent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1;
                    Editor editor3 = editor2;
                    FontMetrics fontMetrics2 = ((Graphics2D)g).getFontMetrics();
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"g.fontMetrics");
                    int adjustment = this.calcWidthAdjustment(text2, editor3, fontMetrics2, widthAdjustment);
                    if (adjustment == 0) {
                        g.drawString(text2, startX, startY);
                    } else {
                        HintWidthAdjustment hintWidthAdjustment = widthAdjustment;
                        Intrinsics.checkNotNull((Object)hintWidthAdjustment);
                        int adjustmentPosition = hintWidthAdjustment.getAdjustmentPosition();
                        String string = text2;
                        int n = 0;
                        boolean bl = false;
                        String string2 = string.substring(n, adjustmentPosition);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String firstPart = string2;
                        String string3 = text2;
                        bl = false;
                        String string4 = string3.substring(adjustmentPosition);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String secondPart = string4;
                        g.drawString(firstPart, startX, startY);
                        g.drawString(secondPart, startX + g.getFontMetrics().stringWidth(firstPart) + adjustment, startY);
                    }
                    g.setClip(savedClip);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
                }
            }
            Color effectColor = textAttributes.getEffectColor();
            EffectType effectType = textAttributes.getEffectType();
            if (effectColor != null) {
                g.setColor(effectColor);
                int xStart = r.x;
                int xEnd = r.x + r.width;
                int y = r.y + ascent;
                Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN);
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"editor.getColorsScheme()\u2026ont(EditorFontType.PLAIN)");
                Font font2 = font;
                EffectType effectType2 = effectType;
                if (effectType2 != null) {
                    switch (HintRenderer$Companion$WhenMappings.$EnumSwitchMapping$0[effectType2.ordinal()]) {
                        case 1: {
                            EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                            break;
                        }
                        case 2: {
                            EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                            break;
                        }
                        case 3: {
                            EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, editor2.getCharHeight(), (Object)font2);
                            break;
                        }
                        case 4: {
                            EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                            break;
                        }
                        case 5: {
                            EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                            break;
                        }
                    }
                }
            }
        }

        private final boolean isInsufficientContrast(TextAttributes attributes2, TextAttributes surroundingAttributes) {
            Color backgroundUnderHint = surroundingAttributes.getBackgroundColor();
            if (backgroundUnderHint != null && attributes2.getForegroundColor() != null) {
                Color color = attributes2.getBackgroundColor();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"attributes.backgroundColor");
                Color backgroundBlended = this.srcOverBlend(color, backgroundUnderHint, 0.55f);
                double backgroundBlendedGrayed = this.toGray(backgroundBlended);
                Color color2 = attributes2.getForegroundColor();
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"attributes.foregroundColor");
                double textGrayed = this.toGray(color2);
                double delta = Math.abs(backgroundBlendedGrayed - textGrayed);
                return delta < (double)10;
            }
            return false;
        }

        private final double toGray(Color $this$toGray) {
            return 0.3 * (double)$this$toGray.getRed() + 0.59 * (double)$this$toGray.getGreen() + 0.11 * (double)$this$toGray.getBlue();
        }

        private final Color srcOverBlend(Color foreground, Color background, float foregroundAlpha) {
            float r = (float)foreground.getRed() * foregroundAlpha + (float)background.getRed() * (1.0f - foregroundAlpha);
            float g = (float)foreground.getGreen() * foregroundAlpha + (float)background.getGreen() * (1.0f - foregroundAlpha);
            float b = (float)foreground.getBlue() * foregroundAlpha + (float)background.getBlue() * (1.0f - foregroundAlpha);
            return new Color(MathKt.roundToInt((float)r), MathKt.roundToInt((float)g), MathKt.roundToInt((float)b));
        }

        private final int calcWidthAdjustment(String text2, Editor editor2, FontMetrics fontMetrics, HintWidthAdjustment widthAdjustment) {
            if (widthAdjustment == null || !(editor2 instanceof EditorImpl)) {
                return 0;
            }
            int editorTextWidth = ((EditorImpl)editor2).getFontMetrics(0).stringWidth(widthAdjustment.getEditorTextToMatch());
            return Math.max(0, editorTextWidth + this.calcHintTextWidth(widthAdjustment.getHintTextToMatch(), fontMetrics) - this.calcHintTextWidth(text2, fontMetrics));
        }

        @JvmStatic
        @NotNull
        protected final MyFontMetrics getFontMetrics(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Font font = UIManager.getFont("Label.font");
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"UIManager.getFont(\"Label.font\")");
            String familyName = font.getFamily();
            EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
            int size = Math.max(1, editorColorsScheme.getEditorFontSize() - 1);
            MyFontMetrics metrics = (MyFontMetrics)editor2.getUserData(HINT_FONT_METRICS);
            if (metrics != null) {
                String string = familyName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"familyName");
                if (!metrics.isActual(editor2, string, size)) {
                    metrics = null;
                }
            }
            if (metrics == null) {
                String string = familyName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"familyName");
                metrics = new MyFontMetrics(editor2, string, size);
                editor2.putUserData(HINT_FONT_METRICS, (Object)metrics);
            }
            return metrics;
        }

        private final Font getFont(Editor editor2) {
            return this.getFontMetrics(editor2).getFont();
        }

        @JvmStatic
        protected final int calcHintTextWidth(@Nullable String text2, @NotNull FontMetrics fontMetrics) {
            Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
            return text2 == null ? 0 : fontMetrics.stringWidth(text2) + 14;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "familyName", "", "size", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;I)V", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "lineHeight", "getLineHeight", "()I", "metrics", "Ljava/awt/FontMetrics;", "getMetrics", "()Ljava/awt/FontMetrics;", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "isActual", "", "intellij.platform.ide.impl"})
        public static final class MyFontMetrics {
            @NotNull
            private final FontMetrics metrics;
            private final int lineHeight;

            @NotNull
            public final FontMetrics getMetrics() {
                return this.metrics;
            }

            public final int getLineHeight() {
                return this.lineHeight;
            }

            @NotNull
            public final Font getFont() {
                Font font = this.metrics.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"metrics.font");
                return font;
            }

            public final boolean isActual(@NotNull Editor editor2, @NotNull String familyName, int size) {
                Font font;
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
                Font font2 = font = this.metrics.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
                if (Intrinsics.areEqual((Object)familyName, (Object)font2.getFamily()) ^ true || size != font.getSize()) {
                    return false;
                }
                FontRenderContext currentContext = this.getCurrentContext(editor2);
                return currentContext.equals(this.metrics.getFontRenderContext());
            }

            private final FontRenderContext getCurrentContext(Editor editor2) {
                FontRenderContext editorContext;
                FontRenderContext fontRenderContext = editorContext = FontInfo.getFontRenderContext(editor2.getContentComponent());
                Intrinsics.checkNotNullExpressionValue((Object)fontRenderContext, (String)"editorContext");
                return new FontRenderContext(fontRenderContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getEditorFractionalMetricsHint());
            }

            public MyFontMetrics(@NotNull Editor editor2, @NotNull String familyName, int size) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
                FontUIResource fontUIResource = StartupUiUtil.getFontWithFallback((String)familyName, (int)0, (int)size);
                Intrinsics.checkNotNullExpressionValue((Object)fontUIResource, (String)"StartupUiUtil.getFontWit\u2026lyName, Font.PLAIN, size)");
                FontUIResource font = fontUIResource;
                FontRenderContext context2 = this.getCurrentContext(editor2);
                FontMetrics fontMetrics = FontInfo.getFontMetrics(font, context2);
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"FontInfo.getFontMetrics(font, context)");
                this.metrics = fontMetrics;
                GlyphVector glyphVector = font.createGlyphVector(context2, "Ap");
                Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"font.createGlyphVector(context, \"Ap\")");
                Rectangle2D rectangle2D = glyphVector.getVisualBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"font.createGlyphVector(context, \"Ap\").visualBounds");
                this.lineHeight = (int)Math.ceil(rectangle2D.getHeight());
            }
        }
    }
}

