/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class IntentionsUIImpl
extends IntentionsUI {
    private volatile IntentionHintComponent myLastIntentionHint;

    public IntentionsUIImpl(Project project) {
        super(project);
    }

    IntentionHintComponent getLastIntentionHint() {
        return this.myLastIntentionHint;
    }

    @Override
    public void update(@NotNull CachedIntentions cachedIntentions, boolean actionsChanged) {
        if (cachedIntentions == null) {
            IntentionsUIImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = cachedIntentions.getEditor();
        if (editor2 == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor2.getContentComponent().hasFocus()) {
            return;
        }
        if (!actionsChanged) {
            return;
        }
        Project project = cachedIntentions.getProject();
        LogicalPosition caretPos = editor2.getCaretModel().getLogicalPosition();
        Rectangle visibleArea = editor2.getScrollingModel().getVisibleArea();
        Point xy = editor2.logicalPositionToXY(caretPos);
        this.hide();
        if (!HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(false) && visibleArea.contains(xy) && editor2.getSettings().isShowIntentionBulb() && editor2.getCaretModel().getCaretCount() == 1 && cachedIntentions.showBulb()) {
            this.myLastIntentionHint = IntentionHintComponent.showIntentionHint(project, cachedIntentions.getFile(), editor2, false, cachedIntentions);
        }
    }

    @Override
    public void hide() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionHintComponent hint = this.myLastIntentionHint;
        if (hint != null && !hint.isDisposed() && hint.isVisible()) {
            hint.hide();
        }
        this.myLastIntentionHint = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedIntentions", "com/intellij/codeInsight/daemon/impl/IntentionsUIImpl", "update"));
    }
}

