/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.InspectionProfilerDataHolder;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.RedundantSuppressInspection;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.markup.UnmodifiableTextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPass.class);
    public static final TextRange EMPTY_PRIORITY_RANGE = TextRange.EMPTY_RANGE;
    private static final Predicate<PsiFile> SHOULD_INSPECT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)file2);
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private final ConcurrentMap<PsiFile, List<InspectionResult>> result;
    private final InspectListener myInspectTopicPublisher;
    private volatile List<HighlightInfo> myInfos;
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionProfileWrapper myProfileWrapper;
    private final Map<String, Set<PsiElement>> mySuppressedElements;
    private final boolean myInspectInjectedPsi;
    private static final Set<String> ourToolsWithInformationProblems = new HashSet<String>();
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new UnmodifiableTextAttributes(){

        public boolean isEmpty() {
            return false;
        }
    };
    private final Map<TextRange, RangeMarker> ranges2markersCache;
    private final InjectedLanguageManager ilManager;
    private final List<HighlightInfo> infos;
    private final PsiDocumentManager documentManager;
    private final Set<Pair<TextRange, String>> emptyActionRegistered;
    private static final Interner<String> tooltips = Interner.createWeakInterner();

    public LocalInspectionsPass(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor, boolean inspectInjectedPsi) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LocalInspectionsPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoProcessor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), document, DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]), file2, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        this.result = new ConcurrentHashMap<PsiFile, List<InspectionResult>>();
        this.myInfos = Collections.emptyList();
        this.mySuppressedElements = new ConcurrentHashMap<String, Set<PsiElement>>();
        this.ranges2markersCache = new HashMap<TextRange, RangeMarker>();
        this.ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        this.infos = new ArrayList<HighlightInfo>(2);
        this.documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.emptyActionRegistered = Collections.synchronizedSet(new HashSet());
        assert (file2.isPhysical()) : "can't inspect non-physical file: " + file2 + "; " + file2.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 != null) {
            Keymap keymap2 = keymapManager2.getActiveKeymap();
            this.myShortcutText = "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap2.getShortcuts("ShowErrorDescription")) + ")";
        } else {
            this.myShortcutText = "";
        }
        InspectionProfileImpl profileToUse = ProjectInspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function custom = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        InspectionProfileWrapper inspectionProfileWrapper = this.myProfileWrapper = custom == null ? new InspectionProfileWrapper(profileToUse) : (InspectionProfileWrapper)custom.apply(profileToUse);
        assert (this.myProfileWrapper != null);
        this.mySeverityRegistrar = this.myProfileWrapper.getProfileManager().getSeverityRegistrar();
        this.myInspectInjectedPsi = inspectInjectedPsi;
        this.myInspectTopicPublisher = (InspectListener)this.myProject.getMessageBus().syncPublisher(GlobalInspectionContextEx.INSPECT_TOPIC);
        this.setProgressLimit(600L);
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(5);
        }
        try {
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.getFile())) {
                return;
            }
            this.inspect(this.getInspectionTools(this.myProfileWrapper), InspectionManager.getInstance((Project)this.myProject), true, progress2);
        }
        finally {
            this.disposeDescriptors();
        }
    }

    private void disposeDescriptors() {
        this.result.clear();
    }

    public void doInspectInBatch(@NotNull GlobalInspectionContextImpl context2, @NotNull InspectionManager iManager, @NotNull List<? extends LocalInspectionToolWrapper> toolWrappers) {
        if (context2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(6);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(7);
        }
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(8);
        }
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        this.inspect(new ArrayList<LocalInspectionToolWrapper>(toolWrappers), iManager, false, progress2);
        this.addDescriptorsFromInjectedResultsInBatch(context2);
        List resultList = (List)this.result.get(this.getFile());
        if (resultList == null) {
            return;
        }
        for (InspectionResult inspectionResult2 : resultList) {
            LocalInspectionToolWrapper toolWrapper = inspectionResult2.tool;
            String shortName = toolWrapper.getShortName();
            ArrayList<ProblemDescriptor> toReport = new ArrayList<ProblemDescriptor>(inspectionResult2.foundProblems.size());
            for (ProblemDescriptor problemDescriptor : inspectionResult2.foundProblems) {
                ProblemHighlightType highlightType = problemDescriptor.getHighlightType();
                if (highlightType == ProblemHighlightType.INFORMATION) {
                    if (!ourToolsWithInformationProblems.add(shortName)) continue;
                    String message2 = "Tool #" + shortName + " registers INFORMATION level problem in batch mode on " + this.getFile() + ". INFORMATION level 'warnings' are invisible in the editor and should not become visible in batch mode. Moreover, cause INFORMATION level fixes act more like intention actions, they could e.g. change semantics and thus should not be suggested for batch transformations";
                    LocalInspectionEP extension2 = (LocalInspectionEP)toolWrapper.getExtension();
                    if (extension2 != null) {
                        LOG.error((Throwable)new PluginException(message2, extension2.getPluginDescriptor().getPluginId()));
                        continue;
                    }
                    LOG.error(message2);
                    continue;
                }
                if (highlightType == ProblemHighlightType.POSSIBLE_PROBLEM) continue;
                toReport.add(problemDescriptor);
            }
            this.addDescriptors(toolWrapper, toReport, context2);
        }
    }

    private void addDescriptors(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull Collection<? extends ProblemDescriptor> descriptors, @NotNull GlobalInspectionContextImpl context2) {
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            LocalInspectionsPass.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(11);
        }
        InspectionToolResultExporter toolPresentation = context2.getPresentation(toolWrapper);
        BatchModeDescriptorsUtil.addProblemDescriptors(descriptors, toolPresentation, this.myIgnoreSuppressed, context2, (LocalInspectionTool)toolWrapper.getTool());
    }

    private void addDescriptorsFromInjectedResultsInBatch(@NotNull GlobalInspectionContextImpl context2) {
        if (context2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(12);
        }
        for (Map.Entry entry2 : this.result.entrySet()) {
            PsiFile file2 = (PsiFile)entry2.getKey();
            if (file2 == this.getFile()) continue;
            List resultList = (List)entry2.getValue();
            for (InspectionResult inspectionResult2 : resultList) {
                LocalInspectionToolWrapper toolWrapper = inspectionResult2.tool;
                ArrayList<ProblemDescriptor> toReport = new ArrayList<ProblemDescriptor>(inspectionResult2.foundProblems.size());
                for (ProblemDescriptor problemDescriptor : inspectionResult2.foundProblems) {
                    PsiElement psiElement = problemDescriptor.getPsiElement();
                    if (psiElement == null || ((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement)) continue;
                    toReport.add(problemDescriptor);
                }
                this.addDescriptors(toolWrapper, toReport, context2);
            }
        }
    }

    private void inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator progress2) {
        boolean isWholeFileInspectionsPass;
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(13);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(14);
        }
        if (progress2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(15);
        }
        if (toolWrappers.isEmpty()) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_INSPECT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List inside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        long finalPriorityRange = allDivided.isEmpty() ? Divider.toScalarRange(this.myPriorityRange) : ((Divider.DividedElements)allDivided.get((int)0)).priorityRange;
        for (int i2 = 1; i2 < allDivided.size(); ++i2) {
            Divider.DividedElements dividedElements = (Divider.DividedElements)allDivided.get(i2);
            finalPriorityRange = Divider.union(finalPriorityRange, dividedElements.priorityRange);
        }
        List outside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.outside, d.parents)));
        this.setProgressLimit((long)toolWrappers.size() * 2L);
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset());
        List<LocalInspectionToolWrapper> filteredWrappers = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, InspectionEngine.calcElementDialectIds(inside, outside));
        InspectionContext TOMB_STONE = InspectionContext.createTombStone(this);
        long start2 = System.nanoTime();
        List<InspectionContext> init2 = this.visitPriorityElementsAndInit(filteredWrappers, iManager, isOnTheFly, progress2, inside, finalPriorityRange, session2, TOMB_STONE);
        Set<PsiFile> alreadyVisitedInjected = this.inspectInjectedPsi(inside, isOnTheFly, progress2, iManager, true, toolWrappers, Collections.emptySet());
        this.visitRestElementsAndCleanup(progress2, outside, finalPriorityRange, session2, init2, TOMB_STONE);
        boolean bl = isWholeFileInspectionsPass = !toolWrappers.isEmpty() && ((LocalInspectionTool)toolWrappers.get(0).getTool()).runForWholeFile();
        if (isOnTheFly && !isWholeFileInspectionsPass) {
            InspectionProfilerDataHolder.getInstance(this.myProject).saveStats(this.getFile(), init2, System.nanoTime() - start2);
        }
        this.reportStatsToQodana(isOnTheFly, this.getFile(), init2);
        this.inspectInjectedPsi(outside, isOnTheFly, progress2, iManager, false, toolWrappers, alreadyVisitedInjected);
        ProgressManager.checkCanceled();
        this.myInfos = new ArrayList<HighlightInfo>();
        this.addHighlightsFromResults(this.myInfos);
        if (isOnTheFly) {
            this.highlightRedundantSuppressions(toolWrappers, iManager, inside, outside);
        }
    }

    @NotNull
    private static Set<PsiFile> createInjectedFileSet() {
        Set set2 = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<PsiFile>(){

            public int hashCode(PsiFile f) {
                VirtualFile host;
                if (f == null) {
                    return 0;
                }
                VirtualFile v = f.getVirtualFile();
                VirtualFile virtualFile2 = host = v instanceof VirtualFileWindow ? ((VirtualFileWindow)v).getDelegate() : null;
                if (host == null) {
                    return 0;
                }
                return v.hashCode() * 37 + Objects.hashCode(ArrayUtil.getFirstElement((Object[])((VirtualFileWindow)v).getDocumentWindow().getHostRanges()));
            }

            public boolean equals(PsiFile f1, PsiFile f2) {
                VirtualFile d2;
                if (f1 == null || f2 == null || f1 == f2) {
                    return f1 == f2;
                }
                VirtualFile v1 = f1.getVirtualFile();
                VirtualFile v2 = f2.getVirtualFile();
                if (!(v1 instanceof VirtualFileWindow) || !(v2 instanceof VirtualFileWindow)) {
                    return Objects.equals(v1, v2);
                }
                VirtualFile d1 = ((VirtualFileWindow)v1).getDelegate();
                if (!Objects.equals(d1, d2 = ((VirtualFileWindow)v2).getDelegate())) {
                    return false;
                }
                return Arrays.equals(((VirtualFileWindow)v1).getDocumentWindow().getHostRanges(), ((VirtualFileWindow)v2).getDocumentWindow().getHostRanges());
            }
        });
        if (set2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(16);
        }
        return set2;
    }

    private void reportStatsToQodana(boolean isOnTheFly, PsiFile file2, @NotNull List<? extends InspectionContext> contexts) {
        if (contexts == null) {
            LocalInspectionsPass.$$$reportNull$$$0(17);
        }
        if (!isOnTheFly) {
            for (InspectionContext inspectionContext : contexts) {
                InspectionProblemsHolder holder = inspectionContext.holder;
                long durationMs = TimeUnit.NANOSECONDS.toMillis(holder.finishTimeStamp - holder.initTimeStamp);
                int problemCount = inspectionContext.holder.getResultCount();
                this.myInspectTopicPublisher.inspectionFinished(durationMs, 0L, problemCount, inspectionContext.tool, InspectListener.InspectionKind.LOCAL, file2, this.myProject);
            }
        }
    }

    private void highlightRedundantSuppressions(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, @NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(18);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(19);
        }
        if (inside == null) {
            LocalInspectionsPass.$$$reportNull$$$0(20);
        }
        if (outside == null) {
            LocalInspectionsPass.$$$reportNull$$$0(21);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"RedundantSuppression");
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (key != null && inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            InspectionToolWrapper toolWrapper = inspectionProfile.getInspectionTool("RedundantSuppression", (PsiElement)this.getFile());
            Language fileLanguage = this.getFile().getLanguage();
            InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(fileLanguage);
            if (suppressor instanceof RedundantSuppressionDetector) {
                if (toolWrappers.stream().anyMatch(LocalInspectionToolWrapper::runForWholeFile)) {
                    return;
                }
                HashSet<String> activeTools = new HashSet<String>();
                for (LocalInspectionToolWrapper localInspectionToolWrapper : toolWrappers) {
                    if (localInspectionToolWrapper.isUnfair() || !localInspectionToolWrapper.isApplicable(fileLanguage) || this.myProfileWrapper.getInspectionTool(localInspectionToolWrapper.getShortName(), (PsiElement)this.myFile) instanceof GlobalInspectionToolWrapper) continue;
                    activeTools.add(localInspectionToolWrapper.getID());
                    ContainerUtil.addIfNotNull(activeTools, (Object)localInspectionToolWrapper.getAlternativeID());
                    InspectionElementsMerger elementsMerger = InspectionElementsMerger.getMerger((String)localInspectionToolWrapper.getShortName());
                    if (elementsMerger == null) continue;
                    activeTools.addAll(Arrays.asList(elementsMerger.getSuppressIds()));
                }
                LocalInspectionTool localTool = ((RedundantSuppressInspection)toolWrapper.getTool()).createLocalTool((RedundantSuppressionDetector)suppressor, this.mySuppressedElements, activeTools);
                ProblemsHolder problemsHolder = new ProblemsHolder(iManager, this.getFile(), true);
                PsiElementVisitor visitor = localTool.buildVisitor(problemsHolder, true);
                InspectionEngine.acceptElements(inside, visitor);
                InspectionEngine.acceptElements(outside, visitor);
                HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(key, (PsiElement)this.getFile()).getSeverity();
                for (ProblemDescriptor descriptor2 : problemsHolder.getResults()) {
                    ProgressManager.checkCanceled();
                    PsiElement element2 = descriptor2.getPsiElement();
                    if (element2 == null) continue;
                    Document thisDocument = Objects.requireNonNull(this.documentManager.getDocument(this.getFile()));
                    this.createHighlightsForDescriptor(this.myInfos, this.emptyActionRegistered, this.ilManager, this.getFile(), thisDocument, new LocalInspectionToolWrapper(localTool), severity, descriptor2, element2, false);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<InspectionContext> visitPriorityElementsAndInit(@NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator2, @NotNull List<? extends PsiElement> inside, long finalPriorityRange, @NotNull LocalInspectionToolSession session2, @NotNull InspectionContext inspectionContext) {
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(22);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(23);
        }
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(24);
        }
        if (inside == null) {
            LocalInspectionsPass.$$$reportNull$$$0(25);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(26);
        }
        if (inspectionContext == null) {
            LocalInspectionsPass.$$$reportNull$$$0(27);
        }
        PsiFile file2 = session2.getFile();
        List init2 = ContainerUtil.mapNotNull(wrappers, wrapper2 -> this.createContext((LocalInspectionToolWrapper)((Object)wrapper2), iManager, isOnTheFly, indicator2, session2));
        if (InspectionProfilerDataHolder.isInspectionSortByLatencyEnabled()) {
            void TOMB_STONE;
            InspectionProfilerDataHolder profileData = InspectionProfilerDataHolder.getInstance(this.myProject);
            profileData.sort(this.getFile(), init2);
            profileData.retrieveFavoriteElements(this.getFile(), init2);
            this.processInOrder(init2, inside, true, finalPriorityRange, file2, (InspectionContext)TOMB_STONE, indicator2, context2 -> {
                InspectionProblemsHolder holder = context2.holder;
                if (holder.hasResults()) {
                    this.appendDescriptors(this.getFile(), holder.getResults(), context2.tool);
                }
                holder.applyIncrementally = false;
            });
        } else {
            Processor processor2 = context2 -> (Boolean)AstLoadingFilter.disallowTreeLoading(() -> (Boolean)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> {
                this.oldRunToolOnElements(context2.tool, inside, (InspectionContext)context2);
                return true;
            }));
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init2, indicator2, processor2)) {
                throw new ProcessCanceledException();
            }
        }
        List list2 = init2;
        if (list2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(28);
        }
        return list2;
    }

    private void oldRunToolOnElements(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull List<? extends PsiElement> elements, @NotNull InspectionContext context2) {
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(30);
        }
        if (context2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(31);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InspectionProblemsHolder holder = context2.holder;
        InspectionEngine.acceptElements(elements, context2.visitor);
        this.advanceProgress(1L);
        if (holder.hasResults()) {
            this.appendDescriptors(this.getFile(), holder.getResults(), toolWrapper);
        }
        holder.applyIncrementally = false;
    }

    /*
     * WARNING - void declaration
     */
    private void processInOrder(@NotNull List<? extends InspectionContext> init2, @NotNull List<? extends PsiElement> elements, boolean inside, long finalPriorityRange, @NotNull PsiFile file2, @NotNull InspectionContext TOMB_STONE, @NotNull ProgressIndicator indicator2, @NotNull Consumer<? super InspectionContext> consumer2) {
        void afterProcessCallback;
        if (init2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(32);
        }
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(33);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(34);
        }
        if (TOMB_STONE == null) {
            LocalInspectionsPass.$$$reportNull$$$0(35);
        }
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(36);
        }
        if (consumer2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(37);
        }
        ArrayBlockingQueue<? extends InspectionContext> contexts = new ArrayBlockingQueue<InspectionContext>(init2.size() + 1, false, init2);
        boolean added2 = contexts.offer(TOMB_STONE);
        assert (added2);
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        boolean shouldFailFastAcquiringReadAction = application.isInImpatientReader();
        boolean processed2 = ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(contexts, new LinkedBlockingQueue(), new SensitiveProgressWrapper(indicator2), TOMB_STONE, arg_0 -> this.lambda$processInOrder$12(file2, application, inside, finalPriorityRange, elements, (Consumer)afterProcessCallback, shouldFailFastAcquiringReadAction, arg_0));
        if (!processed2) {
            throw new ProcessCanceledException();
        }
    }

    private InspectionContext createContext(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator2, @NotNull LocalInspectionToolSession session2) {
        InspectionProblemsHolder holder;
        LocalInspectionTool tool;
        PsiElementVisitor visitor;
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(38);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(39);
        }
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(40);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(41);
        }
        if ((visitor = InspectionEngine.createVisitor(tool = (LocalInspectionTool)toolWrapper.getTool(), holder = new InspectionProblemsHolder(toolWrapper, this.getFile(), iManager, isOnTheFly, indicator2), isOnTheFly, session2)) != PsiElementVisitor.EMPTY_VISITOR) {
            tool.inspectionStarted(session2, isOnTheFly);
            return new InspectionContext(toolWrapper, holder, visitor);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void visitRestElementsAndCleanup(@NotNull ProgressIndicator indicator2, @NotNull List<? extends PsiElement> outside, long finalPriorityRange, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends InspectionContext> init2, @NotNull InspectionContext inspectionContext) {
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(42);
        }
        if (outside == null) {
            LocalInspectionsPass.$$$reportNull$$$0(43);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(44);
        }
        if (init2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(45);
        }
        if (inspectionContext == null) {
            LocalInspectionsPass.$$$reportNull$$$0(46);
        }
        for (InspectionContext inspectionContext2 : init2) {
            inspectionContext2.problemsSizeAfterInsideElementsProcessed = inspectionContext2.holder.getResultCount();
        }
        PsiFile file2 = session2.getFile();
        if (InspectionProfilerDataHolder.isInspectionSortByLatencyEnabled()) {
            void TOMB_STONE;
            this.processInOrder(init2, outside, false, finalPriorityRange, file2, (InspectionContext)TOMB_STONE, indicator2, context2 -> {
                InspectionProblemsHolder holder = context2.holder;
                holder.finishTimeStamp = System.nanoTime();
                ((LocalInspectionTool)context2.tool.getTool()).inspectionFinished(session2, (ProblemsHolder)holder);
                if (holder.hasResults()) {
                    List allProblems = holder.getResults();
                    List restProblems = allProblems.subList(context2.problemsSizeAfterInsideElementsProcessed, allProblems.size());
                    this.appendDescriptors(file2, restProblems, context2.tool);
                }
            });
        } else {
            Processor processor2 = context2 -> {
                ProgressManager.checkCanceled();
                ApplicationManager.getApplication().assertReadAccessAllowed();
                AstLoadingFilter.disallowTreeLoading(() -> InspectionEngine.acceptElements(outside, context2.visitor));
                this.advanceProgress(1L);
                InspectionProblemsHolder holder = context2.holder;
                holder.finishTimeStamp = System.nanoTime();
                ((LocalInspectionTool)context2.tool.getTool()).inspectionFinished(session2, (ProblemsHolder)holder);
                if (holder.hasResults()) {
                    List allProblems = holder.getResults();
                    List restProblems = allProblems.subList(context2.problemsSizeAfterInsideElementsProcessed, allProblems.size());
                    this.appendDescriptors(file2, restProblems, context2.tool);
                }
                return true;
            };
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init2, indicator2, processor2)) {
                throw new ProcessCanceledException();
            }
        }
    }

    @NotNull
    private Set<PsiFile> inspectInjectedPsi(@NotNull List<? extends PsiElement> elements, boolean onTheFly, @NotNull ProgressIndicator indicator2, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull Set<? extends PsiFile> alreadyVisitedInjected) {
        if (elements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(47);
        }
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(48);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(49);
        }
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(50);
        }
        if (alreadyVisitedInjected == null) {
            LocalInspectionsPass.$$$reportNull$$$0(51);
        }
        if (!this.myInspectInjectedPsi) {
            Set<PsiFile> set2 = Collections.emptySet();
            if (set2 == null) {
                LocalInspectionsPass.$$$reportNull$$$0(52);
            }
            return set2;
        }
        Set<PsiFile> injected = LocalInspectionsPass.createInjectedFileSet();
        PsiFile containingFile = this.getFile();
        Project project = containingFile.getProject();
        for (PsiElement psiElement : elements) {
            InjectedLanguageManager.getInstance((Project)project).enumerateEx(psiElement, containingFile, false, (injectedPsi, __) -> injected.add(injectedPsi));
        }
        injected.removeAll(alreadyVisitedInjected);
        if (!injected.isEmpty()) {
            Processor processor2 = injectedPsi -> {
                this.doInspectInjectedPsi((PsiFile)injectedPsi, onTheFly, indicator2, iManager, inVisibleRange, wrappers);
                return true;
            };
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<PsiFile>(injected), indicator2, processor2)) {
                throw new ProcessCanceledException();
            }
        }
        Set<PsiFile> set3 = injected;
        if (set3 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(53);
        }
        return set3;
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull @NlsContexts.DetailedDescription String message2, @Nullable @NlsContexts.Tooltip String toolTip, @NotNull PsiElement psiElement, @NotNull List<IntentionAction> quickFixes, @NotNull String toolID) {
        TextRange textRange;
        if (problemDescriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(54);
        }
        if (highlightInfoType == null) {
            LocalInspectionsPass.$$$reportNull$$$0(55);
        }
        if (message2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(56);
        }
        if (psiElement == null) {
            LocalInspectionsPass.$$$reportNull$$$0(57);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(58);
        }
        if (toolID == null) {
            LocalInspectionsPass.$$$reportNull$$$0(59);
        }
        if ((textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals((Object)psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributesKey attributesKey = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes();
        TextAttributes attributes2 = attributesKey == null || this.getColorsScheme() == null ? this.mySeverityRegistrar.getTextAttributesBySeverity(severity) : this.getColorsScheme().getAttributes(attributesKey);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message2).severity(severity).inspectionToolId(toolID);
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (HighlightSeverity.INFORMATION.equals((Object)severity) && attributes2 == null && toolTip == null && !quickFixes.isEmpty()) {
            attributes2 = NONEMPTY_TEXT_ATTRIBUTES;
        }
        if (attributes2 != null) {
            b.textAttributes(attributes2);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor2, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator2) {
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(60);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(61);
        }
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(62);
        }
        if (this.myIgnoreSuppressed) {
            LocalInspectionToolWrapper toolWrapper = tool;
            PsiElement psiElement = descriptor2.getPsiElement();
            if (descriptor2 instanceof ProblemDescriptorWithReporterName) {
                String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor2).getReportingToolName();
                toolWrapper = (LocalInspectionToolWrapper)this.myProfileWrapper.getInspectionTool(reportingToolName, psiElement);
            }
            if (((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement)) {
                this.registerSuppressedElements(psiElement, toolWrapper.getID(), toolWrapper.getAlternativeID());
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement == null) {
                return;
            }
            PsiFile file2 = psiElement.getContainingFile();
            Document thisDocument = Objects.requireNonNull(this.documentManager.getDocument(file2));
            HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(tool.getDisplayKey(), (PsiElement)file2).getSeverity();
            this.infos.clear();
            this.createHighlightsForDescriptor(this.infos, this.emptyActionRegistered, this.ilManager, file2, thisDocument, tool, severity, descriptor2, psiElement);
            for (HighlightInfo info2 : this.infos) {
                EditorColorsScheme colorsScheme = this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.myDocument, this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), info2, colorsScheme, this.getId(), this.ranges2markersCache);
            }
        }, __ -> this.myProject.isDisposed() || indicator2.isCanceled());
    }

    private void appendDescriptors(@NotNull PsiFile file2, @NotNull List<? extends ProblemDescriptor> descriptors, @NotNull LocalInspectionToolWrapper tool) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(63);
        }
        if (descriptors == null) {
            LocalInspectionsPass.$$$reportNull$$$0(64);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(65);
        }
        for (ProblemDescriptor problemDescriptor : descriptors) {
            if (problemDescriptor != null) continue;
            LOG.error("null descriptor. all descriptors(" + descriptors.size() + "): " + descriptors + "; file: " + file2 + " (" + file2.getVirtualFile() + "); tool: " + tool);
        }
        InspectionResult result2 = new InspectionResult(tool, descriptors);
        this.appendResult(file2, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResult(@NotNull PsiFile file2, @NotNull InspectionResult result2) {
        List resultList;
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(66);
        }
        if (result2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(67);
        }
        if ((resultList = (List)this.result.get(file2)) == null) {
            resultList = (List)ConcurrencyUtil.cacheOrGet(this.result, (Object)file2, new ArrayList());
        }
        List list2 = resultList;
        synchronized (list2) {
            resultList.add(result2);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightsFromResults(@NotNull List<? super HighlightInfo> outInfos) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(68);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        HashSet emptyActionRegistered = new HashSet();
        for (Map.Entry entry2 : this.result.entrySet()) {
            List resultList;
            ProgressManager.checkCanceled();
            PsiFile file2 = (PsiFile)entry2.getKey();
            Document documentRange = documentManager.getDocument(file2);
            if (documentRange == null) continue;
            List list2 = resultList = (List)entry2.getValue();
            synchronized (list2) {
                for (InspectionResult inspectionResult2 : resultList) {
                    ProgressManager.checkCanceled();
                    LocalInspectionToolWrapper tool = inspectionResult2.tool;
                    HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(tool.getDisplayKey(), (PsiElement)file2).getSeverity();
                    for (ProblemDescriptor problemDescriptor : inspectionResult2.foundProblems) {
                        ProgressManager.checkCanceled();
                        PsiElement element2 = problemDescriptor.getPsiElement();
                        if (element2 == null) continue;
                        this.createHighlightsForDescriptor(outInfos, emptyActionRegistered, ilManager, file2, documentRange, tool, severity, problemDescriptor, element2, this.myIgnoreSuppressed);
                    }
                }
            }
        }
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor2, @NotNull PsiElement element2, boolean ignoreSuppressed) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(69);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(70);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(71);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(72);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(73);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(74);
        }
        if (severity == null) {
            LocalInspectionsPass.$$$reportNull$$$0(75);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(76);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(77);
        }
        if (descriptor2 instanceof ProblemDescriptorWithReporterName) {
            String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor2).getReportingToolName();
            InspectionToolWrapper<?, ?> reportingTool = this.myProfileWrapper.getInspectionTool(reportingToolName, element2);
            LOG.assertTrue(reportingTool instanceof LocalInspectionToolWrapper, (Object)reportingToolName);
            toolWrapper = (LocalInspectionToolWrapper)reportingTool;
            severity = this.myProfileWrapper.getErrorLevel(HighlightDisplayKey.find((String)reportingToolName), (PsiElement)file2).getSeverity();
        }
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        if (ignoreSuppressed && tool.isSuppressedFor(element2)) {
            this.registerSuppressedElements(element2, toolWrapper.getID(), toolWrapper.getAlternativeID());
            return;
        }
        this.createHighlightsForDescriptor(outInfos, emptyActionRegistered, ilManager, file2, documentRange, toolWrapper, severity, descriptor2, element2);
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor2, @NotNull PsiElement element2) {
        boolean isOutsideInjected;
        List<IntentionAction> fixes;
        HighlightInfo info2;
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(78);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(79);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(80);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(81);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(82);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(83);
        }
        if (severity == null) {
            LocalInspectionsPass.$$$reportNull$$$0(84);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(85);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(86);
        }
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor2, severity, this.mySeverityRegistrar);
        ProblemDescriptorUtil.ProblemPresentation presentation2 = ProblemDescriptorUtil.renderDescriptor((CommonProblemDescriptor)descriptor2, element2, 0);
        String message2 = presentation2.getDescription();
        ProblemGroup problemGroup = descriptor2.getProblemGroup();
        String problemName = problemGroup != null ? problemGroup.getProblemName() : null;
        String shortName = problemName != null ? problemName : toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            return;
        }
        InspectionHighlightInfoType type = new InspectionHighlightInfoType(level, element2);
        String plainMessage = message2.startsWith("<html>") ? StringUtil.unescapeXmlEntities((String)XmlStringUtil.stripHtml((String)message2).replaceAll("<[^>]*>", "")).replaceAll("&nbsp;", " ") : message2;
        String tooltip2 = null;
        if (descriptor2.showTooltip()) {
            String rendered = presentation2.getTooltip();
            tooltip2 = (String)tooltips.intern((Object)DaemonTooltipsUtil.getWrappedTooltip((String)rendered, (String)shortName, (String)this.myShortcutText, (boolean)LocalInspectionsPass.showToolDescription(toolWrapper)));
        }
        if ((info2 = this.highlightInfoFromDescriptor(descriptor2, type, plainMessage, tooltip2, element2, fixes = LocalInspectionsPass.getQuickFixes(key, descriptor2, emptyActionRegistered), key.getID())) == null) {
            return;
        }
        LocalInspectionsPass.registerQuickFixes(info2, fixes, shortName);
        PsiFile context2 = this.getTopLevelFileInBaseLanguage(element2);
        PsiFile myContext = this.getTopLevelFileInBaseLanguage((PsiElement)this.getFile());
        if (context2 != this.getFile()) {
            String errorMessage = "Reported element " + element2 + " is not from the file '" + file2.getVirtualFile().getPath() + "' the inspection '" + shortName + "' (" + ((LocalInspectionTool)toolWrapper.getTool()).getClass() + ") was invoked for. Message: '" + descriptor2 + "'.\nElement containing file: " + context2 + "\nInspection invoked for file: " + myContext + "\n";
            PluginException.logPluginError((Logger)LOG, (String)errorMessage, null, ((LocalInspectionTool)toolWrapper.getTool()).getClass());
        }
        boolean bl = isOutsideInjected = !this.myInspectInjectedPsi || file2 == this.getFile();
        if (isOutsideInjected) {
            outInfos.add(info2);
        } else {
            LocalInspectionsPass.injectToHost(outInfos, ilManager, file2, documentRange, element2, fixes, info2, shortName);
        }
    }

    private void registerSuppressedElements(@NotNull PsiElement element2, @NotNull String id2, @Nullable String alternativeID) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(87);
        }
        if (id2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(88);
        }
        this.mySuppressedElements.computeIfAbsent(id2, __ -> new HashSet()).add(element2);
        if (alternativeID != null) {
            this.mySuppressedElements.computeIfAbsent(alternativeID, __ -> new HashSet()).add(element2);
        }
    }

    private static void injectToHost(@NotNull List<? super HighlightInfo> outInfos, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull PsiElement element2, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightInfo info2, @NotNull String shortName) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(89);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(90);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(91);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(92);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(93);
        }
        if (fixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(94);
        }
        if (info2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(95);
        }
        if (shortName == null) {
            LocalInspectionsPass.$$$reportNull$$$0(96);
        }
        List editables = ilManager.intersectWithAllEditableFragments(file2, new TextRange(info2.startOffset, info2.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start2 = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(info2.type).range(element2, start2, end);
            String description = info2.getDescription();
            if (description != null) {
                builder2.description(description);
            }
            if ((toolTip = info2.getToolTip()) != null) {
                builder2.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder2.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info2.startOffset != info2.endOffset) continue;
            patched.markFromInjection();
            LocalInspectionsPass.registerQuickFixes(patched, fixes, shortName);
            outInfos.add(patched);
        }
    }

    private PsiFile getTopLevelFileInBaseLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(97);
        }
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)this.myProject).getTopLevelFile(element2);
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean showToolDescription(@NotNull LocalInspectionToolWrapper tool) {
        String staticDescription;
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(98);
        }
        return (staticDescription = tool.getStaticDescription()) == null || !staticDescription.isEmpty();
    }

    private static void registerQuickFixes(@NotNull HighlightInfo highlightInfo, @NotNull List<? extends IntentionAction> quickFixes, @NotNull String shortName) {
        if (highlightInfo == null) {
            LocalInspectionsPass.$$$reportNull$$$0(99);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(100);
        }
        if (shortName == null) {
            LocalInspectionsPass.$$$reportNull$$$0(101);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        for (IntentionAction intentionAction : quickFixes) {
            QuickFixAction.registerQuickFixAction(highlightInfo, intentionAction, key);
        }
    }

    @NotNull
    private static List<IntentionAction> getQuickFixes(@NotNull HighlightDisplayKey key, @NotNull ProblemDescriptor descriptor2, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        if (key == null) {
            LocalInspectionsPass.$$$reportNull$$$0(102);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(103);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(104);
        }
        SmartList result2 = new SmartList();
        boolean needEmptyAction = true;
        Object[] fixes = descriptor2.getFixes();
        if (fixes != null && fixes.length != 0) {
            for (int k = 0; k < fixes.length; ++k) {
                QuickFix fix2 = fixes[k];
                if (fix2 == null) {
                    throw new IllegalStateException("Inspection " + key + " returns null quick fix in its descriptor: " + descriptor2 + "; array: " + Arrays.toString(fixes));
                }
                result2.add(QuickFixWrapper.wrap(descriptor2, k));
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor2 instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor2).getHintAction() : null;
        if (hintAction != null) {
            result2.add(hintAction);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor2).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add((Pair<TextRange, String>)Pair.create((Object)((ProblemDescriptorBase)descriptor2).getTextRange(), (Object)key.toString()))) {
            String displayNameByKey = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key);
            LOG.assertTrue(displayNameByKey != null, (Object)key.toString());
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(displayNameByKey);
            result2.add(emptyIntentionAction);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(105);
        }
        return smartList;
    }

    private static void getElementsAndDialectsFrom(@NotNull PsiFile file2, final @NotNull List<? super PsiElement> outElements, @NotNull Set<? super String> outDialects) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(106);
        }
        if (outElements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(107);
        }
        if (outDialects == null) {
            LocalInspectionsPass.$$$reportNull$$$0(108);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((Set)processedLanguages, outDialects){
            final /* synthetic */ Set val$processedLanguages;
            final /* synthetic */ Set val$outDialects;
            {
                this.val$processedLanguages = set2;
                this.val$outDialects = set3;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                    outElements.add(child2);
                    child2.accept((PsiElementVisitor)this);
                    LocalInspectionsPass.appendDialects(child2, this.val$processedLanguages, this.val$outDialects);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$3", "visitElement"));
            }
        };
        for (Language language2 : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language2);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            outElements.add((PsiElement)psiRoot);
            psiRoot.accept((PsiElementVisitor)visitor);
            LocalInspectionsPass.appendDialects((PsiElement)psiRoot, (Set<? super Language>)processedLanguages, outDialects);
        }
    }

    private static void appendDialects(@NotNull PsiElement element2, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(109);
        }
        if (outProcessedLanguages == null) {
            LocalInspectionsPass.$$$reportNull$$$0(110);
        }
        if (outDialectIds == null) {
            LocalInspectionsPass.$$$reportNull$$$0(111);
        }
        Language language2 = element2.getLanguage();
        outDialectIds.add(language2.getID());
        if (outProcessedLanguages.add((Language)language2)) {
            for (Language dialect : language2.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
        if (profile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(112);
        }
        List toolWrappers = profile.getInspectionProfile().getInspectionTools((PsiElement)this.getFile());
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            LocalInspectionToolWrapper wrapper2;
            HighlightDisplayKey key;
            ProgressManager.checkCanceled();
            if (toolWrapper instanceof LocalInspectionToolWrapper && !this.isAcceptableLocalTool((LocalInspectionToolWrapper)toolWrapper) || !profile.isToolEnabled(key = toolWrapper.getDisplayKey(), (PsiElement)this.getFile()) || HighlightDisplayLevel.DO_NOT_SHOW.equals(profile.getErrorLevel(key, (PsiElement)this.getFile()))) continue;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper2 = (LocalInspectionToolWrapper)toolWrapper;
            } else {
                wrapper2 = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
                if (wrapper2 == null || !this.isAcceptableLocalTool(wrapper2)) continue;
            }
            String language2 = wrapper2.getLanguage();
            if (language2 != null && Language.findLanguageByID((String)language2) == null || this.myIgnoreSuppressed && ((LocalInspectionTool)wrapper2.getTool()).isSuppressedFor((PsiElement)this.getFile())) continue;
            enabled.add(wrapper2);
        }
        ArrayList<LocalInspectionToolWrapper> arrayList = enabled;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(113);
        }
        return arrayList;
    }

    protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
        if (wrapper2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(114);
        }
        return true;
    }

    private void doInspectInjectedPsi(@NotNull PsiFile injectedPsi, boolean isOnTheFly, @NotNull ProgressIndicator indicator2, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<? extends LocalInspectionToolWrapper> wrappers) {
        if (injectedPsi == null) {
            LocalInspectionsPass.$$$reportNull$$$0(115);
        }
        if (indicator2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(116);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(117);
        }
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(118);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)injectedPsi.getProject()).getInjectionHost((PsiElement)injectedPsi);
        ArrayList elements = new ArrayList();
        SmartHashSet elementDialectIds = new SmartHashSet();
        LocalInspectionsPass.getElementsAndDialectsFrom(injectedPsi, elements, (Set<? super String>)elementDialectIds);
        if (elements.isEmpty()) {
            return;
        }
        List<LocalInspectionToolWrapper> applicableTools = InspectionEngine.filterToolsApplicableByLanguage(wrappers, (Set<String>)elementDialectIds);
        for (LocalInspectionToolWrapper wrapper2 : applicableTools) {
            ProgressManager.checkCanceled();
            LocalInspectionTool tool = (LocalInspectionTool)wrapper2.getTool();
            ProblemsHolder holder = new ProblemsHolder(iManager, injectedPsi, isOnTheFly, (PsiElement)host, tool, wrapper2, isOnTheFly, inVisibleRange, indicator2){
                final /* synthetic */ PsiElement val$host;
                final /* synthetic */ LocalInspectionTool val$tool;
                final /* synthetic */ LocalInspectionToolWrapper val$wrapper;
                final /* synthetic */ boolean val$isOnTheFly;
                final /* synthetic */ boolean val$inVisibleRange;
                final /* synthetic */ ProgressIndicator val$indicator;
                {
                    this.val$host = psiElement;
                    this.val$tool = localInspectionTool;
                    this.val$wrapper = localInspectionToolWrapper;
                    this.val$isOnTheFly = bl;
                    this.val$inVisibleRange = bl2;
                    this.val$indicator = progressIndicator;
                    super(arg0, arg1, arg2);
                }

                public void registerProblem(@NotNull ProblemDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (this.val$host != null && LocalInspectionsPass.this.myIgnoreSuppressed && this.val$tool.isSuppressedFor(this.val$host)) {
                        LocalInspectionsPass.this.registerSuppressedElements(this.val$host, this.val$wrapper.getID(), this.val$wrapper.getAlternativeID());
                        return;
                    }
                    super.registerProblem(descriptor2);
                    if (this.val$isOnTheFly && this.val$inVisibleRange) {
                        LocalInspectionsPass.this.addDescriptorIncrementally(descriptor2, this.val$wrapper, this.val$indicator);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$4", "registerProblem"));
                }
            };
            LocalInspectionToolSession injSession = new LocalInspectionToolSession(injectedPsi, 0, injectedPsi.getTextLength());
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, injSession, elements);
            tool.inspectionFinished(injSession, holder);
            List problems = holder.getResults();
            if (problems.isEmpty()) continue;
            this.appendDescriptors(injectedPsi, problems, wrapper2);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = this.myInfos;
        if (list2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(119);
        }
        return list2;
    }

    private /* synthetic */ boolean lambda$processInOrder$12(PsiFile file2, ApplicationEx application, boolean inside, long finalPriorityRange, List elements, Consumer afterProcessCallback, boolean shouldFailFastAcquiringReadAction, InspectionContext context2) {
        return (Boolean)AstLoadingFilter.disallowTreeLoading(() -> (Boolean)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> {
            Runnable runnable2 = () -> {
                if (!application.tryRunReadAction(() -> {
                    InspectionProblemsHolder holder = context2.holder;
                    int resultCount = holder.getResultCount();
                    PsiElement favoriteElement = context2.myFavoriteElement;
                    if (favoriteElement != null && inside == favoriteElement.getTextRange().intersects(Divider.startOffset(finalPriorityRange), Divider.endOffset(finalPriorityRange))) {
                        context2.myFavoriteElement = null;
                        favoriteElement.accept(context2.visitor);
                        if (holder.getResultCount() != resultCount && resultCount != -1) {
                            context2.myFavoriteElement = favoriteElement;
                            resultCount = -1;
                        }
                    }
                    for (int i2 = 0; i2 < elements.size(); ++i2) {
                        PsiElement element2 = (PsiElement)elements.get(i2);
                        ProgressManager.checkCanceled();
                        if (element2 == favoriteElement) continue;
                        element2.accept(context2.visitor);
                        if (resultCount == -1 || holder.getResultCount() == resultCount) continue;
                        context2.myFavoriteElement = element2;
                        resultCount = -1;
                    }
                    afterProcessCallback.accept(context2);
                })) {
                    throw new ProcessCanceledException();
                }
            };
            if (shouldFailFastAcquiringReadAction) {
                application.executeByImpatientReader(runnable2);
            } else {
                runnable2.run();
            }
            this.advanceProgress(1L);
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 16: 
            case 28: 
            case 52: 
            case 53: 
            case 105: 
            case 113: 
            case 119: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 16: 
            case 28: 
            case 52: 
            case 53: 
            case 105: 
            case 113: 
            case 119: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 4: 
            case 16: 
            case 28: 
            case 52: 
            case 53: 
            case 105: 
            case 113: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 14: 
            case 19: 
            case 23: 
            case 39: 
            case 49: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 9: 
            case 29: 
            case 38: 
            case 74: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 10: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 21: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 22: 
            case 50: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 24: 
            case 36: 
            case 40: 
            case 42: 
            case 48: 
            case 62: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 27: 
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "TOMB_STONE";
                break;
            }
            case 30: 
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterProcessCallback";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyVisitedInjected";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 58: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolID";
                break;
            }
            case 60: 
            case 76: 
            case 85: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 61: 
            case 65: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 68: 
            case 69: 
            case 78: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 70: 
            case 79: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyActionRegistered";
                break;
            }
            case 71: 
            case 80: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ilManager";
                break;
            }
            case 73: 
            case 82: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRange";
                break;
            }
            case 75: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 77: 
            case 86: 
            case 87: 
            case 93: 
            case 97: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 96: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialects";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createInjectedFileSet";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPriorityElementsAndInit";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectInjectedPsi";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 16: 
            case 28: 
            case 52: 
            case 53: 
            case 105: 
            case 113: 
            case 119: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doInspectInBatch";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorsFromInjectedResultsInBatch";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportStatsToQodana";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "highlightRedundantSuppressions";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitPriorityElementsAndInit";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "oldRunToolOnElements";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processInOrder";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitRestElementsAndCleanup";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "inspectInjectedPsi";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "highlightInfoFromDescriptor";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorIncrementally";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptors";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "appendResult";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addHighlightsFromResults";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightsForDescriptor";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "registerSuppressedElements";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "injectToHost";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFileInBaseLanguage";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "showToolDescription";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFixes";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getElementsAndDialectsFrom";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "appendDialects";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableLocalTool";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "doInspectInjectedPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 16: 
            case 28: 
            case 52: 
            case 53: 
            case 105: 
            case 113: 
            case 119: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class InspectionProblemsHolder
    extends ProblemsHolder {
        @NotNull
        private final LocalInspectionToolWrapper myToolWrapper;
        @NotNull
        private final ProgressIndicator myIndicator;
        private volatile boolean applyIncrementally;
        long errorStamp;
        long warningStamp;
        long otherStamp;
        final long initTimeStamp;
        volatile long finishTimeStamp;

        InspectionProblemsHolder(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull PsiFile file2, InspectionManager iManager, @NotNull boolean isOnTheFly, ProgressIndicator indicator2) {
            if (toolWrapper == null) {
                InspectionProblemsHolder.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                InspectionProblemsHolder.$$$reportNull$$$0(1);
            }
            if (iManager == null) {
                InspectionProblemsHolder.$$$reportNull$$$0(2);
            }
            if (indicator2 == null) {
                InspectionProblemsHolder.$$$reportNull$$$0(3);
            }
            super(iManager, file2, isOnTheFly);
            this.applyIncrementally = true;
            this.initTimeStamp = System.nanoTime();
            this.myToolWrapper = toolWrapper;
            this.myIndicator = indicator2;
        }

        public void registerProblem(@NotNull ProblemDescriptor descriptor2) {
            HighlightSeverity severity;
            if (descriptor2 == null) {
                InspectionProblemsHolder.$$$reportNull$$$0(4);
            }
            super.registerProblem(descriptor2);
            if (this.applyIncrementally) {
                LocalInspectionsPass.this.addDescriptorIncrementally(descriptor2, this.myToolWrapper, this.myIndicator);
            }
            if ((severity = LocalInspectionsPass.this.myProfileWrapper.getErrorLevel(this.myToolWrapper.getDisplayKey(), (PsiElement)this.getFile()).getSeverity()).compareTo(HighlightSeverity.ERROR) >= 0) {
                if (this.errorStamp == 0L) {
                    this.errorStamp = System.nanoTime();
                }
            } else if (severity.compareTo(HighlightSeverity.WARNING) >= 0) {
                if (this.warningStamp == 0L) {
                    this.warningStamp = System.nanoTime();
                }
            } else if (this.otherStamp == 0L) {
                this.otherStamp = System.nanoTime();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionProblemsHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InspectionHighlightInfoType
    extends HighlightInfoType.HighlightInfoTypeImpl {
        InspectionHighlightInfoType(@NotNull HighlightInfoType level, @NotNull PsiElement element2) {
            if (level == null) {
                InspectionHighlightInfoType.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                InspectionHighlightInfoType.$$$reportNull$$$0(1);
            }
            super(level.getSeverity(element2), level.getAttributesKey());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionHighlightInfoType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InspectionContext {
        @NotNull
        final LocalInspectionToolWrapper tool;
        @NotNull
        final InspectionProblemsHolder holder;
        volatile int problemsSizeAfterInsideElementsProcessed;
        @NotNull
        final PsiElementVisitor visitor;
        volatile PsiElement myFavoriteElement;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull InspectionProblemsHolder holder, @NotNull PsiElementVisitor visitor) {
            if (tool == null) {
                InspectionContext.$$$reportNull$$$0(0);
            }
            if (visitor == null) {
                InspectionContext.$$$reportNull$$$0(1);
            }
            if (holder == null) {
                InspectionContext.$$$reportNull$$$0(2);
            }
            this.tool = tool;
            this.holder = holder;
            this.visitor = visitor;
        }

        @NotNull
        static InspectionContext createTombStone(@NotNull LocalInspectionsPass pass2) {
            if (pass2 == null) {
                InspectionContext.$$$reportNull$$$0(3);
            }
            LocalInspectionToolWrapper tool = new LocalInspectionToolWrapper(new LocalInspectionEP());
            LocalInspectionsPass localInspectionsPass = pass2;
            Objects.requireNonNull(localInspectionsPass);
            InspectionProblemsHolder holder = localInspectionsPass.new InspectionProblemsHolder(tool, pass2.getFile(), InspectionManager.getInstance((Project)pass2.getFile().getProject()), false, (ProgressIndicator)new EmptyProgressIndicator());
            return new InspectionContext(tool, holder, new PsiElementVisitor(){});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTombStone";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InspectionResult {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final List<? extends ProblemDescriptor> foundProblems;

        private InspectionResult(@NotNull LocalInspectionToolWrapper tool, @NotNull List<? extends ProblemDescriptor> foundProblems) {
            if (tool == null) {
                InspectionResult.$$$reportNull$$$0(0);
            }
            if (foundProblems == null) {
                InspectionResult.$$$reportNull$$$0(1);
            }
            this.tool = tool;
            this.foundProblems = new ArrayList<ProblemDescriptor>(foundProblems);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foundProblems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

