/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.find.FindUtil;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.usages.UsageView;
import com.intellij.util.Consumer;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementListNavigator {
    private PsiElementListNavigator() {
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull MouseEvent e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title2, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer) {
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(0);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(1);
        }
        PsiElementListNavigator.openTargets((MouseEvent)e, targets2, (String)title2, (String)findUsagesTitle, listRenderer, null);
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull MouseEvent e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title2, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2;
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(2);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(3);
        }
        if ((popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title2, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask)) != null) {
            RelativePoint point = new RelativePoint(e);
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.show(point), listUpdaterTask);
            } else {
                popup2.show(point);
            }
        }
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull Editor e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title2, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer) {
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(4);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(5);
        }
        PsiElementListNavigator.openTargets((Editor)e, targets2, (String)title2, (String)findUsagesTitle, listRenderer, null);
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull Editor e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title2, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2;
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(6);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(7);
        }
        if ((popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title2, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask)) != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.showInBestPositionFor(e), listUpdaterTask);
            } else {
                popup2.showInBestPositionFor(e);
            }
        }
    }

    private static void runActionAndListUpdaterTask(@NotNull Runnable action2, @NotNull BackgroundUpdaterTask listUpdaterTask) {
        if (action2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(8);
        }
        if (listUpdaterTask == null) {
            PsiElementListNavigator.$$$reportNull$$$0(9);
        }
        action2.run();
        ProgressManager.getInstance().run((Task)listUpdaterTask);
    }

    @Nullable
    public static <T extends NavigatablePsiElement> JBPopup navigateOrCreatePopup(T @NotNull [] targets2, @NlsContexts.PopupTitle String title2, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(10);
        }
        return PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title2, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask, selectedElements -> {
            for (NavigatablePsiElement selected2 : selectedElements) {
                if (!selected2.isValid()) continue;
                selected2.navigate(true);
            }
        });
    }

    @Nullable
    public static <T extends NavigatablePsiElement> JBPopup navigateOrCreatePopup(T @NotNull [] targets2, @NlsContexts.PopupTitle String title2, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask, @NotNull Consumer<? super T[]> consumer2) {
        if (consumer2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(11);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(12);
        }
        return new NavigateOrPopupHelper(targets2, title2).setFindUsagesTitle(findUsagesTitle).setListRenderer(listRenderer).setListUpdaterTask(listUpdaterTask).setTargetsConsumer(consumer2).navigateOrCreatePopup();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listUpdaterTask";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openTargets";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runActionAndListUpdaterTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateOrCreatePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NavigateOrPopupHelper<T extends NavigatablePsiElement> {
        private final T @NotNull [] myTargets;
        private final @NlsContexts.PopupTitle String myTitle;
        private Consumer<? super T[]> myTargetsConsumer;
        @Nullable
        @NlsContexts.TabTitle
        private String myFindUsagesTitle;
        @Nullable
        private ListCellRenderer<? super T> myListRenderer;
        @Nullable
        private BackgroundUpdaterTask myListUpdaterTask;
        @Nullable
        private Project myProject;

        public NavigateOrPopupHelper(T @NotNull [] targets2, @NlsContexts.PopupTitle String title2) {
            if (targets2 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(0);
            }
            this.myTargets = targets2;
            this.myTitle = title2;
            this.myTargetsConsumer = selectedElements -> {
                for (NavigatablePsiElement element2 : selectedElements) {
                    if (!element2.isValid()) continue;
                    element2.navigate(true);
                }
            };
        }

        @NotNull
        public NavigateOrPopupHelper<T> setFindUsagesTitle(@Nullable @NlsContexts.TabTitle String findUsagesTitle) {
            this.myFindUsagesTitle = findUsagesTitle;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(1);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setListRenderer(@Nullable ListCellRenderer<? super T> listRenderer) {
            this.myListRenderer = listRenderer;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(2);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setListUpdaterTask(@Nullable BackgroundUpdaterTask listUpdaterTask) {
            this.myListUpdaterTask = listUpdaterTask;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(3);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setTargetsConsumer(@NotNull Consumer<? super T[]> targetsConsumer) {
            if (targetsConsumer == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(4);
            }
            this.myTargetsConsumer = targetsConsumer;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(5);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setProject(@Nullable Project project) {
            this.myProject = project;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(6);
            }
            return navigateOrPopupHelper;
        }

        @Nullable
        public final JBPopup navigateOrCreatePopup() {
            if (this.myTargets.length == 0) {
                if (!this.allowEmptyTargets()) {
                    return null;
                }
                if (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished()) {
                    return null;
                }
            }
            if (this.myTargets.length == 1 && (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished())) {
                this.myTargetsConsumer.consume(this.myTargets);
                return null;
            }
            List<T> initialTargetsList = Arrays.asList(this.myTargets);
            final Ref updatedTargetsList = Ref.create(this.myTargets);
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(initialTargetsList);
            this.afterPopupBuilderCreated(builder2);
            if (this.myListRenderer instanceof PsiElementListCellRenderer) {
                ((PsiElementListCellRenderer)this.myListRenderer).installSpeedSearch(builder2, true);
            }
            IPopupChooserBuilder popupChooserBuilder = builder2.setTitle(this.myTitle).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer(this.myListRenderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(elements -> this.myTargetsConsumer.consume((Object)elements.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY))).setCancelCallback(() -> {
                if (this.myListUpdaterTask != null) {
                    this.myListUpdaterTask.cancelTask();
                }
                return true;
            });
            Ref usageView = new Ref();
            if (this.myFindUsagesTitle != null) {
                popupChooserBuilder = popupChooserBuilder.setCouldPin(popup2 -> {
                    usageView.set((Object)FindUtil.showInUsageView(null, (PsiElement[])updatedTargetsList.get(), this.myFindUsagesTitle, this.getProject()));
                    popup2.cancel();
                    return false;
                });
            }
            JBPopup popup3 = popupChooserBuilder.createPopup();
            if (builder2 instanceof PopupChooserBuilder) {
                final JBList list2 = (JBList)((PopupChooserBuilder)builder2).getChooserComponent();
                list2.setTransferHandler(new TransferHandler(){

                    @Override
                    protected Transferable createTransferable(JComponent c) {
                        Object[] selectedValues = list2.getSelectedValues();
                        PsiElement[] copy2 = new PsiElement[selectedValues.length];
                        for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                            copy2[i2] = (PsiElement)selectedValues[i2];
                        }
                        return new PsiCopyPasteManager.MyTransferable(copy2);
                    }

                    @Override
                    public int getSourceActions(JComponent c) {
                        return 1;
                    }
                });
                JScrollPane pane2 = ((PopupChooserBuilder)builder2).getScrollPane();
                pane2.setBorder(null);
                pane2.setViewportBorder(null);
            }
            if (this.myListUpdaterTask != null) {
                final ListComponentUpdater popupUpdater = builder2.getBackgroundUpdater();
                this.myListUpdaterTask.init(popup3, new ListComponentUpdater(){

                    public void replaceModel(@NotNull List<? extends PsiElement> data2) {
                        if (data2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        updatedTargetsList.set((Object)data2.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY));
                        popupUpdater.replaceModel(data2);
                    }

                    public void paintBusy(boolean paintBusy) {
                        popupUpdater.paintBusy(paintBusy);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper$2", "replaceModel"));
                    }
                }, (Ref<? extends UsageView>)((Ref<UsageView>)usageView));
            }
            return popup3;
        }

        @NotNull
        private Project getProject() {
            if (this.myProject != null) {
                Project project = this.myProject;
                if (project == null) {
                    NavigateOrPopupHelper.$$$reportNull$$$0(7);
                }
                return project;
            }
            assert (!this.allowEmptyTargets()) : "Project was not set and cannot be taken from targets";
            Project project = this.myTargets[0].getProject();
            if (project == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(8);
            }
            return project;
        }

        protected boolean allowEmptyTargets() {
            return false;
        }

        protected void afterPopupBuilderCreated(@NotNull IPopupChooserBuilder<T> builder2) {
            if (builder2 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetsConsumer";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFindUsagesTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setListRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setListUpdaterTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTargetsConsumer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setProject";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTargetsConsumer";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "afterPopupBuilderCreated";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

