/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class VisibleHighlightingPassFactory {
    public static Key<ProperTextRange> HEADLESS_VISIBLE_AREA = Key.create((String)"Editor.headlessVisibleArea");

    @NotNull
    public static ProperTextRange calculateVisibleRange(@NotNull Document document) {
        if (document == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        ProperTextRange textRange = (ProperTextRange)document.getUserData(HEADLESS_VISIBLE_AREA);
        ProperTextRange entireTextRange = new ProperTextRange(0, document.getTextLength());
        if (textRange != null && entireTextRange.contains((TextRange)textRange)) {
            ProperTextRange properTextRange = textRange;
            if (properTextRange == null) {
                VisibleHighlightingPassFactory.$$$reportNull$$$0(1);
            }
            return properTextRange;
        }
        ProperTextRange properTextRange = entireTextRange;
        if (properTextRange == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        return properTextRange;
    }

    @NotNull
    public static ProperTextRange calculateVisibleRange(@NotNull Editor editor2) {
        if (editor2 == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ProperTextRange textRange = (ProperTextRange)editor2.getUserData(HEADLESS_VISIBLE_AREA);
            ProperTextRange entireTextRange = new ProperTextRange(0, editor2.getDocument().getTextLength());
            if (textRange != null && entireTextRange.contains((TextRange)textRange)) {
                ProperTextRange properTextRange = textRange;
                if (properTextRange == null) {
                    VisibleHighlightingPassFactory.$$$reportNull$$$0(4);
                }
                return properTextRange;
            }
            ProperTextRange properTextRange = entireTextRange;
            if (properTextRange == null) {
                VisibleHighlightingPassFactory.$$$reportNull$$$0(5);
            }
            return properTextRange;
        }
        Rectangle rect = editor2.getScrollingModel().getVisibleArea();
        LogicalPosition startPosition = editor2.xyToLogicalPosition(new Point(rect.x, rect.y));
        int visibleStart = editor2.logicalPositionToOffset(startPosition);
        LogicalPosition endPosition = editor2.xyToLogicalPosition(new Point(rect.x + rect.width, rect.y + rect.height));
        int visibleEnd = editor2.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
        return new ProperTextRange(visibleStart, Math.max(visibleEnd, visibleStart));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateVisibleRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateVisibleRange";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

