/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBatchSuppressByNoInspectionCommentFix
implements ContainerBasedSuppressQuickFix,
InjectionAwareSuppressQuickFix,
Iconable {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;
    private ThreeState myShouldBeAppliedToInjectionHost;
    @IntentionName
    private String myText;

    @Nullable
    public abstract PsiElement getContainer(PsiElement var1);

    public AbstractBatchSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        if (ID2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(0);
        }
        this.myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;
        this.myText = "";
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
        if (shouldBeAppliedToInjectionHost == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(1);
        }
        this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
    }

    @NotNull
    public ThreeState isShouldBeAppliedToInjectionHost() {
        ThreeState threeState = this.myShouldBeAppliedToInjectionHost;
        if (threeState == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(2);
        }
        return threeState;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Ide.HectorOff;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void setText(@IntentionName @NotNull String text2) {
        if (text2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(5);
        }
        this.myText = text2;
    }

    public String toString() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element2;
        if (project == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(7);
        }
        if ((element2 = descriptor2.getStartElement()) == null) {
            return;
        }
        this.invoke(project, element2);
    }

    public boolean isSuppressAll() {
        return "ALL".equalsIgnoreCase(this.myID);
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (comment == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(8);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{comment})) {
            return;
        }
        WriteAction.run(() -> SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment)));
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element2, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(10);
        }
        if (container == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(11);
        }
        SuppressionUtil.createSuppression(project, container, this.myID, this.getCommentLanguage(element2));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(12);
        }
        Language language2 = element2.getLanguage();
        if (language2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(13);
        }
        return language2;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context2) {
        if (project == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(15);
        }
        return context2.isValid() && this.getContainer(context2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(16);
        }
        if (element2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(17);
        }
        if (!this.isAvailable(project, element2)) {
            return;
        }
        PsiElement container = this.getContainer(element2);
        PsiFile file2 = element2.getContainingFile();
        if (container == null) {
            return;
        }
        if (this.replaceSuppressionComments(container)) {
            return;
        }
        this.createSuppression(project, element2, container);
        UndoUtil.markPsiFileForUndo((PsiFile)file2);
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        List<? extends PsiElement> comments = this.getCommentsFor(container);
        if (comments != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                this.replaceSuppressionComment(psiElement);
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        PsiElement prev2;
        if (container == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(18);
        }
        if ((prev2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)container)) == null) {
            return null;
        }
        return Collections.singletonList(prev2);
    }

    @NotNull
    public String getFamilyName() {
        String text2 = this.getText();
        String string = StringUtil.isEmpty((String)text2) ? AnalysisBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]) : text2;
        if (string == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldBeAppliedToInjectionHost";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "isShouldBeAppliedToInjectionHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setShouldBeAppliedToInjectionHost";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceSuppressionComment";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommentLanguage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

