/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FixAllHighlightingProblems
implements IntentionAction {
    private final IntentionActionWithFixAllOption myAction;

    public FixAllHighlightingProblems(IntentionActionWithFixAllOption action2) {
        this.myAction = action2;
    }

    @NotNull
    public String getText() {
        String string = AnalysisBundle.message((String)"intention.name.apply.all.fixes.in.file", (Object[])new Object[]{this.myAction.getFamilyName()});
        if (string == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AnalysisBundle.message((String)"intention.family.name.fix.all.problems.like.this", (Object[])new Object[0]);
        if (string == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(3);
        }
        ArrayList actions2 = new ArrayList();
        Document document = editor2.getDocument();
        Processor processor2 = info2 -> {
            IntentionAction fix2 = info2.getSameFamilyFix(this.myAction);
            if (fix2 != null) {
                TextRange range2 = TextRange.create((int)info2.getActualStartOffset(), (int)info2.getActualEndOffset());
                SmartPsiFileRange pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file2, range2);
                actions2.add(Pair.create((Object)fix2, (Object)pointer));
            }
            return true;
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)processor2)), AnalysisBundle.message((String)"command.name.gather.fixes", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (actions2.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        Collections.reverse(actions2);
        ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(this.myAction.getFamilyName(), project, null, indicator2 -> {
            indicator2.setIndeterminate(false);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            for (int i2 = 0; i2 < actions2.size(); ++i2) {
                indicator2.setFraction((double)i2 / (double)actions2.size());
                Pair pair = (Pair)actions2.get(i2);
                IntentionAction action2 = (IntentionAction)pair.getFirst();
                Segment range2 = ((SmartPsiFileRange)pair.getSecond()).getRange();
                if (range2 == null) continue;
                editor2.getCaretModel().moveToOffset(range2.getStartOffset());
                if (!action2.isAvailable(project, editor2, file2)) continue;
                action2.invoke(project, editor2, file2);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                psiDocumentManager.commitDocument(document);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

