/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingColors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.awt.Color;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class XmlTagTreeHighlightingUtil {
    private XmlTagTreeHighlightingUtil() {
    }

    static boolean containsTagsWithSameName(PsiElement[] elements) {
        HashSet<String> names2 = new HashSet<String>();
        for (PsiElement element2 : elements) {
            String name2;
            if (!(element2 instanceof XmlTag) || names2.add(name2 = ((XmlTag)element2).getName())) continue;
            return true;
        }
        return false;
    }

    static boolean isTagTreeHighlightingActive(PsiFile file2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!XmlTagTreeHighlightingUtil.hasXmlViewProvider(file2) && !HtmlUtil.supportsXmlTypedHandlers(file2)) {
            return false;
        }
        return WebEditorOptions.getInstance().isTagTreeHighlightingEnabled();
    }

    public static boolean hasXmlViewProvider(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlTagTreeHighlightingUtil.$$$reportNull$$$0(0);
        }
        for (PsiFile f : file2.getViewProvider().getAllFiles()) {
            if (!(f instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    static Color[] getBaseColors() {
        ColorKey[] colorKeys = XmlTagTreeHighlightingColors.getColorKeys();
        Color[] colors = new Color[colorKeys.length];
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (int i2 = 0; i2 < colors.length; ++i2) {
            colors[i2] = colorsScheme.getColor(colorKeys[i2]);
        }
        return colors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingUtil", "hasXmlViewProvider"));
    }
}

