/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

@Service
public final class DocRenderItemUpdater
implements Runnable {
    private static final long MAX_UPDATE_DURATION_MS = 50L;
    private final Map<RenderedElement, Boolean> myQueue = new HashMap<RenderedElement, Boolean>();

    static DocRenderItemUpdater getInstance() {
        return (DocRenderItemUpdater)ApplicationManager.getApplication().getService(DocRenderItemUpdater.class);
    }

    void updateFoldRegions(@NotNull Collection<CustomFoldRegion> foldRegions, boolean recreateContent) {
        if (foldRegions == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(0);
        }
        if (foldRegions.isEmpty()) {
            return;
        }
        boolean wasEmpty = this.myQueue.isEmpty();
        for (CustomFoldRegion foldRegion : foldRegions) {
            this.myQueue.merge(new FoldRegionWrapper(foldRegion), recreateContent, Boolean::logicalOr);
        }
        if (wasEmpty) {
            this.processChunk();
        }
    }

    void updateInlays(@NotNull Collection<Inlay<DocRenderer>> inlays, boolean recreateContent) {
        if (inlays == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(1);
        }
        if (inlays.isEmpty()) {
            return;
        }
        boolean wasEmpty = this.myQueue.isEmpty();
        for (Inlay<DocRenderer> inlay : inlays) {
            this.myQueue.merge(new InlayWrapper(inlay), recreateContent, Boolean::logicalOr);
        }
        if (wasEmpty) {
            this.processChunk();
        }
    }

    @Override
    public void run() {
        this.processChunk();
    }

    private void processChunk() {
        long deadline = System.currentTimeMillis() + 50L;
        HashMap<Editor, EditorScrollingPositionKeeper> keepers = new HashMap<Editor, EditorScrollingPositionKeeper>();
        ArrayList<RenderedElement> toProcess = new ArrayList<RenderedElement>(this.myQueue.keySet());
        Object2IntOpenHashMap memoMap = new Object2IntOpenHashMap();
        toProcess.sort(Comparator.comparingInt(arg_0 -> DocRenderItemUpdater.lambda$processChunk$0((Object2IntMap)memoMap, arg_0)));
        do {
            RenderedElement element2 = (RenderedElement)toProcess.remove(toProcess.size() - 1);
            boolean updateContent2 = this.myQueue.remove(element2);
            if (!element2.isValid()) continue;
            Editor editor2 = element2.getEditor();
            keepers.computeIfAbsent(editor2, e -> {
                EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor2);
                keeper.savePosition();
                return keeper;
            });
            element2.getRenderer().update(true, updateContent2, null);
        } while (!toProcess.isEmpty() && System.currentTimeMillis() < deadline);
        keepers.values().forEach(k -> k.restorePosition(false));
        if (!this.myQueue.isEmpty()) {
            SwingUtilities.invokeLater(this);
        }
    }

    private static int getVisibleOffset(Editor editor2, Object2IntMap<Editor> memoMap) {
        return memoMap.computeIntIfAbsent((Object)editor2, e -> {
            Rectangle visibleArea = e.getScrollingModel().getVisibleAreaOnScrollingFinished();
            if (editor2.isDisposed() || visibleArea.height <= 0) {
                return e.getCaretModel().getOffset();
            }
            int y = visibleArea.y + visibleArea.height / 2;
            int visualLine = e.yToVisualLine(y);
            return e.visualPositionToOffset(new VisualPosition(visualLine, 0));
        });
    }

    private static /* synthetic */ int lambda$processChunk$0(Object2IntMap memoMap, RenderedElement i2) {
        return -Math.abs(i2.getOffset() - DocRenderItemUpdater.getVisibleOffset(i2.getEditor(), (Object2IntMap<Editor>)memoMap));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlays";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItemUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFoldRegions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInlays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FoldRegionWrapper
    implements RenderedElement {
        private final CustomFoldRegion myFoldRegion;

        private FoldRegionWrapper(CustomFoldRegion region) {
            this.myFoldRegion = region;
        }

        @Override
        public Editor getEditor() {
            return this.myFoldRegion.getEditor();
        }

        @Override
        public int getOffset() {
            return this.myFoldRegion.getStartOffset();
        }

        @Override
        public boolean isValid() {
            return this.myFoldRegion.isValid();
        }

        @Override
        public DocRenderer getRenderer() {
            return (DocRenderer)this.myFoldRegion.getRenderer();
        }
    }

    private static class InlayWrapper
    implements RenderedElement {
        private final Inlay<DocRenderer> myInlay;

        private InlayWrapper(Inlay<DocRenderer> inlay) {
            this.myInlay = inlay;
        }

        @Override
        public Editor getEditor() {
            return this.myInlay.getEditor();
        }

        @Override
        public int getOffset() {
            return this.myInlay.getOffset();
        }

        @Override
        public boolean isValid() {
            return this.myInlay.isValid();
        }

        @Override
        public DocRenderer getRenderer() {
            return (DocRenderer)this.myInlay.getRenderer();
        }
    }

    private static interface RenderedElement {
        public Editor getEditor();

        public int getOffset();

        public boolean isValid();

        public DocRenderer getRenderer();
    }
}

