/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler.ForEachCaret {
    private static final Logger LOGGER = Logger.getInstance(BackspaceHandler.class);
    protected final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            BackspaceHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            BackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!this.handleBackspace(editor2, caret, dataContext, false)) {
            this.myOriginalHandler.execute(editor2, caret, dataContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleBackspace(Editor editor2, Caret caret, DataContext dataContext, boolean toWordStart) {
        HighlighterIterator iterator2;
        int injectedOffset;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        if (file2 == null) {
            return false;
        }
        if (editor2.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = DocumentUtil.getPreviousCodePointOffset(editor2.getDocument(), editor2.getCaretModel().getOffset());
        if (offset < 0) {
            return false;
        }
        CharSequence chars = editor2.getDocument().getCharsSequence();
        int c = Character.codePointAt(chars, offset);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c, editor2, file2);
        Editor originalEditor = editor2;
        if (injectedEditor != editor2 && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(injectedEditor.getDocument());
            editor2 = injectedEditor;
            offset = DocumentUtil.getPreviousCodePointOffset(injectedEditor.getDocument(), injectedOffset);
        }
        List delegates = BackspaceHandlerDelegate.EP_NAME.getExtensionList();
        if (!toWordStart && Character.isBmpCodePoint(c)) {
            for (BackspaceHandlerDelegate delegate2 : delegates) {
                delegate2.beforeCharDeleted((char)c, file2, editor2);
            }
        }
        FileType fileType = file2.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor2);
        HighlighterIterator hiterator = editor2.getHighlighter().createIterator(offset);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset);
        this.myOriginalHandler.execute(originalEditor, caret, dataContext);
        if (!toWordStart && Character.isBmpCodePoint(c)) {
            try {
                for (BackspaceHandlerDelegate delegate3 : delegates) {
                    if (!delegate3.charDeleted((char)c, file2, editor2)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                BackspaceHandler.deleteCustomFoldRegionIfNeeded(caret);
            }
        }
        if (offset >= editor2.getDocument().getTextLength()) {
            return true;
        }
        chars = editor2.getDocument().getCharsSequence();
        if ((c == 40 || c == 91 || c == 123) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            boolean matched;
            char c1 = chars.charAt(offset);
            if (c1 != BackspaceHandler.getRightChar((char)c)) {
                return true;
            }
            iterator2 = editor2.getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            if (!braceMatcher.isLBraceToken(iterator2, chars, fileType) && !braceMatcher.isRBraceToken(iterator2, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator2, iterator2.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator2 = editor2.getHighlighter().createIterator(rparenOffset), false, true))) {
                return true;
            }
            editor2.getDocument().deleteString(offset, offset + 1);
        } else if ((c == 34 || c == 39 || c == 96) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            char c1 = chars.charAt(offset);
            if (c1 != c) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            iterator2 = editor2.getHighlighter().createIterator(offset);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator2, offset)) {
                return true;
            }
            editor2.getDocument().deleteString(offset, offset + 1);
        }
        return true;
    }

    private static void deleteCustomFoldRegionIfNeeded(Caret caret) {
        int caretOffset = caret.getOffset();
        Editor editor2 = caret.getEditor();
        FoldRegion foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(caretOffset - 1);
        if (foldRegion instanceof CustomFoldRegion && foldRegion.getEndOffset() == caretOffset) {
            editor2.getDocument().deleteString(foldRegion.getStartOffset(), foldRegion.getEndOffset());
        }
    }

    public static char getRightChar(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        assert (false);
        return c;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        List editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset + 1));
        return editables.size() == 1 && ((TextRange)editables.get(0)).equals((Object)rangeToEdit);
    }

    @NotNull
    static Language getLanguageAtCursorPosition(PsiFile file2, Editor editor2) {
        Language language2;
        if (file2 instanceof PsiFileWithOneLanguage) {
            Language language3 = file2.getLanguage();
            if (language3 == null) {
                BackspaceHandler.$$$reportNull$$$0(2);
            }
            return language3;
        }
        PsiElement element2 = file2.findElementAt(editor2.getCaretModel().getOffset());
        Language language4 = language2 = element2 != null ? PsiUtilCore.findLanguageFromElement((PsiElement)element2) : Language.ANY;
        if (language2 != Language.ANY) {
            Language language5 = language2;
            if (language5 == null) {
                BackspaceHandler.$$$reportNull$$$0(3);
            }
            return language5;
        }
        Language language6 = file2.getLanguage();
        if (language6 == null) {
            BackspaceHandler.$$$reportNull$$$0(4);
        }
        return language6;
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file2, Editor editor2) {
        Language language2;
        if (editor2.getSelectionModel().hasSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor2.getCaretModel().getLogicalPosition();
        if (caretPos.column == 0) {
            return null;
        }
        if (!BackspaceHandler.isWhitespaceBeforeCaret(editor2)) {
            return null;
        }
        CommonCodeStyleSettings.IndentOptions fileIndentOptions = CodeStyle.getIndentOptions((PsiFile)file2);
        int indent = fileIndentOptions.INDENT_SIZE;
        if (!fileIndentOptions.isOverrideLanguageOptions() && (language2 = BackspaceHandler.getLanguageAtCursorPosition(file2, editor2)) != file2.getLanguage()) {
            indent = CodeStyle.getSettings((PsiFile)file2).getLanguageIndentOptions((Language)language2).INDENT_SIZE;
        }
        int column2 = indent > 0 ? (caretPos.column - 1) / indent * indent : 0;
        return new LogicalPosition(caretPos.line, column2);
    }

    public static void deleteToTargetPosition(@NotNull Editor editor2, @NotNull LogicalPosition pos) {
        if (editor2 == null) {
            BackspaceHandler.$$$reportNull$$$0(5);
        }
        if (pos == null) {
            BackspaceHandler.$$$reportNull$$$0(6);
        }
        LogicalPosition logicalPosition = editor2.getCaretModel().getLogicalPosition();
        if (logicalPosition.line != pos.line) {
            LOGGER.error("Unexpected caret position: " + logicalPosition + ", target indent position: " + pos);
            return;
        }
        if (pos.column < logicalPosition.column) {
            int targetOffset = editor2.logicalPositionToOffset(pos);
            int offset = editor2.getCaretModel().getOffset();
            editor2.getCaretModel().getCurrentCaret().setSelection(targetOffset, offset, false);
            EditorModificationUtilEx.deleteSelectedText((Editor)editor2);
            editor2.getCaretModel().moveToLogicalPosition(pos);
        } else if (pos.column > logicalPosition.column) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)StringUtil.repeatSymbol((char)' ', (int)(pos.column - logicalPosition.column)));
        }
    }

    public static boolean isWhitespaceBeforeCaret(Editor editor2) {
        LogicalPosition caretPos = editor2.getCaretModel().getLogicalPosition();
        CharSequence charSeq = editor2.getDocument().getCharsSequence();
        for (int pos = 0; pos < caretPos.column; ++pos) {
            char c;
            LogicalPosition checkPos = new LogicalPosition(caretPos.line, pos);
            int offset = editor2.logicalPositionToOffset(checkPos);
            if (offset >= charSeq.length() || (c = charSeq.charAt(offset)) == '\t' || c == ' ' || c == '\n') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/BackspaceHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/BackspaceHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageAtCursorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteToTargetPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

