/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class MatchBraceAction
extends EditorAction {
    public MatchBraceAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static void moveCaret(Editor editor2, Caret caret, int offset) {
        caret.removeSelection();
        caret.moveToOffset(offset);
        EditorModificationUtil.scrollToCaret((Editor)editor2);
    }

    private static class MyHandler
    extends EditorActionHandler.ForEachCaret {
        private MyHandler() {
        }

        public void doExecute(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            PsiFile file2;
            if (editor2 == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if ((file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) == null) {
                return;
            }
            int targetOffset = MyHandler.getClosestTargetOffset(editor2, file2);
            if (targetOffset > -1) {
                MatchBraceAction.moveCaret(editor2, editor2.getCaretModel().getCurrentCaret(), targetOffset);
            }
        }

        private static int getClosestTargetOffset(@NotNull Editor editor2, @NotNull PsiFile file2) {
            int caretOffset;
            if (editor2 == null) {
                MyHandler.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                MyHandler.$$$reportNull$$$0(3);
            }
            int offsetFromBraceMatcher = MyHandler.getOffsetFromBraceMatcher(editor2, file2);
            TextRange rangeFromCodeBlockSupport = CodeBlockSupportHandler.findCodeBlockRange(editor2, file2);
            if (rangeFromCodeBlockSupport.isEmpty() || rangeFromCodeBlockSupport.contains(offsetFromBraceMatcher)) {
                return offsetFromBraceMatcher;
            }
            EditorHighlighter highlighter = editor2.getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(caretOffset = editor2.getCaretModel().getOffset());
            if (iterator2.atEnd() || iterator2.getEnd() == rangeFromCodeBlockSupport.getEndOffset() || caretOffset > 0 && highlighter.createIterator(caretOffset - 1).getEnd() == rangeFromCodeBlockSupport.getEndOffset()) {
                return rangeFromCodeBlockSupport.getStartOffset();
            }
            return rangeFromCodeBlockSupport.getEndOffset();
        }

        private static int getOffsetFromBraceMatcher(@NotNull Editor editor2, @NotNull PsiFile file2) {
            BraceMatchingUtil.BraceHighlightingAndNavigationContext matchingContext;
            if (editor2 == null) {
                MyHandler.$$$reportNull$$$0(4);
            }
            if (file2 == null) {
                MyHandler.$$$reportNull$$$0(5);
            }
            return (matchingContext = BraceMatchingUtil.computeHighlightingAndNavigationContext(editor2, file2)) != null ? matchingContext.navigationOffset : MyHandler.tryFindPreviousUnclosedOpeningBraceOffset(editor2, file2);
        }

        private static int tryFindPreviousUnclosedOpeningBraceOffset(@NotNull Editor editor2, @NotNull PsiFile file2) {
            FileType fileType;
            if (editor2 == null) {
                MyHandler.$$$reportNull$$$0(6);
            }
            if (file2 == null) {
                MyHandler.$$$reportNull$$$0(7);
            }
            EditorHighlighter highlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor2, file2);
            CharSequence text2 = editor2.getDocument().getCharsSequence();
            HighlighterIterator iterator2 = highlighter.createIterator(editor2.getCaretModel().getOffset());
            FileType fileType2 = fileType = iterator2.atEnd() ? null : PsiUtilBase.getPsiFileAtOffset((PsiFile)file2, (int)iterator2.getStart()).getFileType();
            if (fileType == null) {
                return -1;
            }
            int unopenedBraces = 0;
            while (true) {
                if (BraceMatchingUtil.isRBraceToken(iterator2, text2, fileType)) {
                    ++unopenedBraces;
                } else if (BraceMatchingUtil.isLBraceToken(iterator2, text2, fileType)) {
                    --unopenedBraces;
                }
                if (unopenedBraces < 0) {
                    return iterator2.getStart();
                }
                if (iterator2.getStart() == 0) {
                    return -1;
                }
                iterator2.retreat();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/MatchBraceAction$MyHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getClosestTargetOffset";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffsetFromBraceMatcher";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryFindPreviousUnclosedOpeningBraceOffset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

