/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlSlashTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile editedFile, @NotNull FileType fileType) {
        if (project == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(1);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            XmlTag parentTag;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
            int offset = editor2.getCaretModel().getOffset();
            if (file2 == null) {
                TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
                if (result2 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(4);
                }
                return result2;
            }
            FileViewProvider provider2 = file2.getViewProvider();
            PsiElement element2 = provider2.findElementAt(offset, XMLLanguage.class);
            if (element2 instanceof XmlToken) {
                ASTNode parentNode;
                ASTNode child2;
                IElementType tokenType = ((XmlToken)element2).getTokenType();
                if (tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END && offset == element2.getTextOffset()) {
                    editor2.getCaretModel().moveToOffset(offset + 1);
                    editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
                    if (result3 == null) {
                        XmlSlashTypedHandler.$$$reportNull$$$0(5);
                    }
                    return result3;
                }
                if (tokenType == XmlTokenType.XML_TAG_END && offset == element2.getTextOffset() && (child2 = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentNode = element2.getParent().getNode())) != null && offset + 1 == child2.getTextRange().getStartOffset()) {
                    editor2.getDocument().replaceString(offset + 1, parentNode.getTextRange().getEndOffset(), (CharSequence)"");
                }
            }
            CharSequence contents = provider2.getContents();
            if (offset > 0 && contents.charAt(offset - 1) == '<' && (parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class)) instanceof HtmlTag && element2 == provider2.findElementAt(offset, provider2.getBaseLanguage())) {
                ASTNode closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(parentTag.getNode());
                ASTNode startingTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(parentTag.getNode());
                if (closingTagName != null && startingTagName != null && startingTagName.getStartOffset() < offset) {
                    if (closingTagName.getStartOffset() - 1 != offset) {
                        int nextCharPos = StringUtil.skipWhitespaceForward((CharSequence)contents, (int)offset);
                        if (nextCharPos > 0 && contents.charAt(nextCharPos) == '>') {
                            editor2.getDocument().insertString(offset, (CharSequence)"/");
                        } else {
                            editor2.getDocument().insertString(offset, (CharSequence)"/>");
                        }
                    }
                    editor2.getCaretModel().moveCaretRelatively(1, 0, false, false, false);
                    TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                    if (result4 == null) {
                        XmlSlashTypedHandler.$$$reportNull$$$0(6);
                    }
                    return result4;
                }
            }
        }
        TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
        if (result5 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(7);
        }
        return result5;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile editedFile) {
        if (project == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(9);
        }
        if (editedFile == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(10);
        }
        if (!WebEditorOptions.getInstance().isAutoCloseTag()) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                XmlSlashTypedHandler.$$$reportNull$$$0(11);
            }
            return result2;
        }
        if (c == '/' && XmlGtTypedHandler.fileContainsXmlLanguage(editedFile)) {
            PsiElement element2;
            XmlTag tag2;
            int offset;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
            if (file2 == null) {
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                if (result3 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(12);
                }
                return result3;
            }
            FileViewProvider provider2 = file2.getViewProvider();
            PsiElement element3 = provider2.findElementAt((offset = editor2.getCaretModel().getOffset()) - 1, XMLLanguage.class);
            if (element3 == null) {
                TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.CONTINUE;
                if (result4 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(13);
                }
                return result4;
            }
            if (!(element3.getLanguage() instanceof XMLLanguage)) {
                TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
                if (result5 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(14);
                }
                return result5;
            }
            ASTNode prevLeaf = element3.getNode();
            if (prevLeaf == null) {
                TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                if (result6 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(15);
                }
                return result6;
            }
            String prevLeafText = prevLeaf.getText();
            if ("</".equals(prevLeafText) && prevLeaf.getElementType() == XmlTokenType.XML_END_TAG_START && (tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element3, XmlTag.class)) != null && StringUtil.isNotEmpty((String)tag2.getName()) && TreeUtil.findSibling(prevLeaf, XmlTokenType.XML_NAME) == null && TreeUtil.findSibling(prevLeaf, XmlTokenType.XML_TAG_NAME) == null) {
                PsiElement element1;
                if (provider2 instanceof MultiplePsiFilesPerDocumentFileViewProvider && (element1 = AbstractFileViewProvider.findElementAt((PsiElement)file2, offset - 1)) != null) {
                    XmlTag tag1 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element1, XmlTag.class);
                    if (XmlSlashTypedHandler.shouldReplace(tag2, tag1, offset)) {
                        tag2 = tag1;
                    } else {
                        tag1 = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element1.getParent(), XmlTag.class);
                        if (XmlSlashTypedHandler.shouldReplace(tag2, tag1, offset)) {
                            tag2 = tag1;
                        }
                    }
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)(tag2.getName() + ">"), (boolean)false);
                XmlSlashTypedHandler.autoIndent(editor2);
                TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.STOP;
                if (result7 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(16);
                }
                return result7;
            }
            if (!"/".equals(prevLeafText.trim())) {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.CONTINUE;
                if (result8 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(17);
                }
                return result8;
            }
            while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
            }
            if (prevLeaf instanceof OuterLanguageElement) {
                element3 = file2.getViewProvider().findElementAt(offset - 1, file2.getLanguage());
                ASTNode aSTNode = prevLeaf = element3 != null ? element3.getNode() : null;
                while ((prevLeaf = TreeUtil.prevLeaf(prevLeaf)) != null && prevLeaf.getElementType() == XmlTokenType.XML_WHITE_SPACE) {
                }
            }
            if (prevLeaf == null) {
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.CONTINUE;
                if (result9 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(18);
                }
                return result9;
            }
            tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf.getPsi(), XmlTag.class);
            if (tag2 == null && (tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element2 = provider2.findElementAt(prevLeaf.getStartOffset(), XMLLanguage.class)), XmlTag.class)) == null) {
                TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
                if (result10 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(19);
                }
                return result10;
            }
            XmlToken startToken = XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_START_TAG_START);
            if (startToken == null || !startToken.getText().equals("<")) {
                TypedHandlerDelegate.Result result11 = TypedHandlerDelegate.Result.CONTINUE;
                if (result11 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(20);
                }
                return result11;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_TAG_END) != null) {
                TypedHandlerDelegate.Result result12 = TypedHandlerDelegate.Result.CONTINUE;
                if (result12 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(21);
                }
                return result12;
            }
            if (XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
                TypedHandlerDelegate.Result result13 = TypedHandlerDelegate.Result.CONTINUE;
                if (result13 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(22);
                }
                return result13;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element3, XmlAttributeValue.class) != null) {
                TypedHandlerDelegate.Result result14 = TypedHandlerDelegate.Result.CONTINUE;
                if (result14 == null) {
                    XmlSlashTypedHandler.$$$reportNull$$$0(23);
                }
                return result14;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)">", (boolean)false);
            TypedHandlerDelegate.Result result15 = TypedHandlerDelegate.Result.STOP;
            if (result15 == null) {
                XmlSlashTypedHandler.$$$reportNull$$$0(24);
            }
            return result15;
        }
        TypedHandlerDelegate.Result result16 = TypedHandlerDelegate.Result.CONTINUE;
        if (result16 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(25);
        }
        return result16;
    }

    private static boolean shouldReplace(XmlTag tag2, XmlTag tag1, int offset) {
        if (tag1 == null || tag1 == tag2 || tag1.getTextOffset() <= tag2.getTextOffset()) {
            return false;
        }
        if (XmlSlashTypedHandler.hasUnclosedParent(tag1)) {
            return true;
        }
        if (XmlUtil.getTokenOfType((PsiElement)tag1, XmlTokenType.XML_EMPTY_ELEMENT_END) != null) {
            return false;
        }
        XmlToken element2 = XmlTagUtil.getEndTagNameElement((XmlTag)tag1);
        return element2 != null && element2.getTextOffset() > offset;
    }

    private static boolean hasUnclosedParent(XmlTag tag2) {
        String name2 = tag2.getName();
        while (tag2 != null) {
            if (XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_EMPTY_ELEMENT_END) == null && XmlTagUtil.getEndTagNameElement((XmlTag)tag2) == null && name2.equals(tag2.getName())) {
                return true;
            }
            tag2 = tag2.getParentTag();
        }
        return false;
    }

    public static void autoIndent(@NotNull Editor editor2) {
        Project project;
        if (editor2 == null) {
            XmlSlashTypedHandler.$$$reportNull$$$0(26);
        }
        if ((project = editor2.getProject()) != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = editor2.getDocument();
            documentManager.commitDocument(document);
            int lineOffset = document.getLineStartOffset(document.getLineNumber(editor2.getCaretModel().getOffset()));
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, lineOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/XmlSlashTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "autoIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

