/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CommentUtil;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.CommenterWithLineSuffix;
import com.intellij.codeInsight.generation.EscapingCommenter;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.formatting.IndentData;
import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CustomUncommenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.LightweightHint;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommentByBlockCommentHandler
extends MultiCaretCodeInsightActionHandler {
    private Editor myEditor;
    private Caret myCaret;
    private PsiFile myFile;
    private Language myLanguage;
    private Document myDocument;
    private Commenter myCommenter;
    private CommenterDataHolder mySelfManagedCommenterData;
    private @NlsContexts.HintText String myWarning;
    private RangeMarker myWarningLocation;

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Caret caret, @NotNull PsiFile file2) {
        String suffix;
        String prefix;
        if (project == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(3);
        }
        this.myEditor = editor2;
        this.myCaret = caret;
        this.myFile = file2;
        this.myWarning = null;
        this.myWarningLocation = null;
        this.myDocument = editor2.getDocument();
        this.myLanguage = CommentByBlockCommentHandler.getLanguage(caret, file2);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.comment.block");
        Commenter commenter = CommentByBlockCommentHandler.findCommenter(this.myFile, this.myEditor, caret);
        if (commenter == null) {
            return;
        }
        this.myCommenter = commenter;
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            this.mySelfManagedCommenterData = selfManagingCommenter.createBlockCommentingState(caret.getSelectionStart(), caret.getSelectionEnd(), this.myDocument, this.myFile);
            if (this.mySelfManagedCommenterData == null) {
                this.mySelfManagedCommenterData = SelfManagingCommenter.EMPTY_STATE;
            }
            prefix = selfManagingCommenter.getBlockCommentPrefix(caret.getSelectionStart(), this.myDocument, this.mySelfManagedCommenterData);
            suffix = selfManagingCommenter.getBlockCommentSuffix(caret.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            prefix = commenter.getBlockCommentPrefix();
            suffix = commenter.getBlockCommentSuffix();
        }
        if (prefix == null || suffix == null) {
            return;
        }
        TextRange commentedRange = this.findCommentedRange(commenter);
        if (commentedRange != null) {
            int commentStart = commentedRange.getStartOffset();
            int commentEnd = commentedRange.getEndOffset();
            int selectionStart = commentStart;
            int selectionEnd = commentEnd;
            if (this.myCaret.hasSelection()) {
                selectionStart = this.myCaret.getSelectionStart();
                selectionEnd = this.myCaret.getSelectionEnd();
            }
            if (!(commentStart >= selectionStart && commentStart < selectionEnd || commentEnd > selectionStart && commentEnd <= selectionEnd)) {
                this.commentRange(selectionStart, selectionEnd, prefix, suffix, commenter);
            } else {
                this.uncommentRange(commentedRange, CommentByBlockCommentHandler.trim(prefix), CommentByBlockCommentHandler.trim(suffix), commenter);
            }
        } else {
            if (!this.myCaret.hasSelection()) {
                EditorUtil.fillVirtualSpaceUntilCaret(editor2);
            }
            int selectionStart = this.myCaret.getSelectionStart();
            int selectionEnd = this.myCaret.getSelectionEnd();
            if (commenter.blockCommentRequiresFullLineSelection()) {
                selectionStart = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(selectionStart));
                selectionEnd = this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(selectionEnd));
            } else if (commenter instanceof IndentedCommenter && ((IndentedCommenter)commenter).forceIndentedBlockComment() == Boolean.FALSE) {
                int lineStart = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(selectionStart));
                if (StringUtil.isEmptyOrSpaces((CharSequence)new CharSequenceSubSequence(this.myDocument.getCharsSequence(), lineStart, selectionStart))) {
                    selectionStart = lineStart;
                }
            }
            if (selectionStart == selectionEnd) {
                CommonCodeStyleSettings settings = this.getLanguageSettings();
                int offset = settings.BLOCK_COMMENT_ADD_SPACE ? prefix.length() + 1 : prefix.length();
                String comment = settings.BLOCK_COMMENT_ADD_SPACE ? prefix + "  " + suffix : prefix + suffix;
                this.myDocument.insertString(selectionStart, (CharSequence)comment);
                this.myCaret.moveToOffset(selectionStart + offset);
            } else {
                this.commentRange(selectionStart, selectionEnd, prefix, suffix, commenter);
            }
        }
        this.showMessageIfNeeded();
    }

    @NotNull
    private static Language getLanguage(@NotNull Caret caret, @NotNull PsiFile file2) {
        Language language2;
        if (caret == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(5);
        }
        Language language3 = (language2 = PsiUtilBase.getLanguageInEditor((Caret)caret, (Project)file2.getProject())) != null ? language2 : file2.getLanguage();
        if (language3 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(6);
        }
        return language3;
    }

    @NotNull
    private CommonCodeStyleSettings getLanguageSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getLanguageSettings((PsiFile)this.myFile, (Language)this.myLanguage);
        if (commonCodeStyleSettings == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(7);
        }
        return commonCodeStyleSettings;
    }

    private void showMessageIfNeeded() {
        if (this.myWarning != null) {
            this.myEditor.getScrollingModel().disableAnimation();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getScrollingModel().enableAnimation();
            LogicalPosition hintPosition = this.myCaret.getLogicalPosition();
            if (this.myWarningLocation != null) {
                LogicalPosition targetPosition = this.myEditor.offsetToLogicalPosition(this.myWarningLocation.getStartOffset());
                Point targetPoint = this.myEditor.logicalPositionToXY(targetPosition);
                if (this.myEditor.getScrollingModel().getVisibleArea().contains(targetPoint)) {
                    hintPosition = targetPosition;
                }
            }
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(this.myWarning));
            Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, hintPosition, (short)1);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.myEditor, p, 0, 0, false);
        }
    }

    @Nullable
    private static String trim(String s) {
        return s == null ? null : s.trim();
    }

    private boolean testSelectionForNonComments() {
        if (!this.myCaret.hasSelection()) {
            return true;
        }
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitDocument(this.myDocument);
        TextRange range2 = new TextRange(this.myCaret.getSelectionStart(), this.myCaret.getSelectionEnd() - 1);
        for (PsiElement element2 = this.myFile.findElementAt(range2.getStartOffset()); element2 != null && range2.intersects(element2.getTextRange()); element2 = element2.getNextSibling()) {
            if (!(element2 instanceof OuterLanguageElement ? !CommentByBlockCommentHandler.isInjectedWhiteSpace(range2, (OuterLanguageElement)element2) : !CommentByBlockCommentHandler.isWhiteSpaceOrComment(element2, range2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInjectedWhiteSpace(@NotNull TextRange range2, @NotNull OuterLanguageElement element2) {
        PsiFile psi;
        if (range2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(9);
        }
        if ((psi = element2.getContainingFile().getViewProvider().getPsi(element2.getLanguage())) == null) {
            return false;
        }
        List injectedElements = PsiTreeUtil.getInjectedElements((OuterLanguageElement)element2);
        for (PsiElement el : injectedElements) {
            if (CommentByBlockCommentHandler.isWhiteSpaceOrComment(el, range2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpaceOrComment(@NotNull PsiElement element2, @NotNull TextRange range2) {
        TextRange textRange;
        TextRange intersection;
        if (element2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(10);
        }
        if (range2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(11);
        }
        if ((intersection = range2.intersection(textRange = element2.getTextRange())) == null) {
            return false;
        }
        intersection = TextRange.create((int)Math.max(intersection.getStartOffset() - textRange.getStartOffset(), 0), (int)Math.min(intersection.getEndOffset() - textRange.getStartOffset(), textRange.getLength()));
        return CommentByBlockCommentHandler.isWhiteSpaceOrComment(element2) || intersection.substring(element2.getText()).trim().isEmpty();
    }

    private static boolean isWhiteSpaceOrComment(PsiElement element2) {
        return element2 instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element2, PsiComment.class, (boolean)false) != null;
    }

    @Nullable
    private TextRange findCommentedRange(Commenter commenter) {
        String commentText;
        PsiElement comment;
        TextRange commentedRange;
        String suffix;
        String prefix;
        CharSequence text2 = this.myDocument.getCharsSequence();
        FileType fileType = this.myFile.getFileType();
        if (fileType instanceof CustomSyntaxTableFileType) {
            CustomFileTypeLexer lexer = new CustomFileTypeLexer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            int caretOffset = this.myCaret.getOffset();
            int commentStart = CharArrayUtil.lastIndexOf((CharSequence)text2, (String)commenter.getBlockCommentPrefix(), (int)caretOffset);
            if (commentStart == -1) {
                return null;
            }
            lexer.start(text2, commentStart, text2.length());
            if (lexer.getTokenType() == CustomHighlighterTokenType.MULTI_LINE_COMMENT && lexer.getTokenEnd() >= caretOffset) {
                return new TextRange(commentStart, lexer.getTokenEnd());
            }
            return null;
        }
        String selectedText = this.myCaret.getSelectedText();
        if (commenter instanceof CustomUncommenter && selectedText != null) {
            TextRange commentedRange2 = ((CustomUncommenter)commenter).findMaximumCommentedRange((CharSequence)selectedText);
            if (commentedRange2 == null) {
                return null;
            }
            return commentedRange2.shiftRight(this.myCaret.getSelectionStart());
        }
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            prefix = selfManagingCommenter.getBlockCommentPrefix(this.myCaret.getSelectionStart(), this.myDocument, this.mySelfManagedCommenterData);
            suffix = selfManagingCommenter.getBlockCommentSuffix(this.myCaret.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            prefix = CommentByBlockCommentHandler.trim(commenter.getBlockCommentPrefix());
            suffix = CommentByBlockCommentHandler.trim(commenter.getBlockCommentSuffix());
        }
        if (prefix == null || suffix == null) {
            return null;
        }
        if (commenter instanceof SelfManagingCommenter) {
            commentedRange = ((SelfManagingCommenter)commenter).getBlockCommentRange(this.myCaret.getSelectionStart(), this.myCaret.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            if (!this.testSelectionForNonComments()) {
                return null;
            }
            commentedRange = this.getSelectedComments(text2, prefix, suffix);
        }
        if (commentedRange == null && (comment = this.findCommentAtCaret()) != null && (commentText = comment.getText()).startsWith(prefix) && commentText.endsWith(suffix)) {
            commentedRange = comment.getTextRange();
        }
        return commentedRange;
    }

    @Nullable
    private TextRange getSelectedComments(CharSequence text2, String prefix, String suffix) {
        TextRange commentedRange = null;
        if (this.myCaret.hasSelection()) {
            int selectionStart = this.myCaret.getSelectionStart();
            selectionStart = CharArrayUtil.shiftForward((CharSequence)text2, (int)selectionStart, (String)" \t\n");
            int selectionEnd = this.myCaret.getSelectionEnd() - 1;
            if ((selectionEnd = CharArrayUtil.shiftBackward((CharSequence)text2, (int)selectionEnd, (String)" \t\n") + 1) - selectionStart >= prefix.length() + suffix.length() && CharArrayUtil.regionMatches((CharSequence)text2, (int)selectionStart, (CharSequence)prefix) && CharArrayUtil.regionMatches((CharSequence)text2, (int)(selectionEnd - suffix.length()), (CharSequence)suffix)) {
                commentedRange = new TextRange(selectionStart, selectionEnd);
            }
        }
        return commentedRange;
    }

    @Nullable
    private static Commenter findCommenter(PsiFile file2, Editor editor2, Caret caret) {
        FileType fileType = file2.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter();
        }
        Language lang = PsiUtilBase.getLanguageInEditor((Caret)caret, (Project)file2.getProject());
        return CommentByBlockCommentHandler.getCommenter(file2, editor2, lang, lang);
    }

    @Nullable
    public static Commenter getCommenter(PsiFile file2, Editor editor2, Language lineStartLanguage, Language lineEndLanguage) {
        Language lang;
        FileViewProvider viewProvider = file2.getViewProvider();
        for (MultipleLangCommentProvider provider2 : (MultipleLangCommentProvider[])MultipleLangCommentProvider.EP_NAME.getExtensions()) {
            if (!provider2.canProcess(file2, viewProvider)) continue;
            return provider2.getLineCommenter(file2, editor2, lineStartLanguage, lineEndLanguage);
        }
        Language fileLanguage = file2.getLanguage();
        Language language2 = lang = lineStartLanguage == null || LanguageCommenters.INSTANCE.forLanguage(lineStartLanguage) == null || fileLanguage.getBaseLanguage() == lineStartLanguage ? fileLanguage : lineStartLanguage;
        if (viewProvider instanceof TemplateLanguageFileViewProvider && lang == ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage()) {
            lang = viewProvider.getBaseLanguage();
        }
        return (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
    }

    @Nullable
    private PsiElement findCommentAtCaret() {
        PsiComment comment;
        TextRange range2;
        int offset = this.myCaret.getOffset();
        if (offset == (range2 = new TextRange(this.myCaret.getSelectionStart(), this.myCaret.getSelectionEnd())).getEndOffset()) {
            --offset;
        }
        if (offset <= range2.getStartOffset()) {
            ++offset;
        }
        if ((comment = this.getCommentAtOffset(offset)) == null || this.myCaret.hasSelection() && !range2.contains(comment.getTextRange())) {
            return null;
        }
        return comment;
    }

    @Nullable
    private PsiComment getCommentAtOffset(int offset) {
        PsiElement elt = this.myFile.getViewProvider().findElementAt(offset);
        if (elt == null) {
            return null;
        }
        return (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)elt, PsiComment.class, (boolean)false);
    }

    public void commentRange(int startOffset, int endOffset, String commentPrefix, String commentSuffix, Commenter commenter) {
        TextRange range2;
        if (this.breaksExistingComment(startOffset, true) || this.breaksExistingComment(endOffset, false)) {
            this.myWarning = CodeInsightBundle.message((String)"block.comment.intersects.existing.comment", (Object[])new Object[0]);
            return;
        }
        CharSequence chars = this.myDocument.getCharsSequence();
        LogicalPosition caretPosition = this.myCaret.getLogicalPosition();
        CommonCodeStyleSettings settings = this.getLanguageSettings();
        if ((startOffset == 0 || chars.charAt(startOffset - 1) == '\n') && (endOffset == this.myDocument.getTextLength() || endOffset > 0 && chars.charAt(endOffset - 1) == '\n')) {
            String space;
            Boolean forced;
            Boolean bl = forced = commenter instanceof IndentedCommenter ? ((IndentedCommenter)commenter).forceIndentedBlockComment() : null;
            if (forced == null && !settings.BLOCK_COMMENT_AT_FIRST_COLUMN || forced == Boolean.TRUE) {
                int line1 = this.myEditor.offsetToLogicalPosition((int)startOffset).line;
                int line2 = this.myEditor.offsetToLogicalPosition((int)(endOffset - 1)).line;
                IndentData minIndent = CommentUtil.getMinLineIndent(this.myDocument, line1, line2, this.myFile);
                if (minIndent == null) {
                    minIndent = new IndentData(0);
                }
                space = minIndent.createIndentInfo().generateNewWhiteSpace(CodeStyle.getIndentOptions((PsiFile)this.myFile));
            } else {
                space = "";
            }
            StringBuilder nestingPrefix = new StringBuilder(space).append(commentPrefix);
            if (!commentPrefix.endsWith("\n")) {
                nestingPrefix.append("\n");
            }
            String nestingSuffix = space + (commentSuffix.startsWith("\n") ? commentSuffix.substring(1) : commentSuffix) + "\n";
            TextRange range3 = this.insertNestedComments(startOffset, endOffset, nestingPrefix.toString(), nestingSuffix, commenter);
            if (range3 != null) {
                this.myCaret.setSelection(range3.getStartOffset(), range3.getEndOffset());
                LogicalPosition pos = new LogicalPosition(caretPosition.line + 1, caretPosition.column);
                this.myCaret.moveToLogicalPosition(pos);
            }
            return;
        }
        Object nestingPrefix = commentPrefix;
        Object nestingSuffix = commentSuffix;
        if (settings.BLOCK_COMMENT_ADD_SPACE) {
            nestingPrefix = (String)nestingPrefix + " ";
            nestingSuffix = " " + (String)nestingSuffix;
        }
        if ((range2 = this.insertNestedComments(startOffset, endOffset, (String)nestingPrefix, (String)nestingSuffix, commenter)) != null) {
            this.myCaret.setSelection(range2.getStartOffset(), range2.getEndOffset());
            LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + ((String)nestingPrefix).length());
            this.myCaret.moveToLogicalPosition(pos);
        }
    }

    private boolean breaksExistingComment(int offset, boolean includingAfterLineComment) {
        if (!(this.myCommenter instanceof CodeDocumentationAwareCommenter) || offset == 0) {
            return false;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)this.myCommenter;
        HighlighterIterator it = this.myEditor.getHighlighter().createIterator(offset - 1);
        IElementType tokenType = it.getTokenType();
        return tokenType != null && (it.getEnd() > offset && (tokenType == commenter.getLineCommentTokenType() || tokenType == commenter.getBlockCommentTokenType() || tokenType == commenter.getDocumentationCommentTokenType()) || includingAfterLineComment && it.getEnd() == offset && tokenType == commenter.getLineCommentTokenType() && !(commenter instanceof CommenterWithLineSuffix));
    }

    private boolean canDetectBlockComments() {
        return this.myCommenter instanceof CodeDocumentationAwareCommenter && ((CodeDocumentationAwareCommenter)this.myCommenter).getBlockCommentTokenType() != null;
    }

    private TextRange getBlockCommentAt(int offset) {
        PsiComment comment;
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)this.myCommenter;
        HighlighterIterator it = this.myEditor.getHighlighter().createIterator(offset);
        if (it.getTokenType() == commenter.getBlockCommentTokenType()) {
            return new TextRange(it.getStart(), it.getEnd());
        }
        if (CommentByBlockCommentHandler.docCommentIsBlockComment(commenter) && (comment = this.getCommentAtOffset(offset)) != null && commenter.isDocumentationComment(comment)) {
            return comment.getTextRange();
        }
        return null;
    }

    private static boolean docCommentIsBlockComment(CodeDocumentationAwareCommenter commenter) {
        return commenter.getBlockCommentPrefix() != null && commenter.getDocumentationCommentPrefix() != null && commenter.getDocumentationCommentPrefix().startsWith(commenter.getBlockCommentPrefix()) && commenter.getBlockCommentSuffix() != null && commenter.getDocumentationCommentSuffix() != null && commenter.getDocumentationCommentSuffix().endsWith(commenter.getBlockCommentSuffix());
    }

    private int doBoundCommentingAndGetShift(int offset, String commented, int skipLength, String toInsert, boolean skipBrace, TextRange selection) {
        if (commented == null && (offset == selection.getStartOffset() || offset + (skipBrace ? skipLength : 0) == selection.getEndOffset())) {
            return 0;
        }
        if (commented == null) {
            this.myDocument.insertString(offset + (skipBrace ? skipLength : 0), (CharSequence)toInsert);
            return toInsert.length();
        }
        this.myDocument.replaceString(offset, offset + skipLength, (CharSequence)commented);
        return commented.length() - skipLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TextRange insertNestedComments(int startOffset, int endOffset, String commentPrefix, String commentSuffix, Commenter commenter) {
        int prefixIndex;
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            return selfManagingCommenter.insertBlockComment(startOffset, endOffset, this.myDocument, this.mySelfManagedCommenterData);
        }
        String normalizedPrefix = commentPrefix.trim();
        String normalizedSuffix = commentSuffix.trim();
        IntArrayList nestedCommentPrefixes = new IntArrayList();
        IntArrayList nestedCommentSuffixes = new IntArrayList();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        CharSequence chars = this.myDocument.getCharsSequence();
        boolean canDetectBlockComments = this.canDetectBlockComments();
        boolean warnAboutNestedComments = false;
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            TextRange commentRange;
            if (CharArrayUtil.regionMatches((CharSequence)chars, (int)i2, (CharSequence)normalizedPrefix)) {
                if (commentedPrefix == null && canDetectBlockComments) {
                    commentRange = this.getBlockCommentAt(i2);
                    if (commentRange == null || commentRange.getStartOffset() != i2) continue;
                    warnAboutNestedComments = true;
                }
                nestedCommentPrefixes.add(i2);
                continue;
            }
            if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)i2, (CharSequence)normalizedSuffix)) continue;
            if (commentedSuffix == null && canDetectBlockComments && (commentRange = this.getBlockCommentAt(i2)) == null) {
                this.myWarning = CodeInsightBundle.message((String)"block.comment.wrapping.suffix", (Object[])new Object[0]);
                this.myWarningLocation = this.myDocument.createRangeMarker(i2, i2);
                return null;
            }
            nestedCommentSuffixes.add(i2);
        }
        if (warnAboutNestedComments) {
            this.myWarning = CodeInsightBundle.message((String)"block.comment.nested.comment", (Object[])new Object[]{nestedCommentPrefixes.size()});
            this.myWarningLocation = this.myDocument.createRangeMarker(nestedCommentPrefixes.getInt(0), nestedCommentPrefixes.getInt(0) + normalizedPrefix.length());
        }
        int shift = 0;
        if (commentedSuffix != null || nestedCommentSuffixes.isEmpty() || nestedCommentSuffixes.getInt(nestedCommentSuffixes.size() - 1) + commentSuffix.length() != endOffset) {
            this.myDocument.insertString(endOffset, (CharSequence)commentSuffix);
            shift += commentSuffix.length();
        }
        int i3 = nestedCommentPrefixes.size() - 1;
        int j = nestedCommentSuffixes.size() - 1;
        TextRange selection = new TextRange(startOffset, endOffset);
        while (i3 >= 0 && j >= 0) {
            int suffixIndex;
            prefixIndex = nestedCommentPrefixes.getInt(i3);
            if (prefixIndex > (suffixIndex = nestedCommentSuffixes.getInt(j))) {
                shift += this.doBoundCommentingAndGetShift(prefixIndex, commentedPrefix, normalizedPrefix.length(), commentSuffix, false, selection);
                --i3;
                continue;
            }
            shift += this.doBoundCommentingAndGetShift(suffixIndex, commentedSuffix, normalizedSuffix.length(), commentPrefix, true, selection);
            --j;
        }
        while (i3 >= 0) {
            prefixIndex = nestedCommentPrefixes.getInt(i3);
            shift += this.doBoundCommentingAndGetShift(prefixIndex, commentedPrefix, normalizedPrefix.length(), commentSuffix, false, selection);
            --i3;
        }
        while (j >= 0) {
            int suffixIndex = nestedCommentSuffixes.getInt(j);
            shift += this.doBoundCommentingAndGetShift(suffixIndex, commentedSuffix, normalizedSuffix.length(), commentPrefix, true, selection);
            --j;
        }
        if (commentedPrefix != null || nestedCommentPrefixes.isEmpty() || nestedCommentPrefixes.getInt(0) != startOffset) {
            this.myDocument.insertString(startOffset, (CharSequence)commentPrefix);
            shift += commentPrefix.length();
        }
        RangeMarker marker = this.myDocument.createRangeMarker(startOffset, endOffset + shift);
        try {
            TextRange textRange = CommentByBlockCommentHandler.processDocument(this.myDocument, marker, commenter, true);
            return textRange;
        }
        finally {
            marker.dispose();
        }
    }

    static TextRange processDocument(Document document, RangeMarker marker, Commenter commenter, boolean escape) {
        if (commenter instanceof EscapingCommenter) {
            if (escape) {
                ((EscapingCommenter)commenter).escape(document, marker);
            } else {
                ((EscapingCommenter)commenter).unescape(document, marker);
            }
        }
        return TextRange.create((int)marker.getStartOffset(), (int)marker.getEndOffset());
    }

    private static int getNearest(String text2, String pattern, int position) {
        int result2 = text2.indexOf(pattern, position);
        return result2 == -1 ? text2.length() : result2;
    }

    static void commentNestedComments(@NotNull Document document, TextRange range2, Commenter commenter) {
        if (document == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(12);
        }
        int offset = range2.getStartOffset();
        IntArrayList toReplaceWithComments = new IntArrayList();
        IntArrayList prefixes = new IntArrayList();
        String text2 = document.getCharsSequence().subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        String commentPrefix = commenter.getBlockCommentPrefix();
        String commentSuffix = commenter.getBlockCommentSuffix();
        int nearestSuffix = CommentByBlockCommentHandler.getNearest(text2, commentedSuffix, 0);
        int nearestPrefix = CommentByBlockCommentHandler.getNearest(text2, commentedPrefix, 0);
        int level = 0;
        int lastSuffix = -1;
        int i2 = Math.min(nearestPrefix, nearestSuffix);
        while (i2 < text2.length()) {
            if (i2 > nearestPrefix) {
                nearestPrefix = CommentByBlockCommentHandler.getNearest(text2, commentedPrefix, i2);
            } else if (i2 > nearestSuffix) {
                nearestSuffix = CommentByBlockCommentHandler.getNearest(text2, commentedSuffix, i2);
            } else if (i2 == nearestPrefix) {
                if (level <= 0) {
                    if (lastSuffix != -1) {
                        toReplaceWithComments.add(lastSuffix);
                    }
                    level = 1;
                    lastSuffix = -1;
                    toReplaceWithComments.add(i2);
                    prefixes.add(i2);
                } else {
                    ++level;
                }
                nearestPrefix = CommentByBlockCommentHandler.getNearest(text2, commentedPrefix, nearestPrefix + 1);
            } else {
                lastSuffix = i2;
                --level;
                nearestSuffix = CommentByBlockCommentHandler.getNearest(text2, commentedSuffix, nearestSuffix + 1);
            }
            i2 = Math.min(nearestPrefix, nearestSuffix);
        }
        if (lastSuffix != -1) {
            toReplaceWithComments.add(lastSuffix);
        }
        int prefixIndex = prefixes.size() - 1;
        for (int i3 = toReplaceWithComments.size() - 1; i3 >= 0; --i3) {
            int position = toReplaceWithComments.getInt(i3);
            if (prefixIndex >= 0 && position == prefixes.getInt(prefixIndex)) {
                --prefixIndex;
                document.replaceString(offset + position, offset + position + commentedPrefix.length(), (CharSequence)commentPrefix);
                continue;
            }
            document.replaceString(offset + position, offset + position + commentedSuffix.length(), (CharSequence)commentSuffix);
        }
    }

    @NotNull
    private TextRange expandRange(int delOffset1, int delOffset2) {
        int offset2;
        CharSequence chars = this.myDocument.getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(delOffset1 - 1), (String)" \t");
        if (!(offset1 >= 0 && chars.charAt(offset1) != '\n' && chars.charAt(offset1) != '\r' || (offset2 = CharArrayUtil.shiftForward((CharSequence)chars, (int)delOffset2, (String)" \t")) != this.myDocument.getTextLength() && chars.charAt(offset2) != '\r' && chars.charAt(offset2) != '\n')) {
            delOffset1 = offset1 + 1;
            if (offset2 < this.myDocument.getTextLength()) {
                delOffset2 = offset2 + 1;
                if (chars.charAt(offset2) == '\r' && offset2 + 1 < this.myDocument.getTextLength() && chars.charAt(offset2 + 1) == '\n') {
                    ++delOffset2;
                }
            }
        }
        return new TextRange(delOffset1, delOffset2);
    }

    private Couple<TextRange> findCommentBlock(TextRange range2, String commentPrefix, String commentSuffix) {
        TextRange suffix;
        CommonCodeStyleSettings settings = this.getLanguageSettings();
        CharSequence chars = this.myDocument.getCharsSequence();
        int startOffset = range2.getStartOffset();
        boolean endsProperly = CharArrayUtil.regionMatches((CharSequence)chars, (int)(range2.getEndOffset() - commentSuffix.length()), (CharSequence)commentSuffix);
        TextRange initialPrefix = TextRange.create((int)startOffset, (int)(startOffset + commentPrefix.length()));
        TextRange prefix = this.expandRange(initialPrefix.getStartOffset(), initialPrefix.getEndOffset());
        if (settings.BLOCK_COMMENT_ADD_SPACE && initialPrefix.equals((Object)prefix) && StringUtil.isChar((CharSequence)chars, (int)prefix.getEndOffset(), (char)' ')) {
            prefix = prefix.grown(1);
        }
        if (endsProperly) {
            TextRange initialSuffix = TextRange.create((int)(range2.getEndOffset() - commentSuffix.length()), (int)range2.getEndOffset());
            suffix = this.expandRange(initialSuffix.getStartOffset(), initialSuffix.getEndOffset());
            if (settings.BLOCK_COMMENT_ADD_SPACE && initialSuffix.equals((Object)suffix)) {
                int suffixSpaceIdx = suffix.getStartOffset() - 1;
                if (prefix.getEndOffset() <= suffixSpaceIdx && StringUtil.isChar((CharSequence)chars, (int)suffixSpaceIdx, (char)' ')) {
                    suffix = TextRange.create((int)suffixSpaceIdx, (int)suffix.getEndOffset());
                }
            }
        } else {
            suffix = new TextRange(range2.getEndOffset(), range2.getEndOffset());
        }
        return Couple.of((Object)prefix, (Object)suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncommentRange(TextRange range2, String commentPrefix, String commentSuffix, Commenter commenter) {
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.uncommentBlockComment(range2.getStartOffset(), range2.getEndOffset(), this.myDocument, this.mySelfManagedCommenterData);
            return;
        }
        String text2 = this.myDocument.getCharsSequence().subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
        int startOffset = range2.getStartOffset();
        ArrayList<Object> ranges = new ArrayList<Object>();
        if (commenter instanceof CustomUncommenter) {
            CustomUncommenter customUncommenter = (CustomUncommenter)commenter;
            for (Couple coupleFromCommenter : customUncommenter.getCommentRangesToDelete((CharSequence)text2)) {
                TextRange openComment = ((TextRange)coupleFromCommenter.first).shiftRight(startOffset);
                TextRange closeComment = ((TextRange)coupleFromCommenter.second).shiftRight(startOffset);
                ranges.add(Couple.of((Object)openComment, (Object)closeComment));
            }
        } else {
            int start2;
            int position = 0;
            while ((start2 = CommentByBlockCommentHandler.getNearest(text2, commentPrefix, position)) != text2.length()) {
                int end;
                position = start2;
                position = end = CommentByBlockCommentHandler.getNearest(text2, commentSuffix, position + commentPrefix.length()) + commentSuffix.length();
                Couple<TextRange> pair = this.findCommentBlock(new TextRange(start2 + startOffset, end + startOffset), commentPrefix, commentSuffix);
                ranges.add(pair);
            }
        }
        RangeMarker marker = this.myDocument.createRangeMarker(range2);
        try {
            for (int i2 = ranges.size() - 1; i2 >= 0; --i2) {
                Couple toDelete = (Couple)ranges.get(i2);
                this.myDocument.deleteString(((TextRange)toDelete.first).getStartOffset(), ((TextRange)toDelete.first).getEndOffset());
                int shift = ((TextRange)toDelete.first).getEndOffset() - ((TextRange)toDelete.first).getStartOffset();
                this.myDocument.deleteString(((TextRange)toDelete.second).getStartOffset() - shift, ((TextRange)toDelete.second).getEndOffset() - shift);
                if (commenter.getCommentedBlockCommentPrefix() == null) continue;
                CommentByBlockCommentHandler.commentNestedComments(this.myDocument, new TextRange(((TextRange)toDelete.first).getEndOffset() - shift, ((TextRange)toDelete.second).getStartOffset() - shift), commenter);
            }
            CommentByBlockCommentHandler.processDocument(this.myDocument, marker, commenter, false);
        }
        finally {
            marker.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/CommentByBlockCommentHandler";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/CommentByBlockCommentHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInjectedWhiteSpace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpaceOrComment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "commentNestedComments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

