/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BackgroundHighlighter;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.DefaultLineMarkerRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceHighlightingHandler {
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY = Key.create((String)"BraceHighlighter.BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY");
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.LINE_MARKER_IN_EDITOR_KEY");
    private static final Key<LightweightHint> HINT_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.HINT_IN_EDITOR_KEY");
    static final int LAYER = 6001;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    private final Alarm myAlarm;
    private final Document myDocument;
    @NotNull
    private final PsiFile myPsiFile;
    private final CodeInsightSettings myCodeInsightSettings;

    BraceHighlightingHandler(@NotNull Project project, @NotNull Editor editor2, @NotNull Alarm alarm2, @NotNull PsiFile psiFile) {
        if (project == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(1);
        }
        if (alarm2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myEditor = editor2;
        this.myAlarm = alarm2;
        this.myDocument = this.myEditor.getDocument();
        this.myPsiFile = psiFile;
        this.myCodeInsightSettings = CodeInsightSettings.getInstance();
    }

    @NotNull
    public static EditorHighlighter getLazyParsableHighlighterIfAny(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (project == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(6);
        }
        if (!PsiDocumentManager.getInstance((Project)project).isCommitted(editor2.getDocument())) {
            EditorHighlighter editorHighlighter = editor2.getHighlighter();
            if (editorHighlighter == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(7);
            }
            return editorHighlighter;
        }
        PsiElement elementAt = psiFile.findElementAt(editor2.getCaretModel().getOffset());
        for (PsiElement e : SyntaxTraverser.psiApi().parents((Object)elementAt).takeWhile(Conditions.notEqualTo((Object)psiFile))) {
            Language language2;
            if (!(PsiUtilCore.getElementType((PsiElement)e) instanceof ILazyParseableElementType) || (language2 = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)e.getNode())) == null) continue;
            TextRange range2 = e.getTextRange();
            final int offset = range2.getStartOffset();
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language2, (Project)project, (VirtualFile)psiFile.getVirtualFile());
            LexerEditorHighlighter highlighter = new LexerEditorHighlighter(syntaxHighlighter, editor2.getColorsScheme()){

                @Override
                @NotNull
                public HighlighterIterator createIterator(int startOffset) {
                    return new HighlighterIteratorWrapper(super.createIterator(Math.max(startOffset - offset, 0))){

                        @Override
                        public int getStart() {
                            return super.getStart() + offset;
                        }

                        @Override
                        public int getEnd() {
                            return super.getEnd() + offset;
                        }
                    };
                }
            };
            highlighter.setText(editor2.getDocument().getText(range2));
            LexerEditorHighlighter lexerEditorHighlighter = highlighter;
            if (lexerEditorHighlighter == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(8);
            }
            return lexerEditorHighlighter;
        }
        EditorHighlighter editorHighlighter = editor2.getHighlighter();
        if (editorHighlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(9);
        }
        return editorHighlighter;
    }

    void updateBraces() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.clearBraceHighlighters();
        if (!this.myPsiFile.isValid()) {
            return;
        }
        if (!this.myCodeInsightSettings.HIGHLIGHT_BRACES) {
            return;
        }
        if (this.myEditor.getSelectionModel().hasSelection()) {
            return;
        }
        if (this.myEditor.getSoftWrapModel().isInsideOrBeforeSoftWrap(this.myEditor.getCaretModel().getVisualPosition())) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state != null && !state.isFinished()) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        this.myAlarm.cancelAllRequests();
        BraceMatchingUtil.BraceHighlightingAndNavigationContext context2 = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile);
        if (context2 != null) {
            this.doHighlight(context2.currentBraceOffset, context2.isCaretAfterBrace);
            offset = context2.currentBraceOffset;
        } else if (offset > 0 && offset < chars.length()) {
            int nextNonSpaceCharOffset;
            char c = chars.charAt(offset);
            boolean searchForward = c != '\n';
            int backwardNonSpaceEndOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\t ") + 1;
            if (backwardNonSpaceEndOffset > 0 && backwardNonSpaceEndOffset < offset && (context2 = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile, backwardNonSpaceEndOffset)) != null) {
                this.doHighlight(context2.currentBraceOffset, true);
                offset = context2.currentBraceOffset;
                searchForward = false;
            }
            if (searchForward && (nextNonSpaceCharOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)"\t ")) > offset && (context2 = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile, nextNonSpaceCharOffset)) != null) {
                this.doHighlight(context2.currentBraceOffset, true);
                offset = context2.currentBraceOffset;
            }
        }
        if (this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.highlightScope(offset);
        }
    }

    @NotNull
    private FileType getFileTypeByOffset(int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)offset).getFileType();
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(10);
        }
        return fileType;
    }

    @NotNull
    private EditorHighlighter getEditorHighlighter() {
        return BraceHighlightingHandler.getLazyParsableHighlighterIfAny(this.myProject, this.myEditor, this.myPsiFile);
    }

    private void highlightScope(int offset) {
        if (!this.myPsiFile.isValid()) {
            return;
        }
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        if (this.myEditor.getDocument().getTextLength() <= offset) {
            return;
        }
        HighlighterIterator iterator2 = this.getEditorHighlighter().createIterator(offset);
        CharSequence chars = this.myDocument.getCharsSequence();
        FileType fileType = this.getFileTypeByOffset(offset);
        if ((!BraceMatchingUtil.isStructuralBraceToken(fileType, iterator2, chars) || !BraceMatchingUtil.isRBraceToken(iterator2, chars, fileType) && !BraceMatchingUtil.isLBraceToken(iterator2, chars, fileType)) && BraceMatchingUtil.findStructuralLeftBrace(fileType, iterator2, chars)) {
            this.highlightLeftBrace(iterator2, true, fileType);
        }
    }

    private void doHighlight(int offset, boolean isAdjustedPosition) {
        FileType fileType;
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        HighlighterIterator iterator2 = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isLBraceToken(iterator2, chars = this.myDocument.getCharsSequence(), fileType = this.getFileTypeByOffset(offset))) {
            this.highlightLeftBrace(iterator2, false, fileType);
            if (offset > 0 && !isAdjustedPosition && !this.myEditor.getSettings().isBlockCursor() && BraceMatchingUtil.isRBraceToken(iterator2 = this.getEditorHighlighter().createIterator(offset - 1), chars, fileType)) {
                this.highlightRightBrace(iterator2, fileType);
            }
        } else if (BraceMatchingUtil.isRBraceToken(iterator2, chars, fileType)) {
            this.highlightRightBrace(iterator2, fileType);
        }
    }

    private void highlightRightBrace(@NotNull HighlighterIterator iterator2, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(11);
        }
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(12);
        }
        TextRange brace1 = TextRange.create((int)iterator2.getStart(), (int)iterator2.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator2, false);
        TextRange brace2 = iterator2.atEnd() ? null : TextRange.create((int)iterator2.getStart(), (int)iterator2.getEnd());
        this.highlightBraces(brace2, brace1, matched, false, fileType);
    }

    private void highlightLeftBrace(@NotNull HighlighterIterator iterator2, boolean scopeHighlighting, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(14);
        }
        TextRange brace1Start = TextRange.create((int)iterator2.getStart(), (int)iterator2.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator2, true);
        TextRange brace2End = iterator2.atEnd() ? null : TextRange.create((int)iterator2.getStart(), (int)iterator2.getEnd());
        this.highlightBraces(brace1Start, brace2End, matched, scopeHighlighting, fileType);
    }

    private void highlightBraces(@Nullable TextRange lBrace, @Nullable TextRange rBrace, boolean matched, boolean scopeHighlighting, @NotNull FileType fileType) {
        FileEditorManager fileEditorManager;
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(15);
        }
        if (!matched && fileType == FileTypes.PLAIN_TEXT) {
            return;
        }
        if (rBrace != null && !scopeHighlighting) {
            this.highlightBrace(rBrace, matched);
        }
        if (lBrace != null && !scopeHighlighting) {
            this.highlightBrace(lBrace, matched);
        }
        if ((fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)) == null) {
            return;
        }
        if (!ContainerUtil.exists((Object[])fileEditorManager.getSelectedTextEditorWithRemotes(), e -> e.equals(this.myEditor))) {
            return;
        }
        if (lBrace != null && rBrace != null) {
            int endLine = this.myEditor.offsetToLogicalPosition((int)rBrace.getEndOffset()).line;
            int startLine = this.myEditor.offsetToLogicalPosition((int)lBrace.getStartOffset()).line;
            if (endLine - startLine > 0 && this.myEditor instanceof EditorEx) {
                BraceHighlightingHandler.lineMarkFragment((EditorEx)this.myEditor, this.myDocument, startLine, endLine, matched);
            }
            if (!scopeHighlighting) {
                this.showScopeHint(lBrace.getStartOffset(), lBrace.getEndOffset());
            }
        }
    }

    private void highlightBrace(@NotNull TextRange braceRange, boolean matched) {
        if (braceRange == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(16);
        }
        TextAttributesKey attributesKey = matched ? CodeInsightColors.MATCHED_BRACE_ATTRIBUTES : CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES;
        RangeHighlighter rbraceHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(attributesKey, braceRange.getStartOffset(), braceRange.getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE);
        rbraceHighlighter.setGreedyToLeft(false);
        rbraceHighlighter.setGreedyToRight(false);
        this.registerHighlighter(rbraceHighlighter);
    }

    private void registerHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(17);
        }
        this.getHighlightersList().add(highlighter);
    }

    @NotNull
    private List<RangeHighlighter> getHighlightersList() {
        Editor editor2 = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : this.myEditor;
        ArrayList<RangeHighlighter> highlighters = (ArrayList<RangeHighlighter>)editor2.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList<RangeHighlighter>();
            editor2.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, highlighters);
        }
        ArrayList<RangeHighlighter> arrayList = highlighters;
        if (arrayList == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private void showScopeHint(int lbraceStart, int lbraceEnd) {
        this.showScopeHint(lbraceStart, lbraceEnd, offset -> {
            if (!(this.myPsiFile instanceof PsiPlainTextFile) && this.myPsiFile.isValid()) {
                return BraceMatchingUtil.getBraceMatcher(this.getFileTypeByOffset(offset), PsiUtilCore.getLanguageAtOffset((PsiFile)this.myPsiFile, (int)offset)).getCodeConstructStart(this.myPsiFile, offset);
            }
            return offset;
        });
    }

    public static void showScopeHint(@NotNull Editor editor2, @NotNull PsiFile psiFile, int leftBraceStart, int leftBraceEnd) {
        if (editor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(19);
        }
        if (psiFile == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(20);
        }
        new BraceHighlightingHandler(psiFile.getProject(), editor2, BackgroundHighlighter.getAlarm(), psiFile).showScopeHint(leftBraceStart, leftBraceEnd, null);
    }

    private void showScopeHint(int leftBraceStart, int leftBraceEnd, @Nullable IntUnaryOperator startComputation) {
        Editor editor2 = this.myEditor;
        Project project = editor2.getProject();
        if (project == null) {
            return;
        }
        LogicalPosition bracePosition = editor2.offsetToLogicalPosition(leftBraceStart);
        Point braceLocation = editor2.logicalPositionToXY(bracePosition);
        int y = braceLocation.y;
        this.myAlarm.addRequest(() -> ReadAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> {
                if (editor2.isDisposed() || !editor2.getComponent().isShowing()) {
                    return;
                }
                Rectangle viewRect = editor2.getScrollingModel().getVisibleArea();
                if (y >= viewRect.y) {
                    return;
                }
                TextRange range2 = new TextRange(startComputation == null ? leftBraceStart : startComputation.applyAsInt(leftBraceStart), leftBraceEnd);
                Document document = editor2.getDocument();
                int line1 = document.getLineNumber(range2.getStartOffset());
                int line2 = document.getLineNumber(range2.getEndOffset());
                line1 = Math.max(line1, line2 - EditorFragmentComponent.getAvailableVisualLinesAboveEditor(editor2) + 1);
                range2 = new TextRange(document.getLineStartOffset(line1), range2.getEndOffset());
                LightweightHint hint = EditorFragmentComponent.showEditorFragmentHint(editor2, range2, true, true);
                editor2.putUserData(HINT_IN_EDITOR_KEY, (Object)hint);
            });
        }), 300, ModalityState.stateForComponent((Component)editor2.getComponent()));
    }

    void clearBraceHighlighters() {
        List<RangeHighlighter> highlighters = this.getHighlightersList();
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
        LightweightHint hint = (LightweightHint)this.myEditor.getUserData(HINT_IN_EDITOR_KEY);
        if (hint != null) {
            hint.hide();
            this.myEditor.putUserData(HINT_IN_EDITOR_KEY, null);
        }
        if (this.myEditor instanceof EditorEx) {
            BraceHighlightingHandler.removeLineMarkers((EditorEx)this.myEditor);
        }
    }

    public static void lineMarkFragment(@NotNull EditorEx editor2, @NotNull Document document, int startLine, int endLine, boolean matched) {
        if (editor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(21);
        }
        if (document == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(22);
        }
        BraceHighlightingHandler.removeLineMarkers(editor2);
        if (startLine >= endLine || endLine >= document.getLineCount()) {
            return;
        }
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        LineMarkerRenderer renderer2 = BraceHighlightingHandler.createLineMarkerRenderer(matched);
        RangeHighlighterEx highlighter = editor2.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, startOffset, endOffset, 0, HighlighterTargetArea.LINES_IN_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)h -> h.setLineMarkerRenderer(renderer2)));
        editor2.putUserData(LINE_MARKER_IN_EDITOR_KEY, highlighter);
    }

    private static void removeLineMarkers(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = (RangeHighlighter)editor2.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && editor2.getMarkupModel().containsHighlighter(marker)) {
            marker.dispose();
        }
        editor2.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    @NotNull
    public static LineMarkerRenderer createLineMarkerRenderer(boolean matched) {
        TextAttributesKey key = matched ? CodeInsightColors.MATCHED_BRACE_ATTRIBUTES : CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES;
        return new DefaultLineMarkerRenderer(key, 1, 0, LineMarkerRendererEx.Position.RIGHT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 3: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BraceHighlightingHandler";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceRange";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceHighlightingHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyParsableHighlighterIfAny";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByOffset";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightersList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLazyParsableHighlighterIfAny";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "highlightRightBrace";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "highlightLeftBrace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "highlightBraces";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightBrace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlighter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showScopeHint";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lineMarkFragment";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeLineMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

