/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.codeInsight.highlighting.HighlightUsagesKt;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.EditorSearchSession;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUsagesHandler
extends HighlightHandlerBase {
    public static void invoke(@NotNull Project project, @NotNull Editor editor2, @Nullable PsiFile file2) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (file2 == null && !selectionModel.hasSelection()) {
            selectionModel.selectWordAtCaret(false);
        }
        if (file2 == null || selectionModel.hasSelection()) {
            HighlightUsagesHandler.doRangeHighlighting(editor2, project);
            return;
        }
        HighlightUsagesHandlerBase handler2 = HighlightUsagesHandler.createCustomHandler(editor2, file2);
        if (handler2 != null) {
            String featureId = handler2.getFeatureId();
            if (featureId != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
            }
            handler2.highlightUsages();
            return;
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            if (!HighlightUsagesKt.highlightUsages(project, editor2, file2)) {
                HighlightUsagesHandler.handleNoUsageTargets(file2, editor2, selectionModel, project);
            }
        });
    }

    private static void handleNoUsageTargets(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull SelectionModel selectionModel, @NotNull Project project) {
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(3);
        }
        if (selectionModel == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(5);
        }
        if (file2.findElementAt(editor2.getCaretModel().getOffset()) instanceof PsiWhiteSpace) {
            return;
        }
        selectionModel.selectWordAtCaret(false);
        String selection = selectionModel.getSelectedText();
        if (selection != null) {
            for (int i2 = 0; i2 < selection.length(); ++i2) {
                if (Character.isJavaIdentifierPart(selection.charAt(i2))) continue;
                selectionModel.removeSelection();
            }
        }
        HighlightUsagesHandler.doRangeHighlighting(editor2, project);
        selectionModel.removeSelection();
    }

    @Nullable
    public static <T extends PsiElement> HighlightUsagesHandlerBase<T> createCustomHandler(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor2);
        return HighlightUsagesHandler.createCustomHandler(editor2, file2, visibleRange);
    }

    @Nullable
    public static <T extends PsiElement> HighlightUsagesHandlerBase<T> createCustomHandler(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull ProperTextRange visibleRange) {
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(9);
        }
        if (visibleRange == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(10);
        }
        for (HighlightUsagesHandlerFactory factory2 : HighlightUsagesHandlerFactory.EP_NAME.getExtensionList()) {
            HighlightUsagesHandlerBase handler2 = factory2.createHighlightUsagesHandler(editor2, file2, visibleRange);
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    private static void doRangeHighlighting(@NotNull Editor editor2, @NotNull Project project) {
        EditorSearchSession oldSearch;
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(11);
        }
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(12);
        }
        if (!editor2.getSelectionModel().hasSelection()) {
            return;
        }
        String text2 = editor2.getSelectionModel().getSelectedText();
        if (text2 == null) {
            return;
        }
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        if ((oldSearch = EditorSearchSession.get(editor2)) != null && oldSearch.hasMatches()) {
            String oldText = oldSearch.getTextInField();
            if (!oldSearch.getFindModel().isRegularExpressions()) {
                oldText = StringUtil.escapeToRegexp((String)oldText);
                oldSearch.getFindModel().setRegularExpressions(true);
            }
            String newText = oldText + "|" + StringUtil.escapeToRegexp((String)text2);
            oldSearch.setTextInField(newText);
            return;
        }
        EditorSearchSession.start(editor2, project).getFindModel().setRegularExpressions(false);
    }

    public static void highlightReferences(@NotNull Project project, @NotNull PsiElement element2, @NotNull List<? extends PsiReference> refs, @NotNull Editor editor2, @NotNull PsiFile file2, boolean clearHighlights) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(14);
        }
        if (refs == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(15);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(17);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        HighlightUsagesHandler.setupFindModel(project);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element2);
        if (detector != null) {
            ArrayList<PsiReference> readRefs = new ArrayList<PsiReference>();
            ArrayList<PsiReference> writeRefs = new ArrayList<PsiReference>();
            for (PsiReference psiReference : refs) {
                if (detector.getReferenceAccess(element2, psiReference) == ReadWriteAccessDetector.Access.Read) {
                    readRefs.add(psiReference);
                    continue;
                }
                writeRefs.add(psiReference);
            }
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor2, readRefs, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights);
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor2, writeRefs, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, clearHighlights);
        } else {
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor2, refs, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights);
        }
        TextRange range2 = HighlightUsagesHandler.getNameIdentifierRange(file2, element2);
        if (range2 != null) {
            TextAttributesKey nameAttributes = detector != null && detector.isDeclarationWriteAccess(element2) ? EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES : EditorColors.SEARCH_RESULT_ATTRIBUTES;
            HighlightUsagesHandler.highlightRanges(highlightManager, editor2, nameAttributes, clearHighlights, Collections.singletonList(range2));
        }
    }

    @ApiStatus.Experimental
    public static void highlightUsages(@NotNull Project project, @NotNull Editor editor2, @NotNull List<? extends TextRange> readUsages, @NotNull List<? extends TextRange> writeUsages, boolean clearHighlights) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(19);
        }
        if (readUsages == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(20);
        }
        if (writeUsages == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(21);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        HighlightUsagesHandler.setupFindModel(project);
        HighlightUsagesHandler.highlightRanges(highlightManager, editor2, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights, readUsages);
        HighlightUsagesHandler.highlightRanges(highlightManager, editor2, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, clearHighlights, writeUsages);
    }

    @Nullable
    public static TextRange getNameIdentifierRange(@NotNull PsiFile file2, @NotNull PsiElement element2) {
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(22);
        }
        if (element2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(23);
        }
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)file2.getProject());
        Pair<PsiElement, TextRange> pair = HighlightUsagesHandler.getNameIdentifierRangeInCurrentRoot(file2, element2);
        if (pair == null) {
            return null;
        }
        return injectedManager.injectedToHost((PsiElement)pair.getFirst(), (TextRange)pair.getSecond());
    }

    @Nullable
    public static Pair<PsiElement, TextRange> getNameIdentifierRangeInCurrentRoot(@NotNull PsiFile file2, @NotNull PsiElement element2) {
        PsiDeclaredTarget declaredTarget;
        TextRange range2;
        PomTarget target2;
        if (file2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(24);
        }
        if (element2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(25);
        }
        if (element2 instanceof PomTargetPsiElement && (target2 = ((PomTargetPsiElement)element2).getTarget()) instanceof PsiDeclaredTarget && (range2 = (declaredTarget = (PsiDeclaredTarget)target2).getNameIdentifierRange()) != null) {
            if (range2.getStartOffset() < 0 || range2.getLength() <= 0) {
                return null;
            }
            PsiElement navElement = declaredTarget.getNavigationElement();
            if (PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)navElement)) {
                return Pair.create((Object)navElement, (Object)range2.shiftRight(navElement.getTextRange().getStartOffset()));
            }
        }
        if (!PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)element2)) {
            return null;
        }
        PsiElement identifier = IdentifierUtil.getNameIdentifier(element2);
        if (identifier != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)identifier)) {
            TextRange range3 = identifier instanceof ExternallyAnnotated ? ((ExternallyAnnotated)identifier).getAnnotationRegion() : identifier.getTextRange();
            return range3 == null ? null : Pair.create((Object)identifier, (Object)range3);
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor2, @NotNull TextAttributes attributes2, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(26);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(27);
        }
        if (attributes2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(28);
        }
        if (textRanges == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(29);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor2, attributes2, null, clearHighlights, textRanges);
    }

    public static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor2, @NotNull TextAttributesKey attributesKey, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(30);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(31);
        }
        if (attributesKey == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(32);
        }
        if (textRanges == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(33);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor2, null, attributesKey, clearHighlights, textRanges);
    }

    private static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor2, @Nullable TextAttributes attributes2, @Nullable TextAttributesKey attributesKey, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(34);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(35);
        }
        if (textRanges == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(36);
        }
        assert (attributes2 != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (clearHighlights) {
            HighlightUsagesHandler.clearHighlights(editor2, highlightManager, textRanges, attributes2, attributesKey);
            return;
        }
        ArrayList highlighters = new ArrayList();
        for (TextRange textRange : textRanges) {
            if (attributes2 != null) {
                highlightManager.addRangeHighlight(editor2, textRange.getStartOffset(), textRange.getEndOffset(), attributes2, false, highlighters);
                continue;
            }
            highlightManager.addRangeHighlight(editor2, textRange.getStartOffset(), textRange.getEndOffset(), attributesKey, false, highlighters);
        }
        for (RangeHighlighter rangeHighlighter : highlighters) {
            String tooltip2 = HighlightUsagesHandler.getLineTextErrorStripeTooltip(editor2.getDocument(), rangeHighlighter.getStartOffset(), true);
            rangeHighlighter.setErrorStripeTooltip((Object)tooltip2);
        }
    }

    public static boolean isClearHighlights(@NotNull Editor editor2) {
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(37);
        }
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)editor2.getProject())).getHighlighters(editor2);
        int caretOffset = editor2.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters) {
            if (!TextRange.create((Segment)highlighter).grown(1).contains(caretOffset)) continue;
            return true;
        }
        return false;
    }

    private static void clearHighlights(@NotNull Editor editor2, @NotNull HighlightManager highlightManager, @NotNull List<? extends TextRange> rangesToHighlight, @Nullable TextAttributes attributes2, @Nullable TextAttributesKey attributesKey) {
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(38);
        }
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(39);
        }
        if (rangesToHighlight == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(40);
        }
        assert (attributes2 != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)highlightManager).getHighlighters(editor2);
        Arrays.sort(highlighters, Comparator.comparingInt(RangeMarker::getStartOffset));
        rangesToHighlight.sort(Comparator.comparingInt(TextRange::getStartOffset));
        int i2 = 0;
        int j = 0;
        while (i2 < highlighters.length && j < rangesToHighlight.size()) {
            RangeHighlighter highlighter = highlighters[i2];
            TextRange highlighterRange = TextRange.create((Segment)highlighter);
            TextRange refRange = rangesToHighlight.get(j);
            if (refRange.equals((Object)highlighterRange) && highlighter.getLayer() == 5999 && (Objects.equals(attributesKey, highlighter.getTextAttributesKey()) || Objects.equals(attributes2, highlighter.getTextAttributes(editor2.getColorsScheme())))) {
                highlightManager.removeSegmentHighlighter(editor2, highlighter);
                ++i2;
                continue;
            }
            if (refRange.getStartOffset() > highlighterRange.getEndOffset()) {
                ++i2;
                continue;
            }
            if (refRange.getEndOffset() < highlighterRange.getStartOffset()) {
                ++j;
                continue;
            }
            ++i2;
            ++j;
        }
    }

    private static void doHighlightRefs(@NotNull HighlightManager highlightManager, @NotNull Editor editor2, @NotNull List<? extends PsiReference> refs, @NotNull TextAttributesKey attributesKey, boolean clearHighlights) {
        if (highlightManager == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(41);
        }
        if (editor2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(42);
        }
        if (refs == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(43);
        }
        if (attributesKey == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(44);
        }
        ArrayList textRanges = new ArrayList(refs.size());
        for (PsiReference psiReference : refs) {
            HighlightUsagesHandler.collectHighlightRanges(psiReference, textRanges);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor2, attributesKey, clearHighlights, textRanges);
    }

    @NotNull
    public static List<TextRange> collectRangesToHighlight(@NotNull PsiReference ref, @NotNull List<TextRange> result2) {
        if (ref == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(45);
        }
        if (result2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(46);
        }
        HighlightUsagesHandler.collectHighlightRanges(ref, result2);
        List<TextRange> list2 = result2;
        if (list2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(47);
        }
        return list2;
    }

    public static void collectHighlightRanges(@NotNull PsiReference ref, @NotNull Collection<? super TextRange> result2) {
        if (ref == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(48);
        }
        if (result2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(49);
        }
        for (TextRange relativeRange : ReferenceRange.getRanges((PsiReference)ref)) {
            HighlightUsagesHandler.collectHighlightRanges(ref.getElement(), relativeRange, result2);
        }
    }

    public static void collectHighlightRanges(@NotNull PsiElement element2, @NotNull TextRange rangeInElement, @NotNull Collection<? super TextRange> result2) {
        TextRange range2;
        if (element2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(50);
        }
        if (rangeInElement == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(51);
        }
        if (result2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(52);
        }
        if ((range2 = HighlightUsagesHandler.safeCut(element2.getTextRange(), rangeInElement)).isEmpty()) {
            return;
        }
        result2.add((TextRange)InjectedLanguageManager.getInstance((Project)element2.getProject()).injectedToHost(element2, range2));
    }

    @NotNull
    private static TextRange safeCut(@NotNull TextRange range2, @NotNull TextRange relative) {
        if (range2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(53);
        }
        if (relative == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(54);
        }
        int start2 = Math.min(range2.getEndOffset(), range2.getStartOffset() + relative.getStartOffset());
        int end = Math.min(range2.getEndOffset(), range2.getStartOffset() + relative.getEndOffset());
        return new TextRange(start2, end);
    }

    static void setStatusText(@NotNull Project project, @Nullable String elementName, int refCount, boolean clearHighlights) {
        if (project == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(55);
        }
        String message2 = clearHighlights ? "" : (refCount > 0 ? CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()}) : CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName}));
        WindowManager.getInstance().getStatusBar(project).setInfo(message2);
    }

    @NotNull
    private static String getElementName(@NotNull PsiElement element2) {
        if (element2 == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(56);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element2, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
        if (string == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static String getShortcutText() {
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("HighlightUsagesInFile").getShortcutSet().getShortcuts();
        if (shortcuts.length == 0) {
            return "<no key assigned>";
        }
        String string = KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
        if (string == null) {
            HighlightUsagesHandler.$$$reportNull$$$0(58);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 47: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 47: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 27: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 14: 
            case 23: 
            case 25: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readUsages";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeUsages";
                break;
            }
            case 26: 
            case 30: 
            case 34: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightManager";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 32: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesToHighlight";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 46: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRangesToHighlight";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleNoUsageTargets";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCustomHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doRangeHighlighting";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightReferences";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "highlightUsages";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifierRange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifierRangeInCurrentRoot";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "highlightRanges";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isClearHighlights";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "clearHighlights";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doHighlightRefs";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectRangesToHighlight";
                break;
            }
            case 47: 
            case 57: 
            case 58: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlightRanges";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "safeCut";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setStatusText";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 47: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DoHighlightRunnable
    implements Runnable {
        private final List<? extends PsiReference> myRefs;
        @NotNull
        private final Project myProject;
        private final PsiElement myTarget;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final boolean myClearHighlights;

        public DoHighlightRunnable(@NotNull List<? extends PsiReference> refs, @NotNull Project project, @NotNull PsiElement target2, @NotNull Editor editor2, @NotNull PsiFile file2, boolean clearHighlights) {
            if (refs == null) {
                DoHighlightRunnable.$$$reportNull$$$0(0);
            }
            if (project == null) {
                DoHighlightRunnable.$$$reportNull$$$0(1);
            }
            if (target2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                DoHighlightRunnable.$$$reportNull$$$0(4);
            }
            this.myRefs = refs;
            this.myProject = project;
            this.myTarget = target2;
            this.myEditor = editor2 instanceof EditorWindow ? ((EditorWindow)editor2).getDelegate() : editor2;
            this.myFile = file2;
            this.myClearHighlights = clearHighlights;
        }

        @Override
        public void run() {
            HighlightUsagesHandler.highlightReferences(this.myProject, this.myTarget, this.myRefs, this.myEditor, this.myFile, this.myClearHighlights);
            HighlightUsagesHandler.setStatusText(this.myProject, HighlightUsagesHandler.getElementName(this.myTarget), this.myRefs.size(), this.myClearHighlights);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

