/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ClientHintManager;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.ide.IdeTooltip;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HintManagerImpl
extends HintManager {
    private static final Logger LOG = Logger.getInstance(HintManager.class);
    private final MyEditorManagerListener myEditorManagerListener = new MyEditorManagerListener();

    @ApiStatus.Internal
    public static int getPriority(QuestionAction action2) {
        return action2 instanceof PriorityQuestionAction ? ((PriorityQuestionAction)action2).getPriority() : 0;
    }

    public boolean canShowQuestionAction(QuestionAction action2) {
        return ClientHintManager.getCurrentInstance().canShowQuestionAction(action2);
    }

    public static HintManagerImpl getInstanceImpl() {
        return (HintManagerImpl)((Object)ApplicationManager.getApplication().getService(HintManager.class));
    }

    public HintManagerImpl() {
        MyProjectManagerListener projectManagerListener2 = new MyProjectManagerListener();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            projectManagerListener2.projectOpened(project);
        }
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)projectManagerListener2);
    }

    public void setRequestFocusForNextHint(boolean requestFocus) {
        ClientHintManager.getCurrentInstance().setRequestFocusForNextHint(requestFocus);
    }

    public boolean performCurrentQuestionAction() {
        return ClientHintManager.getCurrentInstance().performCurrentQuestionAction();
    }

    public boolean hasShownHintsThatWillHideByOtherHint(boolean willShowTooltip) {
        return ClientHintManager.getCurrentInstance().hasShownHintsThatWillHideByOtherHint(willShowTooltip);
    }

    static void updateScrollableHintPosition(VisibleAreaEvent e, LightweightHint hint, boolean hideIfOutOfEditor) {
        boolean okToUpdateBounds;
        if (hint.getComponent() instanceof ScrollAwareHint) {
            ((ScrollAwareHint)((Object)hint.getComponent())).editorScrolled();
        }
        if (!hint.isVisible()) {
            return;
        }
        Editor editor2 = e.getEditor();
        if (!editor2.getComponent().isShowing() || editor2.isOneLineMode()) {
            return;
        }
        Rectangle newRectangle = e.getOldRectangle();
        Rectangle oldRectangle = e.getNewRectangle();
        Point location = hint.getLocationOn(editor2.getContentComponent());
        Dimension size = hint.getSize();
        int xOffset = location.x - oldRectangle.x;
        int yOffset = location.y - oldRectangle.y;
        location = new Point(newRectangle.x + xOffset, newRectangle.y + yOffset);
        Rectangle newBounds = new Rectangle(location.x, location.y, size.width, size.height);
        Rectangle newBoundsForIntersectionCheck = new Rectangle(location.x - 1, location.y - 1, size.width + 2, size.height + 2);
        boolean bl = okToUpdateBounds = hideIfOutOfEditor ? oldRectangle.contains(newBounds) : oldRectangle.intersects(newBoundsForIntersectionCheck);
        if (okToUpdateBounds || hint.vetoesHiding()) {
            hint.setLocation(new RelativePoint((Component)editor2.getContentComponent(), location));
        } else {
            hint.hide();
        }
    }

    public void showEditorHint(LightweightHint hint, Editor editor2, @HintManager.PositionFlags short constraint, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        ClientHintManager.getCurrentInstance().showEditorHint(hint, editor2, constraint, flags, timeout, reviveOnEditorChange);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(1);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(2);
        }
        this.showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, (short)1);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @HintManager.PositionFlags short position) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(4);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(5);
        }
        HintHint hintHint = HintManagerImpl.createHintHint(editor2, p, hint, position).setShowImmediately(true);
        this.showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, hintHint);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, HintHint hintInfo) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(7);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(8);
        }
        ClientHintManager.getCurrentInstance().showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, hintInfo);
    }

    public void showHint(@NotNull JComponent component2, @NotNull RelativePoint p, int flags, int timeout) {
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(9);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(10);
        }
        this.showHint(component2, p, flags, timeout, null);
    }

    public void showHint(@NotNull JComponent component2, @NotNull RelativePoint p, int flags, int timeout, @Nullable Runnable onHintHidden) {
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(11);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(12);
        }
        ClientHintManager.getCurrentInstance().showHint(component2, p, flags, timeout, onHintHidden);
    }

    static void doShowInGivenLocation(LightweightHint hint, Editor editor2, Point p, HintHint hintInfo, boolean updateSize) {
        Dimension size;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        Dimension dimension = size = updateSize ? hint.getComponent().getPreferredSize() : hint.getComponent().getSize();
        if (hint.isRealPopup() || hintInfo.isPopupForced()) {
            Point point = new Point(p);
            SwingUtilities.convertPointToScreen(point, externalComponent);
            Rectangle editorScreen = ScreenUtil.getScreenRectangle((int)point.x, (int)point.y);
            p = new Point(p);
            if (hintInfo.getPreferredPosition() == Balloon.Position.atLeft) {
                p.x -= size.width;
            }
            SwingUtilities.convertPointToScreen(p, externalComponent);
            Rectangle rectangle = new Rectangle(p, size);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)editorScreen, null);
            p = rectangle.getLocation();
            SwingUtilities.convertPointFromScreen(p, externalComponent);
            if (hintInfo.getPreferredPosition() == Balloon.Position.atLeft) {
                p.x += size.width;
            }
        } else if (externalComponent.getWidth() < p.x + size.width && !hintInfo.isAwtTooltip()) {
            p.x = Math.max(0, externalComponent.getWidth() - size.width);
        }
        if (hint.isShouldBeReopen()) {
            hint.hide(true);
        }
        if (hint.isVisible()) {
            if (updateSize) {
                hint.pack();
            }
            hint.updatePosition(hintInfo.getPreferredPosition());
            hint.updateLocation(p.x, p.y);
        } else {
            hint.show(externalComponent, p.x, p.y, editor2.getContentComponent(), hintInfo);
        }
    }

    public static void updateLocation(LightweightHint hint, Editor editor2, Point p) {
        HintManagerImpl.doShowInGivenLocation(hint, editor2, p, HintManagerImpl.createHintHint(editor2, p, hint, (short)2), false);
    }

    public static void adjustEditorHintPosition(LightweightHint hint, Editor editor2, Point p, @HintManager.PositionFlags short constraint) {
        HintManagerImpl.doShowInGivenLocation(hint, editor2, p, HintManagerImpl.createHintHint(editor2, p, hint, constraint), true);
    }

    public void hideAllHints() {
        ClientHintManager.getCurrentInstance().hideAllHints();
    }

    public void cleanup() {
        ClientHintManager.getCurrentInstance().cleanup();
    }

    public Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(14);
        }
        return ClientHintManager.getCurrentInstance().getHintPosition(hint, editor2, constraint);
    }

    static Point getHintPositionRelativeTo(@NotNull LightweightHint hint, @NotNull Editor editor2, @HintManager.PositionFlags short constraint, @NotNull Rectangle lookupBounds, LogicalPosition pos) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(15);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(16);
        }
        if (lookupBounds == null) {
            HintManagerImpl.$$$reportNull$$$0(17);
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        IdeTooltip ideTooltip = hint.getCurrentIdeTooltip();
        if (ideTooltip != null) {
            Point point = ideTooltip.getPoint();
            return SwingUtilities.convertPoint(ideTooltip.getComponent(), point, externalComponent);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        int layeredPaneHeight = externalComponent.getHeight();
        switch (constraint) {
            case 3: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x - hintSize.width, y);
            }
            case 4: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x + lookupBounds.width, y);
            }
            case 1: {
                Point posAboveCaret = HintManagerImpl.getHintPosition(hint, editor2, pos, (short)1);
                return new Point(lookupBounds.x, Math.min(posAboveCaret.y, lookupBounds.y - hintSize.height));
            }
            case 2: {
                Point posUnderCaret = HintManagerImpl.getHintPosition(hint, editor2, pos, (short)2);
                return new Point(lookupBounds.x, Math.max(posUnderCaret.y, lookupBounds.y + lookupBounds.height));
            }
        }
        LOG.error("");
        return null;
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull LogicalPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(19);
        }
        if (pos == null) {
            HintManagerImpl.$$$reportNull$$$0(20);
        }
        VisualPosition visualPos = editor2.logicalToVisualPosition(pos);
        return HintManagerImpl.getHintPosition(hint, editor2, visualPos, visualPos, constraint);
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(21);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(22);
        }
        if (pos == null) {
            HintManagerImpl.$$$reportNull$$$0(23);
        }
        return HintManagerImpl.getHintPosition(hint, editor2, pos, pos, constraint);
    }

    static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(24);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(25);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(26);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(27);
        }
        return HintManagerImpl.getHintPosition(hint, editor2, pos1, pos2, constraint, Registry.is((String)"editor.balloonHints"));
    }

    static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(28);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(29);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(30);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(31);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return new Point();
        }
        Point p = HintManagerImpl._getHintPosition(hint, editor2, pos1, pos2, constraint, showByBalloon);
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        Dimension hintSize = hint.getComponent().getPreferredSize();
        if (constraint == 1) {
            if (p.y < 0) {
                Point p1 = HintManagerImpl._getHintPosition(hint, editor2, pos1, pos2, (short)2, showByBalloon);
                if (p1.y + hintSize.height <= externalComponent.getSize().height) {
                    return p1;
                }
            }
        } else if (constraint == 2 && p.y + hintSize.height > externalComponent.getSize().height) {
            Point p1 = HintManagerImpl._getHintPosition(hint, editor2, pos1, pos2, (short)1, showByBalloon);
            if (p1.y >= 0) {
                return p1;
            }
        }
        return p;
    }

    @NotNull
    public static JComponent getExternalComponent(@NotNull Editor editor2) {
        JComponent externalComponent;
        JRootPane rootPane;
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(32);
        }
        if ((rootPane = (externalComponent = editor2.getComponent()).getRootPane()) == null) {
            JComponent jComponent = externalComponent;
            if (jComponent == null) {
                HintManagerImpl.$$$reportNull$$$0(33);
            }
            return jComponent;
        }
        JLayeredPane layeredPane2 = rootPane.getLayeredPane();
        JComponent jComponent = layeredPane2 != null ? layeredPane2 : rootPane;
        if (jComponent == null) {
            HintManagerImpl.$$$reportNull$$$0(34);
        }
        return jComponent;
    }

    private static Point _getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull VisualPosition pos1, @NotNull VisualPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        Point location;
        Point p;
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(35);
        }
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(36);
        }
        if (pos1 == null) {
            HintManagerImpl.$$$reportNull$$$0(37);
        }
        if (pos2 == null) {
            HintManagerImpl.$$$reportNull$$$0(38);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor2);
        JComponent internalComponent = editor2.getContentComponent();
        if (constraint == 5) {
            p = editor2.visualPositionToXY(pos2);
            if (!showByBalloon) {
                p.y += editor2.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        } else {
            p = editor2.visualPositionToXY(pos1);
            if (constraint == 2) {
                p.y += editor2.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        }
        if (constraint == 1 && !showByBalloon) {
            location.y -= hintSize.height;
            int diff = location.x + hintSize.width - externalComponent.getWidth();
            if (diff > 0) {
                location.x = Math.max(location.x - diff, 0);
            }
        }
        if (!(constraint != 3 && constraint != 4 || showByBalloon)) {
            location.y -= hintSize.height / 2;
            if (constraint == 3) {
                location.x -= hintSize.width;
            }
        }
        return location;
    }

    public void showErrorHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String text2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(39);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(40);
        }
        this.showErrorHint(editor2, text2, (short)1);
    }

    public void showErrorHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String text2, short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(41);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(42);
        }
        ClientHintManager.getCurrentInstance().showErrorHint(editor2, text2, position);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull String text2, @HintManager.PositionFlags short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(43);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(44);
        }
        this.showInformationHint(editor2, text2, null, position);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull String text2, @Nullable HyperlinkListener listener2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(45);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(46);
        }
        this.showInformationHint(editor2, text2, listener2, (short)1);
    }

    private void showInformationHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String text2, @Nullable HyperlinkListener listener2, @HintManager.PositionFlags short position) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(47);
        }
        if (text2 == null) {
            HintManagerImpl.$$$reportNull$$$0(48);
        }
        JComponent label2 = HintUtil.createInformationLabel(text2, listener2, null, null);
        this.showInformationHint(editor2, label2, position, null);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(49);
        }
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(50);
        }
        this.showInformationHint(editor2, component2, null);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2, @Nullable Runnable onHintHidden) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(51);
        }
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(52);
        }
        this.showInformationHint(editor2, component2, (short)1, onHintHidden);
    }

    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2, @HintManager.PositionFlags short position, @Nullable Runnable onHintHidden) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(53);
        }
        if (component2 == null) {
            HintManagerImpl.$$$reportNull$$$0(54);
        }
        ClientHintManager.getCurrentInstance().showInformationHint(editor2, component2, position, onHintHidden);
    }

    public void showErrorHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String hintText, int offset1, int offset2, short constraint, int flags, int timeout) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(55);
        }
        if (hintText == null) {
            HintManagerImpl.$$$reportNull$$$0(56);
        }
        JComponent label2 = HintUtil.createErrorLabel(hintText);
        LightweightHint hint = new LightweightHint(label2);
        VisualPosition pos1 = editor2.offsetToVisualPosition(offset1);
        VisualPosition pos2 = editor2.offsetToVisualPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor2, pos1, pos2, constraint);
        this.showEditorHint(hint, editor2, p, flags, timeout, false);
    }

    public void showQuestionHint(@NotNull Editor editor2, @NotNull String hintText, int offset1, int offset2, @NotNull QuestionAction action2) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(57);
        }
        if (hintText == null) {
            HintManagerImpl.$$$reportNull$$$0(58);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(59);
        }
        JComponent label2 = HintUtil.createQuestionLabel(hintText);
        LightweightHint hint = new LightweightHint(label2);
        this.showQuestionHint(editor2, offset1, offset2, hint, action2, (short)1);
    }

    public void showQuestionHint(@NotNull Editor editor2, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(60);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(61);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(62);
        }
        VisualPosition pos1 = editor2.offsetToVisualPosition(offset1);
        VisualPosition pos2 = editor2.offsetToVisualPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor2, pos1, pos2, constraint);
        this.showQuestionHint(editor2, p, offset1, offset2, hint, action2, constraint);
    }

    public void showQuestionHint(@NotNull Editor editor2, @NotNull Point p, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        if (editor2 == null) {
            HintManagerImpl.$$$reportNull$$$0(63);
        }
        if (p == null) {
            HintManagerImpl.$$$reportNull$$$0(64);
        }
        if (hint == null) {
            HintManagerImpl.$$$reportNull$$$0(65);
        }
        if (action2 == null) {
            HintManagerImpl.$$$reportNull$$$0(66);
        }
        ClientHintManager.getCurrentInstance().showQuestionHint(editor2, p, offset1, offset2, hint, action2, constraint);
    }

    public static HintHint createHintHint(Editor editor2, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint) {
        return HintManagerImpl.createHintHint(editor2, p, hint, constraint, false);
    }

    public static HintHint createHintHint(Editor editor2, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint, boolean createInEditorComponent) {
        JRootPane rootPane = editor2.getComponent().getRootPane();
        if (rootPane == null) {
            return new HintHint(editor2, p);
        }
        JLayeredPane lp = rootPane.getLayeredPane();
        HintHint hintInfo = new HintHint(editor2, SwingUtilities.convertPoint(lp, p, editor2.getContentComponent()));
        boolean showByBalloon = Registry.is((String)"editor.balloonHints");
        if (showByBalloon) {
            if (!createInEditorComponent) {
                hintInfo = new HintHint(lp, p);
            }
            hintInfo.setAwtTooltip(true).setHighlighterType(true);
        }
        hintInfo.initStyleFrom(hint.getComponent());
        if (showByBalloon) {
            hintInfo.setBorderColor((Color)new JBColor(Color.gray, (Color)Gray._140));
            hintInfo.setFont(hintInfo.getTextFont().deriveFont(0));
            hintInfo.setCalloutShift((int)((double)editor2.getLineHeight() * 0.1));
        }
        hintInfo.setPreferredPosition(Balloon.Position.above);
        if (constraint == 2 || constraint == 5) {
            hintInfo.setPreferredPosition(Balloon.Position.below);
        } else if (constraint == 4) {
            hintInfo.setPreferredPosition(Balloon.Position.atRight);
        } else if (constraint == 3) {
            hintInfo.setPreferredPosition(Balloon.Position.atLeft);
        }
        if (hint.isAwtTooltip()) {
            hintInfo.setAwtTooltip(true);
        }
        hintInfo.setPositionChangeShift(0, editor2.getLineHeight());
        return hintInfo;
    }

    boolean isEscapeHandlerEnabled() {
        return ClientHintManager.getCurrentInstance().isEscapeHandlerEnabled();
    }

    public boolean hideHints(int mask, boolean onlyOne, boolean editorChanged) {
        return ClientHintManager.getCurrentInstance().hideHints(mask, onlyOne, editorChanged);
    }

    static EditorHintListener getPublisher() {
        return EditorHintListenerHolder.ourEditorHintPublisher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: 
            case 11: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupBounds";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 26: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos1";
                break;
            }
            case 27: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos2";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/HintManagerImpl";
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintText";
                break;
            }
            case 59: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/HintManagerImpl";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showEditorHint";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getHintPosition";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHintPositionRelativeTo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getExternalComponent";
                break;
            }
            case 33: 
            case 34: {
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "_getHintPosition";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "showInformationHint";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "showQuestionHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyProjectManagerListener
    implements ProjectManagerListener {
        private MyProjectManagerListener() {
        }

        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                MyProjectManagerListener.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)HintManagerImpl.this.myEditorManagerListener);
        }

        public void projectClosed(@NotNull Project project) {
            if (project == null) {
                MyProjectManagerListener.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            TooltipController.getInstance().cancelTooltips();
            ApplicationManager.getApplication().invokeLater(() -> HintManagerImpl.this.hideHints(0, false, false));
            for (ClientHintManager instance2 : ClientHintManager.getAllInstances()) {
                instance2.onProjectClosed(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/codeInsight/hint/HintManagerImpl$MyProjectManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyEditorManagerListener.$$$reportNull$$$0(0);
            }
            HintManagerImpl.this.hideHints(0, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$MyEditorManagerListener", "selectionChanged"));
        }
    }

    static final class EditorHintListenerHolder {
        static final EditorHintListener ourEditorHintPublisher = (EditorHintListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorHintListener.TOPIC);

        private EditorHintListenerHolder() {
        }
    }

    static final class HintInfo {
        final LightweightHint hint;
        @HintManager.HideFlags
        final int flags;
        final boolean reviveOnEditorChange;

        HintInfo(LightweightHint hint, @HintManager.HideFlags int flags, boolean reviveOnEditorChange) {
            this.hint = hint;
            this.flags = flags;
            this.reviveOnEditorChange = reviveOnEditorChange;
        }
    }

    public static interface ActionToIgnore {
    }
}

