/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrevNextParameterHandler
extends EditorActionHandler {
    private final boolean myIsNextParameterHandler;

    public PrevNextParameterHandler(boolean isNextParameterHandler) {
        this.myIsNextParameterHandler = isNextParameterHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            PrevNextParameterHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            PrevNextParameterHandler.$$$reportNull$$$0(1);
        }
        if (!ParameterInfoControllerBase.existsForEditor(editor2)) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiElement exprList = PrevNextParameterHandler.getExpressionList(editor2, caret.getOffset(), project);
        if (exprList == null) {
            return false;
        }
        int lbraceOffset = exprList.getTextRange().getStartOffset();
        return ParameterInfoControllerBase.findControllerAtOffset(editor2, lbraceOffset) != null && ParameterInfoControllerBase.hasPrevOrNextParameter(editor2, lbraceOffset, this.myIsNextParameterHandler);
    }

    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
        int tabOutOffset;
        if (editor2 == null) {
            PrevNextParameterHandler.$$$reportNull$$$0(2);
        }
        int offset = caret != null ? caret.getOffset() : editor2.getCaretModel().getOffset();
        PsiElement exprList = PrevNextParameterHandler.getExpressionList(editor2, offset, dataContext);
        ParameterInfoControllerBase controller = exprList == null ? null : ParameterInfoControllerBase.findControllerAtOffset(editor2, exprList.getTextRange().getStartOffset());
        int paramOffset = controller == null ? -1 : controller.getPrevOrNextParameterOffset(this.myIsNextParameterHandler);
        boolean checkTabOut = this.myIsNextParameterHandler && CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
        int n = tabOutOffset = checkTabOut ? TabOutScopesTracker.getInstance().getScopeEndingAt(editor2, offset) : -1;
        if (paramOffset > offset && tabOutOffset > offset) {
            if (paramOffset < tabOutOffset) {
                tabOutOffset = -1;
            } else {
                paramOffset = -1;
            }
        }
        if (paramOffset != -1) {
            controller.moveToParameterAtOffset(paramOffset);
        } else if (tabOutOffset != -1) {
            TabOutScopesTracker.getInstance().removeScopeEndingAt(editor2, offset);
            if (caret != null) {
                caret.moveToOffset(tabOutOffset);
            } else {
                editor2.getCaretModel().moveToOffset(tabOutOffset);
            }
        }
    }

    @Nullable
    private static PsiElement getExpressionList(@NotNull Editor editor2, int offset, DataContext dataContext) {
        Project project;
        if (editor2 == null) {
            PrevNextParameterHandler.$$$reportNull$$$0(3);
        }
        return (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null ? PrevNextParameterHandler.getExpressionList(editor2, offset, project) : null;
    }

    @Nullable
    private static PsiElement getExpressionList(@NotNull Editor editor2, int offset, @NotNull Project project) {
        PsiFile file2;
        if (editor2 == null) {
            PrevNextParameterHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PrevNextParameterHandler.$$$reportNull$$$0(5);
        }
        return (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument())) != null ? (PsiElement)ParameterInfoControllerBase.findArgumentList(file2, offset, -1) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/PrevNextParameterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

